/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.renderer.shape.GeometryHandlerUtilities;
import org.geotools.renderer.shape.ScreenMap;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.renderer.shape.SimpleGeometry;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MultiPointHandler
implements ShapeHandler {
    private ShapeType type;
    private Envelope bbox;
    private MathTransform mt;
    private ScreenMap screenMap;
    private double spanx;
    private double spany;
    Logger LOGGER = ShapefileRenderer.LOGGER;

    public MultiPointHandler(ShapeType type, Envelope env, Rectangle screenSize, MathTransform mt, boolean hasOpacity) throws TransformException {
        this.type = type;
        this.bbox = env;
        this.mt = mt;
        if (mt != null) {
            this.screenMap = GeometryHandlerUtilities.calculateScreenSize(screenSize, hasOpacity);
            Point2D span = GeometryHandlerUtilities.calculateSpan(mt, 0, 0);
            this.spanx = span.getX();
            this.spany = span.getY();
        }
    }

    public ShapeType getShapeType() {
        return this.type;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return null;
        }
        Envelope geomBBox = GeometryHandlerUtilities.readBounds(buffer);
        if (!this.bbox.intersects(geomBBox)) {
            return null;
        }
        boolean bboxdecimate = geomBBox.getWidth() <= this.spanx && geomBBox.getHeight() <= this.spany;
        int numParts = buffer.getInt();
        double[][] coords = new double[numParts][];
        double[][] transformed = new double[numParts][];
        if (bboxdecimate) {
            coords = new double[][]{new double[2]};
            transformed = new double[][]{new double[2]};
            coords[0][0] = buffer.getDouble();
            coords[0][1] = buffer.getDouble();
            try {
                this.mt.transform(coords[0], 0, transformed[0], 0, 1);
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                transformed[0] = coords[0];
            }
            if (this.screenMap.get((int)transformed[0][0], (int)transformed[0][1])) {
                this.LOGGER.finest("Point already rendered" + transformed[0][0] + " " + transformed[0][1]);
                return null;
            }
            this.screenMap.set((int)transformed[0][0], (int)transformed[0][1], true);
        } else {
            int partsInBBox = 0;
            for (int part = 0; part < numParts; ++part) {
                coords[part] = new double[2];
                coords[part][0] = buffer.getDouble();
                coords[part][1] = buffer.getDouble();
                if (!this.bbox.contains(coords[part][0], coords[part][1])) continue;
                if (!this.mt.isIdentity()) {
                    try {
                        transformed[partsInBBox] = new double[2];
                        this.mt.transform(coords[part], 0, transformed[partsInBBox], 0, 1);
                    }
                    catch (Exception e) {
                        ShapefileRenderer.LOGGER.severe("could not transform coordinates " + e.getLocalizedMessage());
                        transformed[partsInBBox] = coords[part];
                    }
                } else {
                    transformed[partsInBBox] = new double[2];
                    System.arraycopy(coords[part], 0, transformed[partsInBBox], 0, 1);
                }
                if (this.screenMap.get((int)transformed[partsInBBox][0], (int)transformed[partsInBBox][1])) continue;
                ++partsInBBox;
            }
            if (partsInBBox == 0) {
                return null;
            }
            if (partsInBBox != numParts) {
                double[][] tmp = new double[partsInBBox][];
                System.arraycopy(transformed, 0, tmp, 0, partsInBBox);
                transformed = tmp;
            }
        }
        return new SimpleGeometry(type, transformed, geomBBox);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        throw new UnsupportedOperationException("This handler is only for reading");
    }

    public int getLength(Object geometry) {
        return 0;
    }
}

