/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.unijena.jams.JAMS;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.io.JAMSTableDataArray;
import org.unijena.jams.io.JAMSTableDataConverter;
import org.unijena.jams.io.JAMSTableDataStore;

public class GenericDataReader
implements JAMSTableDataStore {
    BufferedReader reader;
    String fileName;
    boolean timeParse;
    String nextString = "";
    boolean active = false;
    private String[] metadata;
    private JAMSTableDataArray current = null;

    public GenericDataReader(String fileName, boolean timeParse, int startMeta, int startData) {
        this.fileName = fileName;
        this.timeParse = timeParse;
        this.createReader();
        if (startMeta > 0 && startData > startMeta) {
            this.parseMetadata(startMeta, startData);
        } else {
            this.parseMetadata();
        }
    }

    public GenericDataReader(String fileName, boolean timeParse, int startData) {
        this.fileName = fileName;
        this.timeParse = timeParse;
        this.createReader();
        for (int i = 0; i < startData; ++i) {
            this.active = false;
            this.update();
        }
    }

    public GenericDataReader(String fileName, boolean timeParse) {
        this(fileName, timeParse, 0, 0);
    }

    private void createReader() {
        try {
            this.reader = new BufferedReader(new FileReader(this.fileName));
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }

    private void parseMetadata() {
        String hold = "";
        this.update();
        while (this.nextString.startsWith("#")) {
            this.active = false;
            hold = this.nextString;
            this.update();
        }
        StringTokenizer st = new StringTokenizer(hold.substring(1), "\t");
        if (this.timeParse) {
            st.nextToken();
        }
        int n = st.countTokens();
        String[] metadata = new String[n];
        for (int i = 0; i < n; ++i) {
            metadata[i] = st.nextToken();
        }
        this.metadata = metadata;
    }

    private void parseMetadata(int startMeta, int startData) {
        int i;
        for (int i2 = 0; i2 < startMeta; ++i2) {
            this.active = false;
            this.update();
        }
        StringTokenizer st = new StringTokenizer(this.nextString, "\t");
        if (this.timeParse) {
            st.nextToken();
        }
        int n = st.countTokens();
        String[] metadata = new String[n];
        for (i = 0; i < n; ++i) {
            metadata[i] = st.nextToken();
        }
        this.metadata = metadata;
        for (i = startMeta; i < startData; ++i) {
            this.active = false;
            this.update();
        }
    }

    private void update() {
        if (!this.active) {
            try {
                this.nextString = this.reader.readLine();
            }
            catch (IOException ioex) {
                JAMS.handle(ioex);
            }
            this.active = true;
        }
    }

    @Override
    public JAMSTableDataArray getCurrent() {
        return this.current;
    }

    @Override
    public JAMSTableDataArray getNext() {
        JAMSCalendar time;
        this.update();
        this.active = false;
        StringTokenizer st = new StringTokenizer(this.nextString, "\t");
        if (this.timeParse) {
            String timeString = st.nextToken();
            timeString = timeString + " " + st.nextToken();
            time = JAMSTableDataConverter.parseTime(timeString);
        } else {
            time = null;
        }
        int n = st.countTokens();
        String[] values = new String[n];
        for (int i = 0; i < n; ++i) {
            values[i] = st.nextToken();
        }
        this.current = new JAMSTableDataArray(time, values);
        return this.current;
    }

    @Override
    public boolean hasNext() {
        this.update();
        return this.nextString != null;
    }

    @Override
    public String[] getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            JAMS.handle(ioe);
        }
    }
}

