/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.unijena.jams.JAMS;
import org.unijena.jams.JAMSProperty;

public class JAMSProperties
extends Observable {
    public static final String DEFAULT_FILENAME = "default.jap";
    public static final String MODEL_IDENTIFIER = "model";
    public static final String LIBS_IDENTIFIER = "libs";
    public static final String SERVER_IDENTIFIER = "server";
    public static final String SERVER_ACCOUNT_IDENTIFIER = "serveraccount";
    public static final String SERVER_PASSWORD_IDENTIFIER = "serverpassword";
    public static final String SERVER_EXCLUDES_IDENTIFIER = "excludes";
    public static final String WORKSPACE_IDENTIFIER = "workspace";
    private Properties properties = new Properties();
    private String defaultFilename = "";
    private HashMap<String, JAMSProperty> propertyMap = new HashMap();

    public JAMSProperties() {
    }

    public JAMSProperties(Properties properties) {
        this.properties = properties;
    }

    public void load(String fileName) throws IOException {
        try {
            this.properties.load(new FileInputStream(fileName));
            this.defaultFilename = fileName;
            for (Object key : this.properties.keySet()) {
                JAMSProperty property = this.propertyMap.get(key);
                if (property == null) {
                    property = new JAMSProperty((String)key);
                    this.propertyMap.put((String)key, property);
                }
                property.setChanged();
                property.notifyObservers();
            }
        }
        catch (Exception ex) {
            JAMS.handle(ex);
        }
    }

    public void save(String fileName) throws IOException {
        try {
            this.properties.store(new FileOutputStream(fileName), "JAMS configuration file");
            this.defaultFilename = fileName;
        }
        catch (Exception ex) {
            JAMS.handle(ex);
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperty(key) != null) {
            return this.getProperty(key);
        }
        return defaultValue;
    }

    public void setProperty(String key, String value) {
        JAMSProperty property = this.propertyMap.get(key);
        if (property == null) {
            property = new JAMSProperty(key);
            this.propertyMap.put(key, property);
        }
        this.properties.setProperty(key, value);
        property.setChanged();
        property.notifyObservers();
    }

    public void addObserver(String key, Observer obs) {
        JAMSProperty property = this.propertyMap.get(key);
        if (property == null) {
            property = new JAMSProperty(key);
            this.propertyMap.put(key, property);
        }
        property.addObserver(obs);
    }

    public String toString() {
        return this.properties.toString();
    }

    public static JAMSProperties createJAMSProperties() {
        Properties p = new Properties();
        p.setProperty(MODEL_IDENTIFIER, "");
        p.setProperty(LIBS_IDENTIFIER, "lib");
        p.setProperty("debug", "1");
        p.setProperty("verbose", "0");
        p.setProperty("infolog", "");
        p.setProperty("errorlog", "");
        p.setProperty("errordlg", "1");
        p.setProperty("windowenable", "1");
        p.setProperty("windowwidth", "900");
        p.setProperty("windowheight", "600");
        p.setProperty("guiconfig", "1");
        p.setProperty("guiconfigwidth", "600");
        p.setProperty("guiconfigheight", "600");
        JAMSProperties jp = new JAMSProperties(p);
        jp.setDefaultFilename(System.getProperty("user.dir") + System.getProperty("file.separator") + DEFAULT_FILENAME);
        return jp;
    }

    public String getDefaultFilename() {
        return this.defaultFilename;
    }

    public void setDefaultFilename(String defaultFilename) {
        this.defaultFilename = defaultFilename;
    }
}

