/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer;

import jams.components.efficiencies.NashSutcliffe;
import jams.components.efficiencies.VolumeError;
import jams.components.optimizer.SCE_Comparator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class SCE
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="objective function name")
    public JAMSString effMethodName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the prediction series")
    public JAMSDoubleArray prediction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the observation series")
    public JAMSDoubleArray observation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximize efficiency?")
    public JAMSInteger MaximizeEff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="number of complexes")
    public JAMSInteger NumberOfComplexes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximum runs")
    public JAMSInteger maxn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="kstop")
    public JAMSInteger kstop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="pcento")
    public JAMSDouble pcento;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="peps")
    public JAMSDouble peps;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Flag for enabling/disabling this sampler")
    public JAMSBoolean enable;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString sceFileName;
    JAMSDouble[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator = new Random();
    GenericDataWriter writer;
    static final int MAXIMIZATION = 1;
    static final int MINIMIZATION = 2;
    static final int ABSMAXIMIZATION = 3;
    static final int ABSMINIMIZATION = 4;
    int N;
    int p;
    int s;
    int m;
    int icall = 0;

    public void init() {
        if (this.enable.getValue()) {
            String key;
            this.icall = 0;
            StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
            this.parameters = new JAMSDouble[tok.countTokens()];
            this.parameterNames = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                this.parameterNames[i] = key = tok.nextToken();
                this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
                ++i;
            }
            tok = new StringTokenizer(this.boundaries.getValue(), ";");
            int n = tok.countTokens();
            this.lowBound = new double[n];
            this.upBound = new double[n];
            if (n != i) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
            }
            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                key = key.substring(1, key.length() - 1);
                StringTokenizer boundTok = new StringTokenizer(key, ">");
                this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
                this.upBound[i] = Double.parseDouble(boundTok.nextToken());
                if (this.upBound[i] <= this.lowBound[i]) {
                    this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
                }
                ++i;
            }
            this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.sceFileName.getValue());
            this.writer.addComment("SCE output");
            for (int p = 0; p < this.parameterNames.length; ++p) {
                this.writer.addColumn(this.parameterNames[p]);
            }
            this.writer.addColumn(this.effMethodName.getValue());
            this.writer.addColumn("model runs");
            this.writer.writeHeader();
            this.writer.flush();
        }
    }

    public double Custom_rand() {
        return this.generator.nextDouble();
    }

    private double[] RandomSampler() {
        int paras = this.parameterNames.length;
        double[] sample = new double[paras];
        for (int i = 0; i < paras; ++i) {
            double d = this.Custom_rand();
            sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    private void singleRun() {
        JAMSComponent comp;
        ++this.icall;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void disabledRun() {
        JAMSComponent comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (IOException e) {
                System.out.println(comp.getInstanceName());
                e.printStackTrace();
            }
            catch (Exception exception) {}
        }
    }

    private boolean IsSampleValid(double[] sample) {
        JAMSDouble[] conv_sample = new JAMSDouble[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            conv_sample[i] = new JAMSDouble(sample[i]);
        }
        return this.IsSampleValid(conv_sample);
    }

    private boolean IsSampleValid(JAMSDouble[] sample) {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0.0;
        for (int i = 0; i < paras; ++i) {
            if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public double funct(double[] x) {
        double value = 0.0;
        for (int j = 0; j < this.parameters.length; ++j) {
            this.parameters[j].setValue(x[j]);
        }
        this.singleRun();
        ++this.currentCount;
        double[] preArr = this.prediction.getValue();
        double[] obsArr = this.observation.getValue();
        Vector<Double> obsVector = new Vector<Double>();
        Vector<Double> preVector = new Vector<Double>();
        for (int i = 0; i < preArr.length; ++i) {
            if (!(preArr[i] > -9999.0) || !(obsArr[i] > -9999.0)) continue;
            obsVector.add(obsArr[i]);
            preVector.add(preArr[i]);
        }
        int dataCount = obsVector.size();
        obsArr = new double[dataCount];
        preArr = new double[dataCount];
        for (int i = 0; i < dataCount; ++i) {
            obsArr[i] = (Double)obsVector.get(i);
            preArr[i] = (Double)preVector.get(i);
        }
        if (this.effMethodName.getValue().equals("e2")) {
            return -1.0 * NashSutcliffe.efficiency(preArr, obsArr, 2.0);
        }
        if (this.effMethodName.getValue().equals("e1")) {
            return -1.0 * NashSutcliffe.efficiency(preArr, obsArr, 1.0);
        }
        if (this.effMethodName.getValue().equals("le2")) {
            return -1.0 * NashSutcliffe.logEfficiency(preArr, obsArr, 2.0);
        }
        if (this.effMethodName.getValue().equals("pbias")) {
            return Math.abs(VolumeError.pbias(obsArr, preArr));
        }
        return -9999.0;
    }

    public void sort(double[][] x, double[] xf) {
        if (x.length == 0) {
            return;
        }
        int n = x[0].length;
        double[][] t = new double[x.length][n + 1];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < n; ++j) {
                t[i][j] = x[i][j];
            }
            t[i][n] = xf[i];
        }
        SCE_Comparator comparator = new SCE_Comparator(n, false);
        Arrays.sort(t, comparator);
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < n; ++j) {
                x[i][j] = t[i][j];
            }
            xf[i] = t[i][n];
        }
    }

    public void sort(int[] x) {
        Arrays.sort(x);
    }

    public double NormalizedgeometricRange(double[][] x, double[] bound) {
        if (x.length == 0) {
            return 0.0;
        }
        int n = x[0].length;
        double[] min = new double[n];
        double[] max = new double[n];
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            min[i] = Double.POSITIVE_INFINITY;
            max[i] = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < x.length; ++j) {
                if (x[j][i] < min[i]) {
                    min[i] = x[j][i];
                }
                if (!(x[j][i] > max[i])) continue;
                max[i] = x[j][i];
            }
            mean += Math.log(max[i] - min[i]) / bound[i];
        }
        return Math.exp(mean /= (double)n);
    }

    public double[] std(double[][] x) {
        int j;
        if (x.length == 0) {
            return null;
        }
        if (x.length == 1) {
            return null;
        }
        int n = x[0].length;
        double[] mean = new double[n];
        double[] var = new double[n];
        int i = 0;
        while (i < n) {
            mean[i] = 0.0;
            for (j = 0; j < x.length; ++j) {
                int n2 = i;
                mean[n2] = mean[n2] + x[j][i];
            }
            int n3 = i++;
            mean[n3] = mean[n3] / (double)n;
        }
        for (i = 0; i < n; ++i) {
            var[i] = 0.0;
            for (j = 0; j < x.length; ++j) {
                int n4 = i;
                var[n4] = var[n4] + (mean[i] - x[j][i]) * (mean[i] - x[j][i]);
            }
            var[i] = Math.sqrt(var[i]) / (double)(n - 1);
        }
        return var;
    }

    public int find(int[] lcs, int startindex, int endindex, int value) {
        for (int i = startindex; i < endindex; ++i) {
            if (lcs[i] != value) continue;
            return i;
        }
        return -1;
    }

    public double[] cceua(double[][] s, double[] sf, double[] bl, double[] bu) {
        double fnew;
        int nps = s.length;
        int nopt = s[0].length;
        int n = nps;
        int m = nopt;
        double alpha = 1.0;
        double beta = 0.5;
        double[] sb = new double[nopt];
        double[] sw = new double[nopt];
        double fb = sf[0];
        double fw = sf[n - 1];
        for (int i = 0; i < nopt; ++i) {
            sb[i] = s[0][i];
            sw[i] = s[n - 1][i];
        }
        double[] ce = new double[nopt];
        int i = 0;
        while (i < nopt) {
            ce[i] = 0.0;
            for (int j = 0; j < n - 1; ++j) {
                int n2 = i;
                ce[n2] = ce[n2] + s[j][i];
            }
            int n3 = i++;
            ce[n3] = ce[n3] / (double)(n - 1);
        }
        double[] snew = new double[nopt];
        for (int i2 = 0; i2 < nopt; ++i2) {
            snew[i2] = ce[i2] + alpha * (ce[i2] - sw[i2]);
        }
        int ibound = 0;
        for (int i3 = 0; i3 < nopt; ++i3) {
            if (snew[i3] - bl[i3] < 0.0) {
                ibound = 1;
            }
            if (!(bu[i3] - snew[i3] < 0.0)) continue;
            ibound = 2;
        }
        if (ibound >= 1) {
            snew = this.RandomSampler();
        }
        if ((fnew = this.funct(snew)) > fw) {
            for (int i4 = 0; i4 < nopt; ++i4) {
                snew[i4] = sw[i4] + beta * (ce[i4] - sw[i4]);
            }
            fnew = this.funct(snew);
        }
        if (fnew > fw) {
            snew = this.RandomSampler();
            fnew = this.funct(snew);
        }
        double[] result = new double[nopt + 1];
        for (int i5 = 0; i5 < nopt; ++i5) {
            result[i5] = snew[i5];
        }
        result[nopt] = fnew;
        return result;
    }

    public double[] sceua(double[] x0, double[] bl, double[] bu, int maxn, int kstop, double pcento, double peps, int ngs, int iseed, int iniflg) {
        try {
            int i;
            int nopt = x0.length;
            int npg = 2 * nopt + 1;
            int nps = nopt + 1;
            int nspl = npg;
            int mings = ngs;
            int npt = npg * ngs;
            double[] bound = new double[nopt];
            for (int i2 = 0; i2 < nopt; ++i2) {
                bound[i2] = bu[i2] - bl[i2];
            }
            double[][] x = new double[npt][nopt];
            for (int i3 = 0; i3 < npt; ++i3) {
                x[i3] = this.RandomSampler();
            }
            if (iniflg == 1) {
                x[0] = x0;
            }
            int nloop = 0;
            double[] xf = new double[npt];
            for (int i4 = 0; i4 < npt; ++i4) {
                xf[i4] = this.funct(x[i4]);
            }
            double f0 = xf[0];
            this.sort(x, xf);
            double[] bestx = new double[nopt];
            double[] worstx = new double[nopt];
            for (int i5 = 0; i5 < nopt; ++i5) {
                bestx[i5] = x[0][i5];
                worstx[i5] = x[npt - 1][i5];
            }
            double bestf = xf[0];
            double worstf = xf[npt - 1];
            double[] xnstd = this.std(x);
            double gnrng = this.NormalizedgeometricRange(x, bound);
            System.out.println("The Inital Loop: 0");
            System.out.println("BestF: " + bestf);
            System.out.print("BestX");
            for (i = 0; i < nopt; ++i) {
                System.out.print("\t\t" + bestx[i]);
            }
            for (i = 0; i < nopt; ++i) {
                this.writer.addData((Object)bestx[i]);
            }
            this.writer.addData((Object)bestf);
            this.writer.addData((Object)this.currentCount);
            this.writer.writeData();
            this.writer.flush();
            System.out.println("");
            System.out.println("WorstF: " + worstf);
            System.out.print("WorstX");
            for (i = 0; i < nopt; ++i) {
                System.out.print("\t\t" + worstx[i]);
            }
            System.out.println("");
            if (this.icall >= maxn) {
                System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                System.out.println("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
                System.out.println("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + this.icall);
                System.out.println("OF THE INITIAL LOOP!");
                this.writer.writeLine("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                this.writer.writeLine("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
                this.writer.writeLine("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + this.icall);
                this.writer.writeLine("OF THE INITIAL LOOP!");
                this.writer.flush();
            }
            if (gnrng < peps) {
                this.writer.writeLine("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                this.writer.flush();
            }
            nloop = 0;
            double[] criter = new double[kstop];
            double criter_change = 100000.0;
            while (this.icall < maxn && gnrng > peps && criter_change > pcento) {
                int i6;
                ++nloop;
                for (int igs = 0; igs < ngs; ++igs) {
                    int i7;
                    int[] k1 = new int[npg];
                    int[] k2 = new int[npg];
                    for (int i8 = 0; i8 < npg; ++i8) {
                        k1[i8] = i8;
                        k2[i8] = k1[i8] * ngs + igs;
                    }
                    double[][] cx = new double[npg][nopt];
                    double[] cf = new double[npg];
                    for (i7 = 0; i7 < npg; ++i7) {
                        for (int j = 0; j < nopt; ++j) {
                            cx[k1[i7]][j] = x[k2[i7]][j];
                        }
                        cf[k1[i7]] = xf[k2[i7]];
                    }
                    for (int loop = 0; loop < nspl; ++loop) {
                        int i9;
                        int[] lcs = new int[nps];
                        lcs[0] = 0;
                        for (int k3 = 1; k3 < nps; ++k3) {
                            int idx;
                            int lpos = 0;
                            for (int iter = 0; iter < 1000 && (idx = this.find(lcs, 0, k3, lpos = (int)Math.floor((double)npg + 0.5 - Math.sqrt(((double)npg + 0.5) * ((double)npg + 0.5) - (double)(npg * (npg + 1)) * this.Custom_rand())))) != -1; ++iter) {
                            }
                            lcs[k3] = lpos;
                        }
                        this.sort(lcs);
                        double[][] s = new double[nps][nopt];
                        double[] sf = new double[nps];
                        for (int i10 = 0; i10 < nps; ++i10) {
                            for (int j = 0; j < nopt; ++j) {
                                s[i10][j] = cx[lcs[i10]][j];
                            }
                            sf[i10] = cf[lcs[i10]];
                        }
                        double[] snew = new double[nopt];
                        double[] xnew = this.cceua(s, sf, bl, bu);
                        for (i9 = 0; i9 < nopt; ++i9) {
                            snew[i9] = xnew[i9];
                        }
                        double fnew = xnew[nopt];
                        s[nps - 1] = snew;
                        sf[nps - 1] = fnew;
                        for (i9 = 0; i9 < nps; ++i9) {
                            for (int j = 0; j < nopt; ++j) {
                                cx[lcs[i9]][j] = s[i9][j];
                            }
                            cf[lcs[i9]] = sf[i9];
                        }
                        this.sort(cx, cf);
                    }
                    for (i7 = 0; i7 < npg; ++i7) {
                        for (int j = 0; j < nopt; ++j) {
                            x[k2[i7]][j] = cx[k1[i7]][j];
                        }
                        xf[k2[i7]] = cf[k1[i7]];
                    }
                }
                this.sort(x, xf);
                for (i6 = 0; i6 < nopt; ++i6) {
                    bestx[i6] = x[0][i6];
                    worstx[i6] = x[nopt - 1][i6];
                }
                bestf = xf[0];
                worstf = xf[npt - 1];
                xnstd = this.std(x);
                gnrng = this.NormalizedgeometricRange(x, bound);
                System.out.println("Evolution Loop:" + nloop + " - Trial - " + this.icall);
                System.out.println("BESTF:" + bestf);
                System.out.print("BESTX:");
                for (i6 = 0; i6 < nopt; ++i6) {
                    System.out.print("\t" + bestx[i6]);
                }
                for (i6 = 0; i6 < nopt; ++i6) {
                    this.writer.addData((Object)bestx[i6]);
                }
                this.writer.addData((Object)bestf);
                this.writer.addData((Object)this.currentCount);
                this.writer.writeData();
                this.writer.flush();
                System.out.println("\nWORSTF:" + worstf);
                System.out.print("WORSTX:");
                for (i6 = 0; i6 < nopt; ++i6) {
                    System.out.print("\t" + worstx[i6]);
                }
                System.out.println("");
                if (this.icall >= maxn) {
                    System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                    System.out.println("ON THE MAXIMUM NUMBER OF TRIALS " + maxn + " HAS BEEN EXCEEDED!");
                    this.writer.writeLine("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
                    this.writer.writeLine("ON THE MAXIMUM NUMBER OF TRIALS " + maxn + " HAS BEEN EXCEEDED!");
                    this.writer.flush();
                }
                if (gnrng < peps) {
                    System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                    this.writer.writeLine("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                    this.writer.flush();
                }
                for (i6 = 0; i6 < kstop - 1; ++i6) {
                    criter[i6] = criter[i6 + 1];
                }
                criter[kstop - 1] = bestf;
                if (nloop < kstop) continue;
                criter_change = Math.abs(criter[0] - criter[kstop - 1]) * 100.0;
                double criter_mean = 0.0;
                for (int i11 = 0; i11 < kstop; ++i11) {
                    criter_mean += Math.abs(criter[i11]);
                }
                if (!((criter_change /= (criter_mean /= (double)kstop)) < pcento)) continue;
                System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
                System.out.println("LESS THAN THE THRESHOLD " + pcento + "%");
                System.out.println("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");
                this.writer.writeLine("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
                this.writer.writeLine("LESS THAN THE THRESHOLD " + pcento + "%");
                this.writer.writeLine("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");
                this.writer.flush();
            }
            System.out.println("SEARCH WAS STOPPED AT TRIAL NUMBER: " + this.icall);
            System.out.println("NORMALIZED GEOMETRIC RANGE = " + gnrng);
            System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");
            this.writer.writeLine("SEARCH WAS STOPPED AT TRIAL NUMBER: " + this.icall);
            this.writer.writeLine("NORMALIZED GEOMETRIC RANGE = " + gnrng);
            this.writer.writeLine("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");
            this.writer.flush();
            double[] retVal = new double[nopt + 1];
            for (int i12 = 0; i12 < nopt; ++i12) {
                retVal[i12] = bestx[i12];
            }
            retVal[nopt] = bestf;
            return retVal;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.disabledRun();
            return;
        }
        int maxn = this.maxn.getValue();
        int kstop = this.kstop.getValue();
        double pcento = this.pcento.getValue();
        double peps = this.peps.getValue();
        int iseed = 10;
        int iniflg = 0;
        System.out.println("Pcento: " + pcento);
        double[] x0 = this.RandomSampler();
        double[] bestpoint = this.sceua(x0, this.lowBound, this.upBound, maxn, kstop, pcento, peps, this.NumberOfComplexes.getValue(), iseed, iniflg);
        double[] bestx = new double[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            bestx[i] = bestpoint[i];
        }
        double bestf = bestpoint[this.parameters.length];
    }

    public void cleanup() {
        if (this.enable.getValue()) {
            this.writer.close();
        }
    }
}

