/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree.memory;

import org.geotools.index.DataDefinition;
import org.geotools.index.LockManager;
import org.geotools.index.TreeException;
import org.geotools.index.rtree.Entry;
import org.geotools.index.rtree.Node;
import org.geotools.index.rtree.PageStore;
import org.geotools.index.rtree.memory.MemoryNode;

public class MemoryPageStore
extends PageStore {
    private static final int DEF_MAX = 50;
    private static final int DEF_MIN = 25;
    private static final short DEF_SPLIT = 1;
    private LockManager lockManager = new LockManager();
    private Node root = null;

    public MemoryPageStore(DataDefinition def) throws TreeException {
        this(def, 50, 25, 1);
    }

    public MemoryPageStore(DataDefinition def, int max, int min, short split) throws TreeException {
        super(def, max, min, split);
        this.root = new MemoryNode(max);
        this.root.setLeaf(true);
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) throws TreeException {
        this.root = node;
        this.root.setParent(null);
    }

    public Node getEmptyNode(boolean isLeaf) {
        MemoryNode ret = new MemoryNode(this.maxNodeEntries);
        ret.setLeaf(isLeaf);
        return ret;
    }

    public Node getNode(Entry parentEntry, Node parent) throws TreeException {
        Node ret = (Node)parentEntry.getData();
        ret.setParent(parent);
        return ret;
    }

    public Entry createEntryPointingNode(Node node) {
        return new Entry(node.getBounds(), node);
    }

    public void free(Node node) {
    }

    public void close() throws TreeException {
        this.root = null;
    }
}

