/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.FidFilterParserVisitor;
import org.geotools.data.shapefile.indexed.FidIndexer;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedFidWriter;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.indexed.ShapeFIDReader;
import org.geotools.data.shapefile.indexed.ShapeFileIndexer;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterVisitor;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.UnsupportedFilterException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.index.rtree.FilterConsumer;
import org.geotools.index.rtree.RTree;
import org.geotools.index.rtree.fs.FileSystemPageStore;
import org.geotools.xml.gml.GMLSchema;

public class IndexedShapefileDataStore
extends ShapefileDataStore {
    public static final byte TREE_NONE = 0;
    public static final byte TREE_GRX = 1;
    public static final byte TREE_QIX = 2;
    private static final Object FIX_LOCK = new Object();
    private static final Object GRX_LOCK = new Object();
    private static final Object QIX_LOCK = new Object();
    final URL treeURL;
    public URL fixURL;
    byte treeType;
    boolean createIndex;
    final boolean useIndex;
    private RTree rtree;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public IndexedShapefileDataStore(URL url) throws MalformedURLException {
        this(url, null, false, true, 2);
    }

    public IndexedShapefileDataStore(URL url, URI namespace) throws MalformedURLException {
        this(url, namespace, false, true, 2);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer) throws MalformedURLException {
        this(url, namespace, useMemoryMappedBuffer, true, 2);
    }

    public IndexedShapefileDataStore(URL url, boolean useMemoryMappedBuffer) throws MalformedURLException {
        this(url, null, useMemoryMappedBuffer, true, 2);
    }

    public IndexedShapefileDataStore(URL url, boolean useMemoryMappedBuffer, boolean createIndex) throws MalformedURLException {
        this(url, null, useMemoryMappedBuffer, createIndex, 2);
    }

    public IndexedShapefileDataStore(URL url, URI namespace, boolean useMemoryMappedBuffer, boolean createIndex, byte treeType) throws MalformedURLException {
        super(url, namespace);
        String filename = null;
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.getFile(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        String shpext = ".shp";
        String dbfext = ".dbf";
        String shxext = ".shx";
        String grxext = ".grx";
        String qixext = ".qix";
        String fixext = ".fix";
        if (filename.endsWith(shpext) || filename.endsWith(dbfext) || filename.endsWith(shxext)) {
            filename = filename.substring(0, filename.length() - 4);
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            shpext = ".SHP";
            dbfext = ".DBF";
            shxext = ".SHX";
            grxext = ".GRX";
            qixext = ".QIX";
            fixext = ".FIX";
        }
        this.treeType = treeType;
        this.useMemoryMappedBuffer = new File(this.shpURL.getFile()).exists() && useMemoryMappedBuffer;
        boolean bl = this.useIndex = treeType != 0 && this.isLocal();
        if (this.isLocal()) {
            this.fixURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), filename + fixext);
            if (treeType == 2) {
                this.treeURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), filename + qixext);
                this.treeType = (byte)2;
                LOGGER.fine("Using qix tree");
            } else if (treeType == 1) {
                this.treeURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), filename + grxext);
                LOGGER.fine("Using grx tree");
            } else {
                this.treeURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), filename + qixext);
                this.treeType = 0;
            }
            this.createIndex = new File(new File(this.treeURL.getFile()).getParent()).canWrite() && createIndex && this.useIndex;
        } else {
            this.treeURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), filename + qixext);
            this.treeType = 0;
            this.createIndex = false;
            this.fixURL = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.rtree != null) {
            try {
                this.rtree.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.severe("org.geotools.data.shapefile.indexed.IndexedShapeFileDataStore#finalize(): Error closing rtree. " + e.getLocalizedMessage());
            }
        }
    }

    public boolean isLocal() {
        return this.shpURL.getProtocol().equals("file");
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        if (filter instanceof FidFilter && this.fixURL != null) {
            return Filter.NONE;
        }
        return filter;
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            return super.getFeatureWriterAppend(typeName, transaction);
        }
        FeatureWriter writer = this.state(transaction).writer(typeName, Filter.ALL);
        if (this.getLockingManager() != null) {
            writer = ((InProcessLockingManager)this.getLockingManager()).checkedWriter(writer, transaction);
        }
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                state = new TransactionStateDiff((AbstractDataStore)this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    protected FeatureReader getFeatureReader(String typeName, Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            return new EmptyFeatureReader(this.getSchema());
        }
        String[] propertyNames = query.getPropertyNames() == null ? new String[]{} : query.getPropertyNames();
        String defaultGeomName = this.schema.getDefaultGeometry().getName();
        FilterAttributeExtractor fae = new FilterAttributeExtractor();
        query.getFilter().accept((FilterVisitor)fae);
        HashSet<String> attributes = new HashSet<String>(Arrays.asList(propertyNames));
        attributes.addAll(fae.getAttributeNameSet());
        FeatureType newSchema = this.schema;
        boolean readDbf = true;
        boolean readGeometry = true;
        propertyNames = attributes.toArray(new String[attributes.size()]);
        try {
            if (query.getPropertyNames() != null && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName)) {
                readDbf = false;
                newSchema = DataUtilities.createSubType((FeatureType)this.schema, (String[])propertyNames);
            } else if (query.getPropertyNames() != null && propertyNames.length == 0) {
                readDbf = false;
                readGeometry = false;
                newSchema = DataUtilities.createSubType((FeatureType)this.schema, (String[])propertyNames);
            }
            return this.createFeatureReader(typeName, this.getAttributesReader(readDbf, readGeometry, query.getFilter()), newSchema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", (Throwable)se);
        }
    }

    protected FeatureReader createFeatureReader(String typeName, Reader r, FeatureType readerSchema) throws SchemaException, IOException {
        if (this.isLocal() && this.fixURL != null) {
            if (!new File(this.fixURL.getFile()).exists()) {
                this.fixURL = FidIndexer.generate(this.shpURL);
            }
            if (this.fixURL == null) {
                return new FIDFeatureReader((AttributeReader)r, (FIDReader)new ShapeFIDReader(this.getCurrentTypeName(), r), readerSchema);
            }
            return new FIDFeatureReader((AttributeReader)r, (FIDReader)new IndexedFidReader(this.getCurrentTypeName(), r, this.getReadChannel(this.fixURL)), readerSchema);
        }
        return new FIDFeatureReader((AttributeReader)r, (FIDReader)new ShapeFIDReader(this.getCurrentTypeName(), r), readerSchema);
    }

    protected Reader getAttributesReader(boolean readDbf, boolean readGeometry, Filter filter) throws IOException {
        Envelope bbox = null;
        Collection goodRecs = null;
        if (filter instanceof FidFilter && this.fixURL != null) {
            FidFilter fidFilter = (FidFilter)filter;
            goodRecs = this.queryFidIndex(fidFilter.getFids());
        } else {
            if (filter != null) {
                FilterConsumer fc = new FilterConsumer();
                filter.accept((FilterVisitor)fc);
                bbox = fc.getBounds();
            }
            if (bbox != null && this.useIndex) {
                try {
                    goodRecs = this.queryTree(bbox);
                }
                catch (TreeException e) {
                    throw new IOException("Error querying index: " + e.getMessage());
                }
            }
        }
        AttributeType[] atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeTypes();
        IndexedDbaseFileReader dbfR = null;
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new AttributeType[]{this.schema.getDefaultGeometry()};
            if (!readGeometry) {
                atts = new AttributeType[]{};
            }
        } else {
            dbfR = (IndexedDbaseFileReader)this.openDbfReader();
        }
        return new Reader(atts, this.openShapeReader(), dbfR, goodRecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List queryFidIndex(String[] fids) throws IOException {
        Arrays.sort(fids);
        IndexedFidReader reader = null;
        try {
            File indexFile = new File(this.fixURL.getFile());
            if (this.isLocal()) {
                Object object = FIX_LOCK;
                synchronized (object) {
                    if (indexFile.exists() && !this.isIndexed(this.fixURL) && !indexFile.delete()) {
                        indexFile.deleteOnExit();
                        this.fixURL = null;
                        return null;
                    }
                    if (!indexFile.exists()) {
                        FidIndexer.generate(this.shpURL);
                    }
                }
            } else {
                return null;
            }
            if (!indexFile.exists()) {
                this.fixURL = null;
                return null;
            }
            reader = new IndexedFidReader(this.getCurrentTypeName(), this.getReadChannel(this.fixURL));
            if ((long)reader.getRemoves() >= reader.getCount() / 2L) {
                indexFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            this.fixURL = null;
            return null;
        }
        ArrayList<Data> records = new ArrayList<Data>(fids.length);
        try {
            IndexFile shx = this.openIndexFile(this.shxURL);
            try {
                DataDefinition def = new DataDefinition("US-ASCII");
                def.addField(Integer.class);
                def.addField(Long.class);
                for (int i = 0; i < fids.length; ++i) {
                    long recno = reader.findFid(fids[i]);
                    if (recno == -1L) continue;
                    try {
                        Data data = new Data(def);
                        data.addValue(new Integer((int)recno + 1));
                        data.addValue(new Long(shx.getOffsetInBytes((int)recno)));
                        records.add(data);
                        continue;
                    }
                    catch (Exception e) {
                        IOException exception = new IOException();
                        exception.initCause(e);
                        throw exception;
                    }
                }
            }
            finally {
                shx.close();
            }
        }
        finally {
            reader.close();
        }
        return records;
    }

    private boolean isIndexed(URL indexURL) {
        if (!this.isLocal()) {
            return false;
        }
        File indexFile = new File(indexURL.getFile());
        File shpFile = new File(this.shpURL.getPath());
        return indexFile.exists() && indexFile.lastModified() >= shpFile.lastModified();
    }

    public boolean isIndexed() {
        return this.isIndexed(this.fixURL) && this.isIndexed(this.treeURL);
    }

    private Collection queryTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        if (this.treeType == 1) {
            return this.queryRTree(bbox);
        }
        if (this.treeType == 2) {
            return this.queryQuadTree(bbox);
        }
        return null;
    }

    private List queryRTree(Envelope bbox) throws DataSourceException, IOException {
        List goodRecs = null;
        RTree rtree = this.openRTree();
        try {
            if (rtree != null && rtree.getBounds() != null && !bbox.contains(rtree.getBounds())) {
                goodRecs = rtree.search(bbox);
            }
        }
        catch (LockTimeoutException le) {
            throw new DataSourceException("Error querying RTree", (Throwable)le);
        }
        catch (TreeException re) {
            throw new DataSourceException("Error querying RTree", (Throwable)re);
        }
        return goodRecs;
    }

    private Collection queryQuadTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        Collection tmp = null;
        try {
            QuadTree quadTree = this.openQuadTree();
            if (!(quadTree == null || bbox.contains(quadTree.getRoot().getBounds()) || (tmp = quadTree.search(bbox)) != null && tmp.isEmpty())) {
                return tmp;
            }
            if (quadTree != null) {
                quadTree.close();
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error querying QuadTree", (Throwable)e);
        }
        return null;
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.dbfURL);
        if (rbc == null) {
            return null;
        }
        return new IndexedDbaseFileReader(rbc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RTree openRTree() throws IOException {
        if (this.rtree == null) {
            if (!this.isLocal()) {
                return null;
            }
            File treeFile = new File(this.treeURL.getPath());
            Object object = GRX_LOCK;
            synchronized (object) {
                if (treeFile.exists() && !this.isIndexed(this.treeURL) && !treeFile.delete()) {
                    treeFile.deleteOnExit();
                    this.createIndex = false;
                    this.treeType = 0;
                    return null;
                }
                if (!treeFile.exists() || treeFile.length() == 0L) {
                    if (this.createIndex) {
                        try {
                            this.buildRTree();
                        }
                        catch (TreeException e) {
                            this.createIndex = false;
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (!treeFile.exists() || treeFile.length() == 0L) {
                    this.createIndex = false;
                    this.treeType = 0;
                    return null;
                }
            }
            try {
                FileSystemPageStore fps = new FileSystemPageStore(treeFile);
                this.rtree = new RTree(fps);
            }
            catch (TreeException re) {
                throw new DataSourceException("Error opening RTree", (Throwable)re);
            }
        }
        return this.rtree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QuadTree openQuadTree() throws StoreException {
        QuadTree quadTree = null;
        if (quadTree == null) {
            File treeFile = new File(this.treeURL.getPath());
            Object object = QIX_LOCK;
            synchronized (object) {
                if (treeFile.exists() && !this.isIndexed(this.treeURL) && !treeFile.delete()) {
                    this.createIndex = false;
                    this.treeType = 0;
                    return null;
                }
                if (!treeFile.exists() || treeFile.length() == 0L) {
                    if (this.createIndex) {
                        try {
                            this.buildQuadTree();
                        }
                        catch (Throwable e) {
                            this.createIndex = false;
                            this.treeType = 0;
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                if (!treeFile.exists() || treeFile.length() == 0L) {
                    this.createIndex = false;
                    this.treeType = 0;
                    return null;
                }
            }
            FileSystemIndexStore store = new FileSystemIndexStore(treeFile);
            try {
                quadTree = store.load(this.openIndexFile(this.shxURL));
            }
            catch (IOException e) {
                throw new StoreException(e);
            }
        }
        return quadTree;
    }

    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        int slash;
        String path = this.shpURL.getPath();
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String requested) throws IOException {
        if (!this.getCurrentTypeName().equals(requested)) {
            throw new IOException("No such type : " + requested);
        }
    }

    protected FeatureWriter createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        this.typeCheck(typeName);
        return new Writer(typeName);
    }

    public FeatureType getSchema(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getSchema();
    }

    public FeatureType getSchema() throws IOException {
        if (this.schema == null) {
            try {
                AttributeType[] types = this.readAttributes();
                FeatureType parent = null;
                Class geomType = types[0].getType();
                if (geomType == Point.class || geomType == MultiPoint.class) {
                    parent = BasicFeatureTypes.POINT;
                } else if (geomType == Polygon.class || geomType == MultiPolygon.class) {
                    parent = BasicFeatureTypes.POLYGON;
                } else if (geomType == LineString.class || geomType == MultiLineString.class) {
                    parent = BasicFeatureTypes.LINE;
                }
                this.schema = parent != null ? FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)this.namespace, (boolean)false, (FeatureType[])new FeatureType[]{parent}) : (this.namespace != null ? FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)this.namespace, (boolean)false) : FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)GMLSchema.NAMESPACE, (boolean)false));
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating FeatureType", (Throwable)se);
            }
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Envelope getBounds(Query query) throws IOException {
        Envelope ret = null;
        HashSet records = new HashSet();
        if (query.getFilter() == Filter.NONE || query == Query.ALL) {
            return this.getBounds();
        }
        if (this.useIndex && this.treeType == 1) {
            return this.getBoundsRTree(query);
        }
        if (query.getFilter().getFilterType() == 22) {
            List recordsFound;
            FidFilterParserVisitor visitor = new FidFilterParserVisitor();
            query.getFilter().accept((FilterVisitor)visitor);
            if (!visitor.fids.isEmpty() && (recordsFound = this.queryFidIndex(visitor.fids.toArray(new String[0]))) != null) {
                records.addAll(recordsFound);
            }
        }
        if (records.isEmpty()) {
            return null;
        }
        ShapefileReader reader = new ShapefileReader(this.getReadChannel(this.shpURL), this.readWriteLock);
        try {
            ret = new Envelope();
            Iterator iter = records.iterator();
            while (iter.hasNext()) {
                Data data = (Data)iter.next();
                reader.goTo(((Long)data.getValue(1)).intValue());
                ShapefileReader.Record record = reader.nextRecord();
                ret.expandToInclude(new Envelope(record.minX, record.maxX, record.minY, record.maxY));
            }
            Envelope envelope = ret;
            return envelope;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Envelope getBoundsRTree(Query query) throws IOException {
        Envelope ret = null;
        RTree rtree = this.openRTree();
        if (rtree != null) {
            try {
                ret = rtree.getBounds(query.getFilter());
            }
            catch (TreeException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (UnsupportedFilterException e) {
            }
            finally {
                try {
                    rtree.close();
                }
                catch (Exception ee) {}
            }
        }
        return ret;
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        final FeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new AbstractFeatureLocking(){

                    public DataStore getDataStore() {
                        return IndexedShapefileDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        IndexedShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        IndexedShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                    }

                    public FeatureType getSchema() {
                        return featureType;
                    }

                    public Envelope getBounds(Query query) throws IOException {
                        return IndexedShapefileDataStore.this.getBounds(query);
                    }
                };
            }
            return new AbstractFeatureStore(){

                public DataStore getDataStore() {
                    return IndexedShapefileDataStore.this;
                }

                public void addFeatureListener(FeatureListener listener) {
                    IndexedShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                }

                public void removeFeatureListener(FeatureListener listener) {
                    IndexedShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                }

                public FeatureType getSchema() {
                    return featureType;
                }

                public Envelope getBounds(Query query) throws IOException {
                    return IndexedShapefileDataStore.this.getBounds(query);
                }
            };
        }
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return IndexedShapefileDataStore.this;
            }

            public void addFeatureListener(FeatureListener listener) {
                IndexedShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                IndexedShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }

            public Envelope getBounds(Query query) throws IOException {
                return IndexedShapefileDataStore.this.getBounds(query);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRTree() throws TreeException {
        if (this.isLocal()) {
            LOGGER.info("Creating spatial index for " + this.shpURL.getPath());
            IndexedShapefileDataStore indexedShapefileDataStore = this;
            synchronized (indexedShapefileDataStore) {
                if (this.rtree != null) {
                    this.rtree.close();
                }
                this.rtree = null;
            }
            ShapeFileIndexer indexer = new ShapeFileIndexer();
            indexer.setIdxType("RTREE");
            indexer.setShapeFileName(this.shpURL.getPath());
            try {
                indexer.index(false, this.readWriteLock);
            }
            catch (MalformedURLException e) {
                throw new TreeException(e);
            }
            catch (LockTimeoutException e) {
                throw new TreeException(e);
            }
            catch (Exception e) {
                File f = new File(this.treeURL.getPath());
                if (f.exists()) {
                    f.delete();
                }
                if (e instanceof TreeException) {
                    throw (TreeException)e;
                }
                throw new TreeException(e);
            }
        }
    }

    private void buildQuadTree() throws TreeException {
        if (this.isLocal()) {
            LOGGER.info("Creating spatial index for " + this.shpURL.getPath());
            ShapeFileIndexer indexer = new ShapeFileIndexer();
            indexer.setIdxType("QUADTREE");
            indexer.setShapeFileName(this.shpURL.getPath());
            try {
                indexer.index(false, this.readWriteLock);
            }
            catch (MalformedURLException e) {
                throw new TreeException(e);
            }
            catch (LockTimeoutException e) {
                throw new TreeException(e);
            }
            catch (Exception e) {
                File f = new File(this.treeURL.getPath());
                if (f.exists()) {
                    f.delete();
                }
                if (e instanceof TreeException) {
                    throw (TreeException)e;
                }
                throw new TreeException(e);
            }
        }
    }

    public boolean isMemoryMapped() {
        return this.useMemoryMappedBuffer;
    }

    protected class Writer
    implements FeatureWriter {
        private long temp;
        protected FeatureReader featureReader;
        protected Reader attReader;
        private Feature currentFeature;
        private FeatureType featureType;
        private Object[] emptyAtts;
        private Object[] transferCache;
        private ShapeType shapeType;
        private ShapeHandler handler;
        private int shapefileLength = 100;
        private int records = 0;
        private byte[] writeFlags;
        private ShapefileWriter shpWriter;
        private DbaseFileWriter dbfWriter;
        private DbaseFileHeader dbfHeader;
        private FileChannel dbfChannel;
        private Envelope bounds = new Envelope();
        private IndexedFidWriter indexedFidWriter;

        public Writer(String typeName) throws IOException {
            try {
                this.temp = System.currentTimeMillis();
                this.attReader = IndexedShapefileDataStore.this.getAttributesReader(true, true, null);
                this.featureReader = IndexedShapefileDataStore.this.createFeatureReader(typeName, this.attReader, IndexedShapefileDataStore.this.schema);
            }
            catch (Exception e) {
                FeatureType schema = IndexedShapefileDataStore.this.getSchema(typeName);
                if (schema == null) {
                    throw new IOException("To create a shape, you must first call createSchema()");
                }
                this.featureReader = new EmptyFeatureReader(schema);
                this.temp = 0L;
            }
            this.featureType = this.featureReader.getFeatureType();
            this.emptyAtts = new Object[this.featureType.getAttributeCount()];
            this.writeFlags = new byte[this.featureType.getAttributeCount()];
            int cnt = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.featureType.getAttributeType(i) instanceof GeometryAttributeType) continue;
                ++cnt;
                this.writeFlags[i] = 1;
            }
            this.transferCache = new Object[cnt];
            this.shpWriter = new ShapefileWriter((FileChannel)IndexedShapefileDataStore.this.getWriteChannel(IndexedShapefileDataStore.this.getStorageURL(IndexedShapefileDataStore.this.shpURL, this.temp)), (FileChannel)IndexedShapefileDataStore.this.getWriteChannel(IndexedShapefileDataStore.this.getStorageURL(IndexedShapefileDataStore.this.shxURL, this.temp)), IndexedShapefileDataStore.this.readWriteLock);
            this.dbfChannel = (FileChannel)IndexedShapefileDataStore.this.getWriteChannel(IndexedShapefileDataStore.this.getStorageURL(IndexedShapefileDataStore.this.dbfURL, this.temp));
            this.dbfHeader = this.createDbaseHeader();
            this.dbfWriter = new DbaseFileWriter(this.dbfHeader, (WritableByteChannel)this.dbfChannel);
            FileChannel fidIndexChannel = (FileChannel)IndexedShapefileDataStore.this.getWriteChannel(IndexedShapefileDataStore.this.getStorageURL(IndexedShapefileDataStore.this.fixURL, this.temp));
            this.indexedFidWriter = new IndexedFidWriter(fidIndexChannel, new IndexedFidReader(IndexedShapefileDataStore.this.getCurrentTypeName(), this.temp != 0L ? IndexedShapefileDataStore.this.getReadChannel(IndexedShapefileDataStore.this.fixURL) : fidIndexChannel));
            if (this.attReader != null && this.attReader.hasNext()) {
                this.shapeType = this.attReader.shp.getHeader().getShapeType();
                this.handler = this.shapeType.getShapeHandler();
                this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            }
        }

        protected void flush() throws IOException {
            if (this.records <= 0 && this.shapeType == null) {
                GeometryAttributeType geometryAttributeType = this.featureType.getDefaultGeometry();
                Class gat = geometryAttributeType.getType();
                this.shapeType = JTSUtilities.getShapeType((Class)gat);
            }
            this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            this.dbfHeader.setNumRecords(this.records);
            this.dbfChannel.position(0L);
            this.dbfHeader.writeHeader((WritableByteChannel)this.dbfChannel);
        }

        protected DbaseFileHeader createDbaseHeader() throws IOException, DbaseFileException {
            DbaseFileHeader header = new DbaseFileHeader();
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                AttributeType type = this.featureType.getAttributeType(i);
                Class colType = type.getType();
                String colName = type.getName();
                int fieldLen = FeatureTypes.getFieldLength((AttributeType)type);
                if (fieldLen <= 0) {
                    fieldLen = 255;
                }
                if (colType == (class$java$lang$Integer == null ? IndexedShapefileDataStore.class$("java.lang.Integer") : class$java$lang$Integer) || colType == (class$java$lang$Short == null ? IndexedShapefileDataStore.class$("java.lang.Short") : class$java$lang$Short) || colType == (class$java$lang$Byte == null ? IndexedShapefileDataStore.class$("java.lang.Byte") : class$java$lang$Byte)) {
                    header.addColumn(colName, 'N', Math.min(fieldLen, 10), 0);
                    continue;
                }
                if (colType == (class$java$lang$Long == null ? IndexedShapefileDataStore.class$("java.lang.Long") : class$java$lang$Long)) {
                    header.addColumn(colName, 'N', Math.min(fieldLen, 19), 0);
                    continue;
                }
                if (colType == (class$java$lang$Double == null ? IndexedShapefileDataStore.class$("java.lang.Double") : class$java$lang$Double) || colType == (class$java$lang$Float == null ? IndexedShapefileDataStore.class$("java.lang.Float") : class$java$lang$Float) || colType == (class$java$lang$Number == null ? IndexedShapefileDataStore.class$("java.lang.Number") : class$java$lang$Number)) {
                    int l = Math.min(fieldLen, 33);
                    int d = Math.max(l - 2, 0);
                    header.addColumn(colName, 'N', l, d);
                    continue;
                }
                if ((class$java$util$Date == null ? IndexedShapefileDataStore.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(colType)) {
                    header.addColumn(colName, 'D', fieldLen, 0);
                    continue;
                }
                if (colType == (class$java$lang$Boolean == null ? IndexedShapefileDataStore.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    header.addColumn(colName, 'L', 1, 0);
                    continue;
                }
                if ((class$java$lang$CharSequence == null ? IndexedShapefileDataStore.class$("java.lang.CharSequence") : class$java$lang$CharSequence).isAssignableFrom(colType)) {
                    header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
                    continue;
                }
                if ((class$com$vividsolutions$jts$geom$Geometry == null ? IndexedShapefileDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(colType)) continue;
                throw new IOException("Unable to write : " + colType.getName());
            }
            return header;
        }

        protected void finalize() throws Throwable {
            if (this.featureReader != null) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void clean() throws IOException {
            if (this.temp == 0L) {
                return;
            }
            IndexedShapefileDataStore.this.copyAndDelete(IndexedShapefileDataStore.this.shpURL, this.temp);
            IndexedShapefileDataStore.this.copyAndDelete(IndexedShapefileDataStore.this.shxURL, this.temp);
            IndexedShapefileDataStore.this.copyAndDelete(IndexedShapefileDataStore.this.dbfURL, this.temp);
            if (IndexedShapefileDataStore.this.fixURL != null) {
                IndexedShapefileDataStore.this.copyAndDelete(IndexedShapefileDataStore.this.fixURL, this.temp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature != null) {
                this.write();
            }
            if (this.attReader != null && this.attReader.hasNext()) {
                this.shapeType = this.attReader.shp.getHeader().getShapeType();
                this.handler = this.shapeType.getShapeHandler();
                if (this.records == 0) {
                    this.shpWriter.writeHeaders(this.bounds, this.shapeType, 0, 0);
                }
                double[] env = new double[4];
                while (this.attReader.hasNext()) {
                    this.shapefileLength += this.attReader.shp.transferTo(this.shpWriter, ++this.records, env);
                    this.bounds.expandToInclude(env[0], env[1]);
                    this.bounds.expandToInclude(env[2], env[3]);
                    this.attReader.dbf.transferTo(this.dbfWriter);
                }
            }
            try {
                this.featureReader.close();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.flush();
                    Object var5_6 = null;
                }
                catch (Throwable throwable2) {
                    Object var5_7 = null;
                    this.shpWriter.close();
                    this.dbfWriter.close();
                    this.dbfChannel.close();
                    if (this.indexedFidWriter != null) {
                        this.indexedFidWriter.close();
                    }
                    throw throwable2;
                }
                this.shpWriter.close();
                this.dbfWriter.close();
                this.dbfChannel.close();
                if (this.indexedFidWriter != null) {
                    this.indexedFidWriter.close();
                }
                this.featureReader = null;
                this.shpWriter = null;
                this.dbfWriter = null;
                this.dbfChannel = null;
                this.indexedFidWriter = null;
                this.clean();
                try {
                    String filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                    File file = new File(filename + ".qix");
                    if (file.exists()) {
                        file.delete();
                    }
                    if ((file = new File(filename + ".grx")).exists()) {
                        file.delete();
                    }
                    if (IndexedShapefileDataStore.this.createIndex) {
                        if (IndexedShapefileDataStore.this.treeType == 1) {
                            IndexedShapefileDataStore.this.buildRTree();
                            filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                            File toDelete = new File(filename + ".qix");
                            if (toDelete.exists()) {
                                toDelete.delete();
                            }
                        } else if (IndexedShapefileDataStore.this.treeType == 2) {
                            IndexedShapefileDataStore.this.buildQuadTree();
                            filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                            File otherIndex = new File(filename + ".grx");
                            if (otherIndex.exists()) {
                                otherIndex.delete();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    IndexedShapefileDataStore.this.createIndex = false;
                    IndexedShapefileDataStore.this.treeType = 0;
                    LOGGER.log(Level.WARNING, "Error creating RTree", e);
                }
                throw throwable;
            }
            try {
                this.flush();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.shpWriter.close();
                this.dbfWriter.close();
                this.dbfChannel.close();
                if (this.indexedFidWriter != null) {
                    this.indexedFidWriter.close();
                }
                throw throwable;
            }
            this.shpWriter.close();
            this.dbfWriter.close();
            this.dbfChannel.close();
            if (this.indexedFidWriter != null) {
                this.indexedFidWriter.close();
            }
            this.featureReader = null;
            this.shpWriter = null;
            this.dbfWriter = null;
            this.dbfChannel = null;
            this.indexedFidWriter = null;
            this.clean();
            try {
                String filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                File file = new File(filename + ".qix");
                if (file.exists()) {
                    file.delete();
                }
                if ((file = new File(filename + ".grx")).exists()) {
                    file.delete();
                }
                if (IndexedShapefileDataStore.this.createIndex) {
                    if (IndexedShapefileDataStore.this.treeType == 1) {
                        IndexedShapefileDataStore.this.buildRTree();
                        filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                        File toDelete = new File(filename + ".qix");
                        if (toDelete.exists()) {
                            toDelete.delete();
                        }
                    } else if (IndexedShapefileDataStore.this.treeType == 2) {
                        IndexedShapefileDataStore.this.buildQuadTree();
                        filename = IndexedShapefileDataStore.this.shpURL.getFile().substring(0, IndexedShapefileDataStore.this.shpURL.getFile().length() - 4);
                        File otherIndex = new File(filename + ".grx");
                        if (otherIndex.exists()) {
                            otherIndex.delete();
                        }
                    }
                }
            }
            catch (Throwable e) {
                IndexedShapefileDataStore.this.createIndex = false;
                IndexedShapefileDataStore.this.treeType = 0;
                LOGGER.log(Level.WARNING, "Error creating RTree", e);
            }
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }

        public boolean hasNext() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            return this.featureReader.hasNext();
        }

        public Feature next() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature != null) {
                this.write();
            }
            if (this.featureReader.hasNext()) {
                try {
                    if (this.indexedFidWriter != null) {
                        this.indexedFidWriter.next();
                    }
                    this.currentFeature = this.featureReader.next();
                    return this.currentFeature;
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("Error in reading", (Throwable)iae);
                }
            }
            long id = this.indexedFidWriter != null ? this.indexedFidWriter.next() : (long)(this.records + 1);
            try {
                this.currentFeature = DataUtilities.template((FeatureType)this.getFeatureType(), (String)(IndexedShapefileDataStore.this.getCurrentTypeName() + "." + id), (Object[])this.emptyAtts);
                return this.currentFeature;
            }
            catch (IllegalAttributeException iae) {
                throw new DataSourceException("Error creating empty Feature", (Throwable)iae);
            }
        }

        public void remove() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            if (this.indexedFidWriter != null) {
                if (this.indexedFidWriter.isClosed()) {
                    throw new IOException("Writer closed");
                }
                this.indexedFidWriter.remove();
            }
            this.currentFeature = null;
        }

        public void write() throws IOException {
            Envelope b;
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.indexedFidWriter != null) {
                if (this.indexedFidWriter.isClosed()) {
                    throw new IOException("FID Writer closed");
                }
                this.indexedFidWriter.write();
            }
            Geometry g = this.currentFeature.getDefaultGeometry();
            if (this.shapeType == null) {
                int dims = JTSUtilities.guessCoorinateDims((Coordinate[])g.getCoordinates());
                try {
                    this.shapeType = JTSUtilities.getShapeType((Geometry)g, (int)dims);
                    this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
                    this.handler = this.shapeType.getShapeHandler();
                }
                catch (ShapefileException se) {
                    throw new RuntimeException("Unexpected Error", se);
                }
            }
            if (!(b = (g = JTSUtilities.convertToCollection((Geometry)g, (ShapeType)this.shapeType)).getEnvelopeInternal()).isNull()) {
                this.bounds.expandToInclude(b);
            }
            this.shapefileLength += this.handler.getLength((Object)g) + 8;
            this.shpWriter.writeGeometry(g);
            int idx = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.writeFlags[i] <= 0) continue;
                this.transferCache[idx++] = this.currentFeature.getAttribute(i);
            }
            this.dbfWriter.write(this.transferCache);
            ++this.records;
            this.currentFeature = null;
        }
    }

    protected static class Reader
    extends AbstractAttributeIO
    implements AttributeReader,
    RecordNumberTracker {
        protected ShapefileReader shp;
        protected IndexedDbaseFileReader dbf;
        protected DbaseFileReader.Row row;
        protected ShapefileReader.Record record;
        protected Iterator goodRecs;
        private int recno;
        private Data next;

        public Reader(AttributeType[] atts, ShapefileReader shp, IndexedDbaseFileReader dbf, Collection goodRecs) {
            super(atts);
            this.shp = shp;
            this.dbf = dbf;
            if (goodRecs != null) {
                this.goodRecs = goodRecs.iterator();
            }
            this.recno = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.shp != null) {
                    this.shp.close();
                }
                if (this.dbf != null) {
                    this.dbf.close();
                }
                Object var2_1 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
                this.goodRecs = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
                this.goodRecs = null;
                throw throwable;
            }
        }

        public boolean hasNext() throws IOException {
            int n;
            if (this.goodRecs != null) {
                if (this.next != null) {
                    return true;
                }
                if (this.goodRecs.hasNext()) {
                    this.next = (Data)this.goodRecs.next();
                    this.recno = (Integer)this.next.getValue(0);
                    return true;
                }
                return false;
            }
            int n2 = n = this.shp.hasNext() ? 1 : 0;
            if (this.dbf != null) {
                n += this.dbf.hasNext() ? 2 : 0;
            }
            if (n == 3 || n == 1 && this.dbf == null) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
        }

        public void next() throws IOException {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more features in reader");
            }
            if (this.goodRecs != null) {
                this.recno = (Integer)this.next.getValue(0);
                if (this.dbf != null) {
                    this.dbf.goTo(this.recno);
                }
                Long l = (Long)this.next.getValue(1);
                this.shp.goTo((int)l.longValue());
                this.next = null;
            } else {
                ++this.recno;
            }
            this.record = this.shp.nextRecord();
            if (this.dbf != null) {
                this.row = this.dbf.readRow();
            }
        }

        public int getRecordNumber() {
            return this.recno;
        }

        public Object read(int param) throws IOException, ArrayIndexOutOfBoundsException {
            switch (param) {
                case 0: {
                    return this.record.shape();
                }
            }
            if (this.row != null) {
                return this.row.read(param - 1);
            }
            return null;
        }
    }
}

