/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;

final class WeakCollectionCleaner
extends Thread {
    private static final String LOGGER = "org.geotools.util";
    public static final WeakCollectionCleaner DEFAULT = new WeakCollectionCleaner();
    final ReferenceQueue referenceQueue = new ReferenceQueue();

    private WeakCollectionCleaner() {
        super("WeakCollectionCleaner");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        while (this.referenceQueue != null) {
            try {
                Reference ref = this.referenceQueue.remove();
                if (ref == null) {
                    WeakCollectionCleaner.sleep(15000L);
                    break;
                }
                ref.clear();
            }
            catch (InterruptedException exception) {
            }
            catch (Exception exception) {
                Utilities.unexpectedException(LOGGER, "WeakCollectionCleaner", "remove", exception);
            }
            catch (AssertionError exception) {
                Utilities.unexpectedException(LOGGER, "WeakCollectionCleaner", "remove", (Throwable)((Object)exception));
            }
        }
        Logger.getLogger(LOGGER).severe("Daemon stopped.");
    }
}

