/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.media.jai.util.Range;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.NumberRange;
import org.opengis.util.Cloneable;

public class RangeSet
extends AbstractSet
implements SortedSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3222336180818126987L;
    private static final Comparator COMPARATOR;
    private static final Class[] PRIMITIVES;
    private static final byte DOUBLE = 0;
    private static final byte FLOAT = 1;
    private static final byte LONG = 2;
    private static final byte INTEGER = 3;
    private static final byte SHORT = 4;
    private static final byte BYTE = 5;
    private static final byte CHARACTER = 6;
    private static final byte OTHER = -1;
    private final Class type;
    private final Class relaxedType;
    private final Class elementType;
    private final byte indexType;
    private Object array;
    private int modCount;
    private final boolean isPrimitive;
    private final boolean useClassChanger;
    private final boolean isNumeric;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RangeSet(Class type) throws IllegalArgumentException {
        int indexType = -1;
        for (int i = 0; i < PRIMITIVES.length; i += 2) {
            if (!PRIMITIVES[i].equals(type)) continue;
            type = PRIMITIVES[i + 1];
            indexType = (byte)(i / 2);
            break;
        }
        if (!Comparable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Errors.format(90, Utilities.getShortClassName(type)));
        }
        Class elementType = ClassChanger.getTransformedClass(type);
        this.useClassChanger = elementType != type;
        for (int i = 0; i < PRIMITIVES.length; i += 2) {
            if (!PRIMITIVES[i + 1].equals(elementType)) continue;
            elementType = PRIMITIVES[i];
            indexType = (byte)(i / 2);
            break;
        }
        this.type = type;
        this.indexType = (byte)indexType;
        this.elementType = elementType;
        this.isPrimitive = elementType.isPrimitive();
        this.isNumeric = Number.class.isAssignableFrom(type);
        this.relaxedType = this.isNumeric ? Number.class : type;
    }

    public Comparator comparator() {
        return COMPARATOR;
    }

    public void clear() {
        this.array = null;
        ++this.modCount;
    }

    public int size() {
        return this.array != null ? Array.getLength(this.array) / 2 : 0;
    }

    public boolean add(Object r) throws ClassCastException {
        Range range = (Range)r;
        if (!range.isMinIncluded() || !range.isMaxIncluded()) {
            throw new UnsupportedOperationException("Open interval not yet supported");
        }
        return this.add(range.getMinValue(), range.getMaxValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(Comparable lower, Comparable upper) throws IllegalArgumentException {
        int n;
        int i1;
        int i0;
        int modCountChk;
        block19: {
            block21: {
                if (!this.relaxedType.isAssignableFrom(lower.getClass())) {
                    throw new IllegalArgumentException(String.valueOf(lower));
                }
                if (!this.relaxedType.isAssignableFrom(upper.getClass())) {
                    throw new IllegalArgumentException(String.valueOf(upper));
                }
                if (lower.compareTo(upper) > 0) {
                    throw new IllegalArgumentException(Errors.format(13, lower, upper));
                }
                if (this.useClassChanger) {
                    try {
                        lower = (Comparable)((Object)ClassChanger.toNumber(lower));
                        upper = (Comparable)((Object)ClassChanger.toNumber(upper));
                    }
                    catch (ClassNotFoundException exception) {
                        ClassCastException e = new ClassCastException(exception.getLocalizedMessage());
                        e.initCause(exception);
                        throw e;
                    }
                }
                if (this.array == null) {
                    ++this.modCount;
                    this.array = Array.newInstance(this.elementType, 2);
                    Array.set(this.array, 0, lower);
                    Array.set(this.array, 1, upper);
                    return true;
                }
                modCountChk = this.modCount++;
                i0 = this.binarySearch(lower);
                if (i0 >= 0) break block21;
                if (((i0 ^= 0xFFFFFFFF) & 1) != 0) {
                    lower = (Comparable)Array.get(this.array, --i0);
                    i1 = this.binarySearch(upper);
                    break block19;
                } else if (i0 != Array.getLength(this.array) && (i1 = this.binarySearch(upper)) != ~i0) {
                    Array.set(this.array, i0, lower);
                    break block19;
                } else {
                    ++this.modCount;
                    Object old = this.array;
                    int length = Array.getLength(this.array);
                    this.array = Array.newInstance(this.elementType, length + 2);
                    System.arraycopy(old, 0, this.array, 0, i0);
                    System.arraycopy(old, i0, this.array, i0 + 2, length - i0);
                    Array.set(this.array, i0 + 0, lower);
                    Array.set(this.array, i0 + 1, upper);
                    return true;
                }
            }
            i0 &= 0xFFFFFFFE;
            i1 = this.binarySearch(upper);
        }
        if (i1 < 0) {
            if (((i1 ^= 0xFFFFFFFF) & 1) != 0) {
                upper = (Comparable)Array.get(this.array, i1);
            } else {
                ++this.modCount;
                Array.set(this.array, --i1, upper);
            }
        } else {
            i1 |= 1;
        }
        if (!$assertionsDisabled && (i0 & 1) != 0) {
            throw new AssertionError(i0);
        }
        if (!$assertionsDisabled && (i1 & 1) == 0) {
            throw new AssertionError(i1);
        }
        if ((n = i1 - ++i0) > 0) {
            ++this.modCount;
            Object old = this.array;
            int length = Array.getLength(this.array);
            this.array = Array.newInstance(this.elementType, length - n);
            System.arraycopy(old, 0, this.array, 0, i0);
            System.arraycopy(old, i1, this.array, i0, length - i1);
        }
        if (!$assertionsDisabled && (Array.getLength(this.array) & 1) != 0) {
            throw new AssertionError();
        }
        if (modCountChk == this.modCount) return false;
        return true;
    }

    public boolean add(byte lower, byte upper) throws IllegalArgumentException {
        return this.add(new Byte(lower), new Byte(upper));
    }

    public boolean add(short lower, short upper) throws IllegalArgumentException {
        return this.add(new Short(lower), new Short(upper));
    }

    public boolean add(int lower, int upper) throws IllegalArgumentException {
        return this.add(new Integer(lower), new Integer(upper));
    }

    public boolean add(long lower, long upper) throws IllegalArgumentException {
        return this.add(new Long(lower), new Long(upper));
    }

    public boolean add(float lower, float upper) throws IllegalArgumentException {
        return this.add(new Float(lower), new Float(upper));
    }

    public boolean add(double lower, double upper) throws IllegalArgumentException {
        return this.add(new Double(lower), new Double(upper));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Comparable lower, Comparable upper) throws IllegalArgumentException {
        int n;
        if (!this.relaxedType.isAssignableFrom(lower.getClass())) {
            throw new IllegalArgumentException(String.valueOf(lower));
        }
        if (!this.relaxedType.isAssignableFrom(upper.getClass())) {
            throw new IllegalArgumentException(String.valueOf(upper));
        }
        if (lower.compareTo(upper) >= 0) {
            throw new IllegalArgumentException(Errors.format(13, lower, upper));
        }
        if (this.useClassChanger) {
            try {
                lower = (Comparable)((Object)ClassChanger.toNumber(lower));
                upper = (Comparable)((Object)ClassChanger.toNumber(upper));
            }
            catch (ClassNotFoundException exception) {
                ClassCastException e = new ClassCastException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
        }
        if (this.array == null) {
            return false;
        }
        int modCountChk = this.modCount++;
        int i0 = this.binarySearch(lower);
        int i1 = this.binarySearch(upper);
        if (i0 < 0) {
            if (((i0 ^= 0xFFFFFFFF) & 1) != 0) {
                if (i1 == ~i0) {
                    Object old = this.array;
                    int length = Array.getLength(this.array);
                    this.array = Array.newInstance(this.elementType, length + 2);
                    System.arraycopy(old, 0, this.array, 0, i0);
                    System.arraycopy(old, i0, this.array, i0 + 2, length - i0);
                    Array.set(this.array, i0 + 0, lower);
                    Array.set(this.array, i0 + 1, upper);
                    return true;
                }
                Array.set(this.array, i0, lower);
            } else {
                --i0;
            }
        } else if ((i0 & 1) == 0) {
            --i0;
        }
        if (i1 < 0) {
            if (((i1 ^= 0xFFFFFFFF) & 1) != 0) {
                ++this.modCount;
                Array.set(this.array, --i1, upper);
            }
        } else {
            i1 &= 0xFFFFFFFE;
        }
        if (!$assertionsDisabled && (i0 & 1) == 0) {
            throw new AssertionError(i0);
        }
        if (!$assertionsDisabled && (i1 & 1) != 0) {
            throw new AssertionError(i1);
        }
        if ((n = i1 - ++i0) > 0) {
            ++this.modCount;
            Object old = this.array;
            int length = Array.getLength(this.array);
            this.array = Array.newInstance(this.elementType, length - n);
            System.arraycopy(old, 0, this.array, 0, i0);
            System.arraycopy(old, i1, this.array, i0, length - i1);
        }
        if (!$assertionsDisabled && (Array.getLength(this.array) & 1) != 0) {
            throw new AssertionError();
        }
        if (modCountChk == this.modCount) return false;
        return true;
    }

    public boolean remove(byte lower, byte upper) throws IllegalArgumentException {
        return this.remove(new Byte(lower), new Byte(upper));
    }

    public boolean remove(short lower, short upper) throws IllegalArgumentException {
        return this.remove(new Short(lower), new Short(upper));
    }

    public boolean remove(int lower, int upper) throws IllegalArgumentException {
        return this.remove(new Integer(lower), new Integer(upper));
    }

    public boolean remove(long lower, long upper) throws IllegalArgumentException {
        return this.remove(new Long(lower), new Long(upper));
    }

    public boolean remove(float lower, float upper) throws IllegalArgumentException {
        return this.remove(new Float(lower), new Float(upper));
    }

    public boolean remove(double lower, double upper) throws IllegalArgumentException {
        return this.remove(new Double(lower), new Double(upper));
    }

    private int binarySearch(Comparable value) {
        switch (this.indexType) {
            case 0: {
                return Arrays.binarySearch((double[])this.array, ((Number)((Object)value)).doubleValue());
            }
            case 1: {
                return Arrays.binarySearch((float[])this.array, ((Number)((Object)value)).floatValue());
            }
            case 2: {
                return Arrays.binarySearch((long[])this.array, ((Number)((Object)value)).longValue());
            }
            case 3: {
                return Arrays.binarySearch((int[])this.array, ((Number)((Object)value)).intValue());
            }
            case 4: {
                return Arrays.binarySearch((short[])this.array, ((Number)((Object)value)).shortValue());
            }
            case 5: {
                return Arrays.binarySearch((byte[])this.array, ((Number)((Object)value)).byteValue());
            }
            case 6: {
                return Arrays.binarySearch((char[])this.array, ((Character)value).charValue());
            }
        }
        return Arrays.binarySearch((Object[])this.array, value);
    }

    private Comparable toNumber(Comparable value) {
        if (!$assertionsDisabled && !this.type.isAssignableFrom(value.getClass())) {
            throw new AssertionError(value);
        }
        if (this.useClassChanger) {
            try {
                value = (Comparable)((Object)ClassChanger.toNumber(value));
            }
            catch (ClassNotFoundException exception) {
                ClassCastException e = new ClassCastException(value.getClass().getName());
                e.initCause(exception);
                throw e;
            }
        }
        return value;
    }

    private Range newRange(Comparable lower, Comparable upper) {
        if (this.isNumeric) {
            return new NumberRange(this.type, lower, upper);
        }
        return new Range(this.type, lower, upper);
    }

    private Comparable get(int index) {
        Comparable value = (Comparable)Array.get(this.array, index);
        if (this.useClassChanger) {
            try {
                value = ClassChanger.toComparable((Number)((Object)value), this.type);
            }
            catch (ClassNotFoundException exception) {
                ClassCastException e = new ClassCastException(value.getClass().getName());
                e.initCause(exception);
                throw e;
            }
        }
        return value;
    }

    public final double getMinValueAsDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        return this.isPrimitive ? Array.getDouble(this.array, index) : ((Number)Array.get(this.array, index *= 2)).doubleValue();
    }

    public final double getMaxValueAsDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        index = 2 * index + 1;
        return this.isPrimitive ? Array.getDouble(this.array, index) : ((Number)Array.get(this.array, index)).doubleValue();
    }

    public int indexOfRange(Comparable value) {
        int index = this.binarySearch(this.toNumber(value));
        if (index < 0 && ((index ^= 0xFFFFFFFF) & 1) == 0) {
            return -1;
        }
        if (!$assertionsDisabled && !this.newRange(this.get(2 * (index /= 2)), this.get(2 * index + 1)).contains(value)) {
            throw new AssertionError(value);
        }
        return index;
    }

    public boolean contains(Object object) {
        int index;
        Range range = (Range)object;
        if (this.type.equals(range.getElementClass()) && range.isMinIncluded() && range.isMaxIncluded() && (index = this.binarySearch(this.toNumber(range.getMinValue()))) >= 0 && (index & 1) == 0) {
            return this.get(index + 1).compareTo(range.getMaxValue()) == 0;
        }
        return false;
    }

    public Object first() throws NoSuchElementException {
        if (this.array != null && Array.getLength(this.array) != 0) {
            return this.newRange(this.get(0), this.get(1));
        }
        throw new NoSuchElementException();
    }

    public Object last() throws NoSuchElementException {
        int length;
        if (this.array != null && (length = Array.getLength(this.array)) != 0) {
            return this.newRange(this.get(length - 2), this.get(length - 1));
        }
        throw new NoSuchElementException();
    }

    public SortedSet subSet(Object lower, Object upper) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public SortedSet headSet(Object upper) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public SortedSet tailSet(Object lower) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public java.util.Iterator iterator() {
        return new Iterator();
    }

    public int hashCode() {
        int code = this.type.hashCode();
        if (this.array != null) {
            int i = Array.getLength(this.array);
            while ((i -= 8) >= 0) {
                code = code * 37 + Array.get(this.array, i).hashCode();
            }
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            RangeSet that = (RangeSet)object;
            if (Utilities.equals(this.type, that.type)) {
                switch (this.indexType) {
                    case 0: {
                        return Arrays.equals((double[])this.array, (double[])that.array);
                    }
                    case 1: {
                        return Arrays.equals((float[])this.array, (float[])that.array);
                    }
                    case 2: {
                        return Arrays.equals((long[])this.array, (long[])that.array);
                    }
                    case 3: {
                        return Arrays.equals((int[])this.array, (int[])that.array);
                    }
                    case 4: {
                        return Arrays.equals((short[])this.array, (short[])that.array);
                    }
                    case 5: {
                        return Arrays.equals((byte[])this.array, (byte[])that.array);
                    }
                    case 6: {
                        return Arrays.equals((char[])this.array, (char[])that.array);
                    }
                }
                return Arrays.equals((Object[])this.array, (Object[])that.array);
            }
        }
        return false;
    }

    public Object clone() {
        try {
            RangeSet set = (RangeSet)super.clone();
            switch (set.indexType) {
                case 0: {
                    set.array = ((double[])set.array).clone();
                    break;
                }
                case 1: {
                    set.array = ((float[])set.array).clone();
                    break;
                }
                case 2: {
                    set.array = ((long[])set.array).clone();
                    break;
                }
                case 3: {
                    set.array = ((int[])set.array).clone();
                    break;
                }
                case 4: {
                    set.array = ((short[])set.array).clone();
                    break;
                }
                case 5: {
                    set.array = ((byte[])set.array).clone();
                    break;
                }
                case 6: {
                    set.array = ((char[])set.array).clone();
                    break;
                }
                default: {
                    set.array = ((Object[])set.array).clone();
                }
            }
            return set;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        boolean first = true;
        java.util.Iterator it = this.iterator();
        while (it.hasNext()) {
            Range range = (Range)it.next();
            if (!first) {
                buffer.append(',');
            }
            buffer.append('{');
            buffer.append(range.getMinValue());
            buffer.append("..");
            buffer.append(range.getMaxValue());
            buffer.append('}');
            first = false;
        }
        buffer.append(']');
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !RangeSet.class.desiredAssertionStatus();
        COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                Range r1 = (Range)o1;
                Range r2 = (Range)o2;
                int cmin = r1.getMinValue().compareTo(r2.getMinValue());
                int cmax = r1.getMaxValue().compareTo(r2.getMaxValue());
                if (cmin == 0) {
                    cmin = (r1.isMinIncluded() ? -1 : 0) - (r2.isMinIncluded() ? -1 : 0);
                }
                if (cmax == 0) {
                    cmax = (r1.isMaxIncluded() ? 1 : 0) - (r2.isMaxIncluded() ? 1 : 0);
                }
                if (cmin == cmax) {
                    return cmax;
                }
                if (cmin == 0) {
                    return cmax;
                }
                if (cmax == 0) {
                    return cmin;
                }
                throw new IllegalArgumentException("Unordered ranges");
            }
        };
        PRIMITIVES = new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class};
    }

    private final class Iterator
    implements java.util.Iterator {
        private int modCount;
        private int length;
        private int position;

        private Iterator() {
            this.modCount = RangeSet.this.modCount;
            this.length = RangeSet.this.array != null ? Array.getLength(RangeSet.this.array) : 0;
        }

        public boolean hasNext() {
            return this.position < this.length;
        }

        public Object next() {
            if (this.hasNext()) {
                Comparable lower = RangeSet.this.get(this.position++);
                Comparable upper = RangeSet.this.get(this.position++);
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                return RangeSet.this.newRange(lower, upper);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.position != 0) {
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            Object newArray = Array.newInstance(RangeSet.this.elementType, this.length -= 2);
            System.arraycopy(RangeSet.this.array, this.position, newArray, this.position -= 2, this.length - this.position);
            System.arraycopy(RangeSet.this.array, 0, newArray, 0, this.position);
            RangeSet.this.array = newArray;
            this.modCount = ++RangeSet.this.modCount;
        }
    }
}

