/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.units.Converter;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.DefaultAffineCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class DefaultCartesianCS
extends DefaultAffineCS
implements CartesianCS {
    private static final long serialVersionUID = -6182037957705712945L;
    public static DefaultCartesianCS PROJECTED = new DefaultCartesianCS(DefaultCartesianCS.name(196), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.NORTHING);
    public static DefaultCartesianCS GEOCENTRIC = new DefaultCartesianCS(DefaultCartesianCS.name(51), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_Y, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEOCENTRIC_Z);
    public static DefaultCartesianCS GENERIC_2D = new DefaultCartesianCS(DefaultCartesianCS.name(199), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Y);
    public static DefaultCartesianCS GENERIC_3D = new DefaultCartesianCS(DefaultCartesianCS.name(200), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Y, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.Z);
    public static DefaultCartesianCS GRID = new DefaultCartesianCS(DefaultCartesianCS.name(195), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.COLUMN, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ROW);
    public static DefaultCartesianCS DISPLAY = new DefaultCartesianCS(DefaultCartesianCS.name(228), (CoordinateSystemAxis)DefaultCoordinateSystemAxis.DISPLAY_X, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.DISPLAY_Y);
    private transient Converter[] converters;

    public DefaultCartesianCS(CartesianCS cs) {
        super(cs);
    }

    public DefaultCartesianCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(name, axis0, axis1);
    }

    public DefaultCartesianCS(String name, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(name, axis0, axis1, axis2);
    }

    public DefaultCartesianCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    public DefaultCartesianCS(Map properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        Unit unit = this.getDistanceUnit();
        Converter[] converters = this.converters;
        if (converters == null) {
            converters = new Converter[this.getDimension()];
            for (int i = 0; i < converters.length; ++i) {
                converters[i] = this.getAxis(i).getUnit().getConverterTo(unit);
            }
            this.converters = converters;
        }
        double sum = 0.0;
        for (int i = 0; i < converters.length; ++i) {
            Converter c = converters[i];
            double delta = c.convert(coord1[i]) - c.convert(coord2[i]);
            sum += delta * delta;
        }
        return new Measure(Math.sqrt(sum), unit);
    }

    public DefaultCartesianCS usingUnit(Unit unit) throws IllegalArgumentException {
        CoordinateSystemAxis[] axis = this.axisUsingUnit(unit);
        int length = axis.length;
        if (axis == null) {
            return this;
        }
        Map properties = DefaultCartesianCS.getProperties(this, null);
        switch (length) {
            case 2: {
                return new DefaultCartesianCS(properties, axis[0], axis[1]);
            }
            case 3: {
                return new DefaultCartesianCS(properties, axis[0], axis[1], axis[2]);
            }
        }
        throw new AssertionError(length);
    }
}

