/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.List;
import org.geotools.metadata.iso.spatial.SpatialRepresentationImpl;
import org.geotools.resources.Utilities;
import org.geotools.util.CheckedArrayList;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GridSpatialRepresentation;

public class GridSpatialRepresentationImpl
extends SpatialRepresentationImpl
implements GridSpatialRepresentation {
    private static final long serialVersionUID = -8400572307442433979L;
    private int numberOfDimensions;
    private List axisDimensionsProperties;
    private CellGeometry cellGeometry;
    private boolean transformationParameterAvailable;

    public GridSpatialRepresentationImpl() {
    }

    public GridSpatialRepresentationImpl(int numberOfDimensions, List axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable) {
        this.setNumberOfDimensions(numberOfDimensions);
        this.setAxisDimensionsProperties(axisDimensionsProperties);
        this.setCellGeometry(cellGeometry);
        this.setTransformationParameterAvailable(transformationParameterAvailable);
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public synchronized void setNumberOfDimensions(int newValue) {
        this.checkWritePermission();
        this.numberOfDimensions = newValue;
    }

    public synchronized List getAxisDimensionsProperties() {
        if (this.axisDimensionsProperties == null) {
            this.axisDimensionsProperties = new CheckedArrayList(Dimension.class);
        }
        return this.axisDimensionsProperties;
    }

    public synchronized void setAxisDimensionsProperties(List newValues) {
        this.checkWritePermission();
        if (this.axisDimensionsProperties == null) {
            this.axisDimensionsProperties = new CheckedArrayList(Dimension.class);
        } else {
            this.axisDimensionsProperties.clear();
        }
        this.axisDimensionsProperties.addAll(newValues);
    }

    public CellGeometry getCellGeometry() {
        return this.cellGeometry;
    }

    public synchronized void setCellGeometry(CellGeometry newValue) {
        this.checkWritePermission();
        this.cellGeometry = newValue;
    }

    public boolean isTransformationParameterAvailable() {
        return this.transformationParameterAvailable;
    }

    public synchronized void setTransformationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.transformationParameterAvailable = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.axisDimensionsProperties = (List)GridSpatialRepresentationImpl.unmodifiable(this.axisDimensionsProperties);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GridSpatialRepresentationImpl that = (GridSpatialRepresentationImpl)object;
            return Utilities.equals(this.axisDimensionsProperties, that.axisDimensionsProperties) && Utilities.equals(this.cellGeometry, that.cellGeometry) && this.numberOfDimensions == that.numberOfDimensions && this.transformationParameterAvailable == that.transformationParameterAvailable;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1729560507;
        if (this.axisDimensionsProperties != null) {
            code ^= ((Object)this.axisDimensionsProperties).hashCode();
        }
        if (this.cellGeometry != null) {
            code ^= this.cellGeometry.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.axisDimensionsProperties);
    }
}

