/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.util.InternationalString;

public class GeoreferenceableImpl
extends GridSpatialRepresentationImpl
implements Georeferenceable {
    private static final long serialVersionUID = 5203270142818028946L;
    private boolean controlPointAvailable;
    private boolean orientationParameterAvailable;
    private InternationalString orientationParameterDescription;
    private Object parameters;
    private Collection parameterCitation;

    public GeoreferenceableImpl() {
    }

    public GeoreferenceableImpl(int numberOfDimensions, List axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean controlPointAvailable, boolean orientationParameterAvailable) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setControlPointAvailable(controlPointAvailable);
        this.setOrientationParameterAvailable(orientationParameterAvailable);
    }

    public boolean isControlPointAvailable() {
        return this.controlPointAvailable;
    }

    public synchronized void setControlPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.controlPointAvailable = newValue;
    }

    public boolean isOrientationParameterAvailable() {
        return this.orientationParameterAvailable;
    }

    public synchronized void setOrientationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.orientationParameterAvailable = newValue;
    }

    public InternationalString getOrientationParameterDescription() {
        return this.orientationParameterDescription;
    }

    public synchronized void setOrientationParameterDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.orientationParameterDescription = newValue;
    }

    public Object getParameters() {
        return this.parameters;
    }

    public synchronized void setParameters(Object newValue) {
        this.checkWritePermission();
        this.parameters = newValue;
    }

    public synchronized Collection getParameterCitation() {
        this.parameterCitation = this.nonNullCollection(this.parameterCitation, Citation.class);
        return this.parameterCitation;
    }

    public synchronized void setParameterCitation(Collection newValues) {
        this.parameterCitation = this.copyCollection(newValues, this.parameterCitation, Citation.class);
    }

    protected void freeze() {
        super.freeze();
        this.orientationParameterDescription = (InternationalString)GeoreferenceableImpl.unmodifiable(this.orientationParameterDescription);
        this.parameters = GeoreferenceableImpl.unmodifiable(this.parameters);
        this.parameterCitation = (Collection)GeoreferenceableImpl.unmodifiable(this.parameterCitation);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GeoreferenceableImpl that = (GeoreferenceableImpl)object;
            return Utilities.equals(this.parameters, that.parameters) && Utilities.equals(this.parameterCitation, that.parameterCitation) && Utilities.equals(this.orientationParameterDescription, that.orientationParameterDescription) && this.controlPointAvailable == that.controlPointAvailable && this.orientationParameterAvailable == that.orientationParameterAvailable;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1964019090;
        if (this.parameters != null) {
            code ^= this.parameters.hashCode();
        }
        if (this.parameterCitation != null) {
            code ^= ((Object)this.parameterCitation).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.parameterCitation);
    }
}

