/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.geotools.factory.Hints;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.metadata.iso.extent.GeographicExtentImpl;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.TransformPathNotFoundException;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public class GeographicBoundingBoxImpl
extends GeographicExtentImpl
implements GeographicBoundingBox {
    private static final long serialVersionUID = -3278089380004172514L;
    public static final GeographicBoundingBox WORLD;
    private static final Hints LENIENT;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public GeographicBoundingBoxImpl() {
    }

    public GeographicBoundingBoxImpl(GeographicBoundingBox box) {
        super(box);
        this.setWestBoundLongitude(box.getWestBoundLongitude());
        this.setEastBoundLongitude(box.getEastBoundLongitude());
        this.setSouthBoundLatitude(box.getSouthBoundLatitude());
        this.setNorthBoundLatitude(box.getNorthBoundLatitude());
    }

    public GeographicBoundingBoxImpl(Envelope envelope) throws TransformException {
        super(true);
        CoordinateReferenceSystem crs = envelope.getLowerCorner().getCoordinateReferenceSystem();
        if (crs != null) {
            if (!GeographicBoundingBoxImpl.startsWith(crs, DefaultGeographicCRS.WGS84) && !GeographicBoundingBoxImpl.startsWith(crs, DefaultGeographicCRS.WGS84_3D)) {
                CoordinateOperation operation;
                CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(LENIENT);
                try {
                    operation = factory.createOperation(crs, DefaultGeographicCRS.WGS84);
                }
                catch (FactoryException exception) {
                    throw new TransformPathNotFoundException(Errors.format(26, exception));
                }
                envelope = CRSUtilities.transform(operation.getMathTransform(), envelope);
            }
            this.setWestBoundLongitude(envelope.getMinimum(0));
            this.setEastBoundLongitude(envelope.getMaximum(0));
            this.setSouthBoundLatitude(envelope.getMinimum(1));
            this.setNorthBoundLatitude(envelope.getMaximum(1));
        }
    }

    private static final boolean startsWith(CoordinateReferenceSystem crs, CoordinateReferenceSystem head) {
        int dimension = head.getCoordinateSystem().getDimension();
        return crs.getCoordinateSystem().getDimension() >= dimension && CRSUtilities.equalsIgnoreMetadata(CRSUtilities.getSubCRS(crs, 0, dimension), head);
    }

    public GeographicBoundingBoxImpl(Rectangle2D bounds) {
        this(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    public GeographicBoundingBoxImpl(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        super(true);
        this.setWestBoundLongitude(westBoundLongitude);
        this.setEastBoundLongitude(eastBoundLongitude);
        this.setSouthBoundLatitude(southBoundLatitude);
        this.setNorthBoundLatitude(northBoundLatitude);
    }

    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public synchronized void setWestBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.westBoundLongitude = newValue;
    }

    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public synchronized void setEastBoundLongitude(double newValue) {
        this.checkWritePermission();
        this.eastBoundLongitude = newValue;
    }

    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public synchronized void setSouthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.southBoundLatitude = newValue;
    }

    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public synchronized void setNorthBoundLatitude(double newValue) {
        this.checkWritePermission();
        this.northBoundLatitude = newValue;
    }

    public synchronized void add(GeographicBoundingBox box) {
        this.checkWritePermission();
        double xmin = box.getWestBoundLongitude();
        double xmax = box.getEastBoundLongitude();
        double ymin = box.getSouthBoundLatitude();
        double ymax = box.getNorthBoundLatitude();
        if (this.getInclusion() == box.getInclusion()) {
            if (xmin < this.westBoundLongitude) {
                this.westBoundLongitude = xmin;
            }
            if (xmax > this.eastBoundLongitude) {
                this.eastBoundLongitude = xmax;
            }
            if (ymin < this.southBoundLatitude) {
                this.southBoundLatitude = ymin;
            }
            if (ymax > this.northBoundLatitude) {
                this.northBoundLatitude = ymax;
            }
        } else {
            if (ymin <= this.southBoundLatitude && ymax >= this.northBoundLatitude) {
                if (xmin > this.westBoundLongitude) {
                    this.westBoundLongitude = xmin;
                }
                if (xmax < this.eastBoundLongitude) {
                    this.eastBoundLongitude = xmax;
                }
            }
            if (xmin <= this.westBoundLongitude && xmax >= this.eastBoundLongitude) {
                if (ymin > this.southBoundLatitude) {
                    this.southBoundLatitude = ymin;
                }
                if (ymax < this.northBoundLatitude) {
                    this.northBoundLatitude = ymax;
                }
            }
        }
    }

    protected void freeze() {
        super.freeze();
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GeographicBoundingBoxImpl that = (GeographicBoundingBoxImpl)object;
            return Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(that.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(that.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(that.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(that.westBoundLongitude);
        }
        return false;
    }

    public synchronized int hashCode() {
        long code = -3278089380004172514L;
        code ^= Double.doubleToLongBits(this.southBoundLatitude);
        code = 37L * code + Double.doubleToLongBits(this.northBoundLatitude);
        code = 37L * code + Double.doubleToLongBits(this.eastBoundLongitude);
        code = 37L * code + Double.doubleToLongBits(this.westBoundLongitude);
        return (int)code ^ (int)(code >>> 32);
    }

    public String toString() {
        return GeographicBoundingBoxImpl.toString(this, "DD\u00b0MM'SS.s\"", null);
    }

    public static String toString(GeographicBoundingBox box, String pattern, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        AngleFormat format = locale != null ? new AngleFormat(pattern, locale) : new AngleFormat(pattern);
        buffer.append(format.format(new Latitude(box.getNorthBoundLatitude())));
        buffer.append(", ");
        buffer.append(format.format(new Longitude(box.getWestBoundLongitude())));
        buffer.append(" - ");
        buffer.append(format.format(new Latitude(box.getSouthBoundLatitude())));
        buffer.append(", ");
        buffer.append(format.format(new Longitude(box.getEastBoundLongitude())));
        return buffer.toString();
    }

    static {
        GeographicBoundingBoxImpl world = new GeographicBoundingBoxImpl(-180.0, 180.0, -90.0, 90.0);
        world.freeze();
        WORLD = world;
        LENIENT = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
    }
}

