/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.sql.Date;
import java.text.ParseException;
import org.apache.commons.lang.time.DateUtils;
import org.geotools.feature.Feature;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsBetween;

public class BetweenFilterImpl
extends CompareFilterImpl
implements BetweenFilter {
    private static String[] patterns = new String[]{"yyyy-MM-dd", "dd-MM-yyyy", "MM-dd-yyyy"};
    protected org.opengis.filter.expression.Expression middleValue = null;

    protected BetweenFilterImpl(FilterFactory factory) {
        super(factory, null, null);
        this.filterType = (short)19;
    }

    protected BetweenFilterImpl() throws IllegalFilterException {
        super((short)19);
    }

    public final void addMiddleValue(Expression middleValue) {
        this.setExpression((org.opengis.filter.expression.Expression)middleValue);
    }

    public void setExpression(org.opengis.filter.expression.Expression expression) {
        this.middleValue = expression;
    }

    public final Expression getMiddleValue() {
        return (Expression)this.getExpression();
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.middleValue;
    }

    public org.opengis.filter.expression.Expression getLowerBoundary() {
        return this.getExpression1();
    }

    public void setLowerBoundary(org.opengis.filter.expression.Expression lowerBounds) {
        this.setExpression1(lowerBounds);
    }

    public org.opengis.filter.expression.Expression getUpperBoundary() {
        return this.getExpression2();
    }

    public void setUpperBoundary(org.opengis.filter.expression.Expression upperBounds) {
        this.setExpression2(upperBounds);
    }

    public boolean evaluate(Feature feature) {
        if (this.middleValue == null) {
            return false;
        }
        Object leftObj = this.expression1.evaluate((Object)feature);
        Object rightObj = this.expression2.evaluate((Object)feature);
        Object middleObj = this.middleValue.evaluate((Object)feature);
        if (leftObj instanceof Number && middleObj instanceof Number && rightObj instanceof Number) {
            double left = ((Number)leftObj).doubleValue();
            double right = ((Number)rightObj).doubleValue();
            double mid = ((Number)middleObj).doubleValue();
            return left <= mid && right >= mid;
        }
        if (leftObj.getClass() == middleObj.getClass() && rightObj.getClass() == middleObj.getClass() && leftObj instanceof Comparable) {
            return ((Comparable)leftObj).compareTo(middleObj) <= 0 && ((Comparable)middleObj).compareTo(rightObj) <= 0;
        }
        if (middleObj instanceof Date && leftObj instanceof String && rightObj instanceof String) {
            long rightTime;
            long leftTime;
            try {
                leftTime = DateUtils.parseDate((String)((String)leftObj), (String[])patterns).getTime();
                rightTime = DateUtils.parseDate((String)((String)rightObj), (String[])patterns).getTime();
            }
            catch (ParseException e) {
                String mesg = "Supplied between values are either not compatible or not supported for comparison: " + leftObj + " <= " + middleObj + " <= " + rightObj;
                throw new IllegalArgumentException(mesg);
            }
            long middleTime = ((Date)middleObj).getTime();
            return leftTime <= middleTime && middleTime <= rightTime;
        }
        String mesg = "Supplied between values are either not compatible or not supported for comparison: " + leftObj + " <= " + middleObj + " <= " + rightObj;
        throw new IllegalArgumentException(mesg);
    }

    public String toString() {
        return "[ " + this.expression1.toString() + " < " + this.middleValue.toString() + " < " + this.expression2.toString() + " ]";
    }

    public boolean equals(Object oFilter) {
        if (oFilter.getClass() == this.getClass()) {
            BetweenFilterImpl bFilter = (BetweenFilterImpl)oFilter;
            return bFilter.getFilterType() == this.filterType && bFilter.getLeftValue().equals(this.expression1) && bFilter.getMiddleValue().equals(this.middleValue) && bFilter.getRightValue().equals(this.expression2);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.middleValue == null ? 0 : this.middleValue.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsBetween)this, extraData);
    }
}

