/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.FeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.NullProgressListener;
import org.geotools.util.ProgressListener;

public class JDBCFeatureCollection
extends DefaultFeatureResults {
    protected JDBCFeatureSource featureSource;
    public boolean isOptimized = false;

    public JDBCFeatureCollection(JDBCFeatureSource source, Query query) {
        super(source, query);
        this.featureSource = source;
    }

    JDBC1DataStore getDataStore() {
        return (JDBC1DataStore)this.featureSource.getDataStore();
    }

    public FeatureReader reader() throws IOException {
        int maxFeatures = this.query.getMaxFeatures();
        FeatureReader reader = this.getDataStore().getFeatureReader(this.query, this.getTransaction());
        if (maxFeatures == Integer.MAX_VALUE) {
            return reader;
        }
        return new MaxFeatureReader(reader, maxFeatures);
    }

    public int getCount() throws IOException {
        int count = this.featureSource.count(this.query, this.getTransaction());
        if (count != -1) {
            int maxFeatures = this.query.getMaxFeatures();
            return count < maxFeatures ? count : maxFeatures;
        }
        return super.getCount();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (progress == null) {
            progress = new NullProgressListener();
        }
        if (visitor instanceof MinVisitor) {
            progress.started();
            MinVisitor minCalc = (MinVisitor)visitor;
            Object min = this.min(minCalc.getExpression());
            if (min != null) {
                minCalc.setValue(min);
                this.isOptimized = true;
                progress.complete();
                return;
            }
            progress.warningOccurred("JDBCFeatureCollection.accepts(min,)", null, "Optimization attempt returned null");
        } else if (visitor instanceof MaxVisitor) {
            progress.started();
            MaxVisitor maxCalc = (MaxVisitor)visitor;
            Object max = this.max(maxCalc.getExpression());
            if (max != null) {
                maxCalc.setValue(max);
                this.isOptimized = true;
                progress.complete();
                return;
            }
            progress.warningOccurred("JDBCFeatureCollection.accepts(max,)", null, "Optimization attempt returned null");
        } else if (!(visitor instanceof MedianVisitor)) {
            if (visitor instanceof SumVisitor) {
                progress.started();
                SumVisitor sumCalc = (SumVisitor)visitor;
                Object sum = this.sum(sumCalc.getExpression());
                if (sum != null) {
                    sumCalc.setValue(sum);
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(sum,)", null, "Optimization attempt returned null");
            } else if (visitor instanceof CountVisitor) {
                progress.started();
                CountVisitor countCalc = (CountVisitor)visitor;
                Object count = this.count(null);
                if (count != null) {
                    countCalc.setValue(((Number)count).intValue());
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(count,)", null, "Optimization attempt returned null");
            } else if (visitor instanceof AverageVisitor) {
                progress.started();
                AverageVisitor averageCalc = (AverageVisitor)visitor;
                Object sum = this.sum(averageCalc.getExpression());
                Object count = this.count(null);
                if (sum != null && count != null) {
                    averageCalc.setValue(((Number)count).intValue(), sum);
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(average,)", null, "Optimization attempt returned null");
            } else if (visitor instanceof UniqueVisitor) {
                progress.started();
                UniqueVisitor uniqueCalc = (UniqueVisitor)visitor;
                Object unique = this.unique(uniqueCalc.getExpression());
                if (unique != null) {
                    uniqueCalc.setValue(unique);
                    this.isOptimized = true;
                    progress.complete();
                    return;
                }
                progress.warningOccurred("JDBCFeatureCollection.accepts(unique,)", null, "Optimization attempt returned null");
            }
        }
        this.isOptimized = false;
        super.accepts(visitor, progress);
    }

    Connection getConnection() throws IOException {
        return this.getDataStore().getConnection(this.featureSource.getTransaction());
    }

    Object min(Expression expression) throws IOException {
        return this.aggregate("MIN", expression);
    }

    Object max(Expression expression) throws IOException {
        return this.aggregate("MAX", expression);
    }

    Object median(Expression expression) throws IOException {
        return this.aggregate("MEDIAN", expression);
    }

    Object sum(Expression expression) throws IOException {
        return this.aggregate("SUM", expression);
    }

    Object count(Expression expression) throws IOException {
        return this.aggregate("COUNT", expression);
    }

    Object average(Expression expression) throws IOException {
        return this.aggregate("AVERAGE", expression);
    }

    Object unique(Expression expression) throws IOException {
        return this.aggregate("DISTINCT", expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object aggregate(String aggregate, Expression expression) throws IOException {
        block36: {
            block31: {
                block35: {
                    block30: {
                        block34: {
                            block29: {
                                filter = this.query.getFilter();
                                if (filter == Filter.ALL) {
                                    return null;
                                }
                                jdbc = this.getDataStore();
                                sqlBuilder = jdbc.getSqlBuilder(this.getSchema().getTypeName());
                                postFilter = sqlBuilder.getPostQueryFilter(this.query.getFilter());
                                if (postFilter != null && postFilter != Filter.NONE) {
                                    return null;
                                }
                                conn = null;
                                results = null;
                                statement = null;
                                try {
                                    try {
                                        conn = jdbc.getConnection(this.featureSource.getTransaction());
                                        typeName = this.getSchema().getTypeName();
                                        sql = new StringBuffer();
                                        sql.append("SELECT ");
                                        sql.append(aggregate);
                                        sql.append("(");
                                        if (expression == null) {
                                            sql.append("*");
                                        } else {
                                            expression.accept((FilterVisitor)new ExpressionSimplifier());
                                            sql.append(expression.toString());
                                        }
                                        sql.append(") AS rslt");
                                        sqlBuilder.sqlFrom(sql, typeName);
                                        sqlBuilder.sqlWhere(sql, filter);
                                        statement = conn.createStatement();
                                        results = statement.executeQuery(sql.toString());
                                        if (results == null) {
                                            var12_15 = null;
                                            var16_17 = null;
                                            break block29;
                                        }
                                        results.next();
                                        answer = results.getObject("rslt");
                                        results.next();
                                        if (results.isAfterLast()) {
                                            var13_27 = answer;
                                            break block30;
                                        }
                                        list = new ArrayList<Object>();
                                        list.add(answer);
                                        while (!results.isAfterLast()) {
                                            list.add(results.getObject("rslt"));
                                            results.next();
                                        }
                                        var14_29 = list;
                                        break block31;
                                    }
                                    catch (SQLException sqlException) {
                                        JDBCUtils.close(conn, this.featureSource.getTransaction(), sqlException);
                                        conn = null;
                                        throw new DataSourceException("Could not calculate " + aggregate + " with " + this.query.getHandle(), (Throwable)sqlException);
                                    }
                                    catch (SQLEncoderException e) {
                                        var11_14 = null;
                                        var16_20 = null;
                                        try {
                                            if (results != null) {
                                                results.close();
                                            }
                                            if (statement != null) {
                                                statement.close();
                                            }
                                        }
                                        catch (SQLException ignore) {
                                            // empty catch block
                                        }
                                        JDBCUtils.close(conn, this.featureSource.getTransaction(), null);
                                        return var11_14;
                                    }
                                }
                                catch (Throwable var15_30) {
                                    block33: {
                                        var16_21 = null;
                                        ** try [egrp 2[TRYBLOCK] [11 : 445->472)] { 
lbl85:
                                        // 1 sources

                                        if (results != null) {
                                            results.close();
                                        }
                                        if (statement != null) {
                                            statement.close();
                                        }
                                        break block33;
lbl90:
                                        // 1 sources

                                        catch (SQLException ignore) {
                                            // empty catch block
                                        }
                                    }
                                    JDBCUtils.close(conn, this.featureSource.getTransaction(), null);
                                    throw var15_30;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [11 : 445->472)] { 
lbl97:
                            // 1 sources

                            if (results != null) {
                                results.close();
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            break block34;
lbl102:
                            // 1 sources

                            catch (SQLException ignore) {
                                // empty catch block
                            }
                        }
                        JDBCUtils.close(conn, this.featureSource.getTransaction(), null);
                        return var12_15;
                    }
                    var16_18 = null;
                    ** try [egrp 2[TRYBLOCK] [11 : 445->472)] { 
lbl110:
                    // 1 sources

                    if (results != null) {
                        results.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    break block35;
lbl115:
                    // 1 sources

                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                JDBCUtils.close(conn, this.featureSource.getTransaction(), null);
                return var13_27;
            }
            var16_19 = null;
            ** try [egrp 2[TRYBLOCK] [11 : 445->472)] { 
lbl123:
            // 1 sources

            if (results != null) {
                results.close();
            }
            if (statement != null) {
                statement.close();
            }
            break block36;
lbl128:
            // 1 sources

            catch (SQLException ignore) {
                // empty catch block
            }
        }
        JDBCUtils.close(conn, this.featureSource.getTransaction(), null);
        return var14_29;
    }

    class ExpressionSimplifier
    extends AbstractFilterVisitor {
        ExpressionSimplifier() {
        }

        public void visit(AttributeExpression expression) {
            String xpath = expression.getAttributePath();
            if (xpath.startsWith("featureMembers/*/")) {
                xpath = xpath.substring(17);
            } else if (xpath.startsWith("featureMember/*/")) {
                xpath = xpath.substring(16);
            }
            try {
                expression.setAttributePath(xpath);
            }
            catch (IllegalFilterException illegalFilterException) {
                // empty catch block
            }
        }
    }
}

