/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.JTSConfigurator;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.unijena.jams.data.JAMSCalendar;

public class GraphProperties {
    URL url1 = this.getClass().getResource("/jams/components/gui/resources/arrowup.png");
    ImageIcon up_icon = new ImageIcon(this.url1);
    URL url2 = this.getClass().getResource("/jams/components/gui/resources/arrowdown.png");
    ImageIcon down_icon = new ImageIcon(this.url2);
    URL url3 = this.getClass().getResource("/jams/components/gui/resources/correct.png");
    ImageIcon plot_icon = new ImageIcon(this.url3);
    URL url4 = this.getClass().getResource("/jams/components/gui/resources/add.png");
    ImageIcon add_icon = new ImageIcon(this.url4);
    URL url5 = this.getClass().getResource("/jams/components/gui/resources/remove.png");
    ImageIcon rem_icon = new ImageIcon(this.url5);
    JTable table;
    TimeSeries ts;
    TimeSeriesCollection dataset;
    JScrollPane scpane;
    int index = 0;
    String legendName;
    String color;
    String name;
    String position;
    int type;
    boolean result = false;
    int selectedColumn;
    int[] rowSelection;
    JComboBox setColumn;
    JComboBox colorchoice;
    JComboBox typechoice;
    JComboBox poschoice;
    JComboBox timechoice_START;
    JComboBox timechoice_END;
    JButton addButton;
    JButton remButton;
    JButton plotButton;
    JButton upButton;
    JButton downButton;
    JCheckBox invBox;
    JLabel nameLabel;
    JTextField setName;
    JTextField setLegend;
    JTSConfigurator ctsconf;
    private String[] colors = new String[]{"red", "blue", "green", "black", "magenta", "cyan", "yellow", "gray", "orange", "lightgray", "pink"};
    private String[] types = new String[]{"Line", "Bar", "Area", "Line and Base", "Dot", "Difference", "Step", "StepArea"};
    private String[] positions = new String[]{"left", "right"};
    JPanel graphpanel = new JPanel();
    JPanel datapanel = new JPanel();
    JPanel buttonpanel = new JPanel();
    ActionListener okListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.applyProperties();
            GraphProperties.this.ctsconf.plotGraph(GraphProperties.this.index);
        }
    };
    ActionListener timeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.setPossibleTimeIntervals();
        }
    };
    ActionListener addListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.ctsconf.addGraph(GraphProperties.this.index + 1);
        }
    };
    ActionListener removeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.ctsconf.removeGraph(GraphProperties.this.index);
        }
    };
    ActionListener upListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.ctsconf.upGraph(GraphProperties.this.index);
            GraphProperties.this.applyProperties();
        }
    };
    ActionListener downListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            GraphProperties.this.ctsconf.downGraph(GraphProperties.this.index);
            GraphProperties.this.applyProperties();
        }
    };

    public GraphProperties(JDialog parent, JTable table, JTSConfigurator ctsconf) {
        this.ctsconf = ctsconf;
        this.table = table;
        this.color = "red";
        this.position = "left";
        this.legendName = this.name = "Graph Name";
        this.selectedColumn = 0;
        this.rowSelection = null;
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout());
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout());
        this.addButton = new JButton();
        this.remButton = new JButton();
        this.plotButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.upButton.setIcon(this.up_icon);
        this.downButton.setIcon(this.down_icon);
        this.plotButton.setIcon(this.plot_icon);
        this.addButton.setIcon(this.add_icon);
        this.remButton.setIcon(this.rem_icon);
        this.plotButton.setToolTipText("plot graph");
        this.upButton.setToolTipText("move up");
        this.downButton.setToolTipText("move down");
        this.addButton.setToolTipText("add graph");
        this.remButton.setToolTipText("remove button");
        this.invBox = new JCheckBox("invert axis");
        this.addButton.setBorder(new SoftBevelBorder(0));
        this.addButton.setPreferredSize(new Dimension(20, 14));
        this.addButton.addActionListener(this.addListener);
        this.remButton.addActionListener(this.removeListener);
        this.upButton.addActionListener(this.upListener);
        this.downButton.addActionListener(this.downListener);
        this.remButton.setBorder(new SoftBevelBorder(0));
        this.remButton.setPreferredSize(new Dimension(20, 14));
        this.upButton.setBorder(new SoftBevelBorder(0));
        this.upButton.setPreferredSize(new Dimension(20, 14));
        this.plotButton.setBorder(new SoftBevelBorder(0));
        this.plotButton.setPreferredSize(new Dimension(20, 14));
        this.downButton.setBorder(new SoftBevelBorder(0));
        this.downButton.setPreferredSize(new Dimension(20, 14));
        this.colorchoice = new JComboBox<String>(this.colors);
        this.colorchoice.setPreferredSize(new Dimension(40, 14));
        this.colorchoice.setSelectedIndex(0);
        this.typechoice = new JComboBox<String>(this.types);
        this.typechoice.setPreferredSize(new Dimension(40, 14));
        this.typechoice.setSelectedIndex(0);
        this.poschoice = new JComboBox<String>(this.positions);
        this.poschoice.setPreferredSize(new Dimension(40, 14));
        this.poschoice.setSelectedIndex(0);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("CANCEL");
        JLabel setNameLabel = new JLabel("        Name:");
        JLabel setColumnLabel = new JLabel("  Set Column:");
        JLabel setLegendLabel = new JLabel("Legend Entry:");
        this.nameLabel = new JLabel();
        String[] column = new String[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            column[i] = table.getColumnName(i);
        }
        String[] timeIntervals = new String[table.getRowCount()];
        for (int i = 0; i < table.getRowCount(); ++i) {
            timeIntervals[i] = table.getValueAt(i, 0).toString();
        }
        this.timechoice_START = new JComboBox<String>(timeIntervals);
        this.timechoice_START.setPreferredSize(new Dimension(40, 14));
        this.timechoice_START.addActionListener(this.timeListener);
        this.timechoice_END = new JComboBox<String>(timeIntervals);
        this.timechoice_END.setPreferredSize(new Dimension(40, 14));
        this.timechoice_END.addActionListener(this.timeListener);
        this.setColumn = new JComboBox<String>(column);
        this.setColumn.setPreferredSize(new Dimension(40, 14));
        this.setColumn.setSelectedIndex(1);
        this.nameLabel.setText((String)this.setColumn.getSelectedItem());
        String name = (String)this.setColumn.getSelectedItem();
        this.setName = new JTextField(name, 14);
        this.setName.setPreferredSize(new Dimension(40, 14));
        this.setLegend = new JTextField(name, 14);
        this.setLegend.setPreferredSize(new Dimension(40, 14));
        namePanel.add(setNameLabel);
        namePanel.add(this.setName);
        legendPanel.add(setLegendLabel);
        legendPanel.add(this.setLegend);
        this.datapanel.setLayout(new FlowLayout());
        this.graphpanel.setLayout(new FlowLayout());
        this.graphpanel.add(this.setColumn);
        this.graphpanel.add(this.poschoice);
        this.graphpanel.add(this.typechoice);
        this.graphpanel.add(this.colorchoice);
        this.datapanel.add(this.nameLabel);
        this.buttonpanel.add(okButton);
        this.buttonpanel.add(cancelButton);
        this.plotButton.addActionListener(this.okListener);
        this.applyProperties();
    }

    public void applyProperties() {
        this.selectedColumn = this.setColumn.getSelectedIndex();
        this.color = (String)this.colorchoice.getSelectedItem();
        this.ts = new TimeSeries(this.setLegend.getText(), Second.class);
        for (int i = this.getTimeSTART(); i <= this.getTimeEND(); ++i) {
            JAMSCalendar time = (JAMSCalendar)this.table.getValueAt(i, 0);
            double value = (Double)this.table.getValueAt(i, this.selectedColumn);
            this.ts.add((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
        }
    }

    public TimeSeries getTS() {
        return this.ts;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    private void setPossibleTimeIntervals() {
        int e;
        int s = this.timechoice_START.getSelectedIndex();
        if (s >= (e = this.timechoice_END.getSelectedIndex())) {
            this.timechoice_END.setSelectedIndex(s);
        }
    }

    public boolean getResult() {
        return this.result;
    }

    public JPanel getGraphPanel() {
        return this.datapanel;
    }

    public void setDataSelection() {
        this.rowSelection = this.table.getSelectedRows();
        this.selectedColumn = this.table.getSelectedColumn();
    }

    public void setSelectedColumn(int col) {
        this.selectedColumn = col;
        this.setColumn.setSelectedIndex(col);
        this.nameLabel.setText((String)this.setColumn.getSelectedItem());
    }

    public void setSelectedRows(int[] rows) {
        this.rowSelection = rows;
    }

    public void setColor(String color) {
        this.color = color;
        this.colorchoice.setSelectedItem(color);
    }

    public void setColor(int index) {
        this.colorchoice.setSelectedIndex(index);
        this.color = (String)this.colorchoice.getSelectedItem();
    }

    public void setLegendName(String legendName) {
        this.legendName = legendName;
        this.setLegend.setText(legendName);
    }

    public void setName(String name) {
        this.name = name;
        this.setName.setText(name);
    }

    public void setPosition(String position) {
        this.position = position;
        this.poschoice.setSelectedItem(position);
    }

    public void setRendererType(int type) {
        this.type = type;
        this.typechoice.setSelectedIndex(type);
    }

    public void setTimeSTART(int index) {
        this.timechoice_START.setSelectedIndex(index);
    }

    public void setTimeEND(int index) {
        this.timechoice_END.setSelectedIndex(index);
    }

    public String getColor() {
        return this.color;
    }

    public String getLegendName() {
        return this.setLegend.getText();
    }

    public String getName() {
        this.name = this.selectedColumn != 0 ? this.table.getColumnName(this.selectedColumn) : this.name;
        return this.name;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int[] getSelectedRows() {
        return this.rowSelection;
    }

    public String getPosition() {
        return this.position;
    }

    public int getRendererType() {
        return this.type;
    }

    public int getTimeSTART() {
        return this.timechoice_START.getSelectedIndex();
    }

    public int getTimeEND() {
        return this.timechoice_END.getSelectedIndex();
    }

    public boolean axisInverted() {
        return this.invBox.isSelected();
    }

    public JCheckBox getInvBox() {
        return this.invBox;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JComboBox getPosChoice() {
        return this.poschoice;
    }

    public JComboBox getTypeChoice() {
        return this.typechoice;
    }

    public JComboBox getColorChoice() {
        return this.colorchoice;
    }

    public JTextField getLegendField() {
        return this.setLegend;
    }

    public JComboBox getDataChoice() {
        return this.setColumn;
    }

    public JComboBox getTimeChoiceSTART() {
        return this.timechoice_START;
    }

    public JComboBox getTimeChoiceEND() {
        return this.timechoice_END;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getRemButton() {
        return this.remButton;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public JButton getPlotButton() {
        return this.plotButton;
    }
}

