/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.image;

import com.sun.j3d.utils.image.ImageException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.imageio.ImageIO;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;

public class TextureLoader {
    public static final int GENERATE_MIPMAP = 1;
    public static final int BY_REFERENCE = 2;
    public static final int Y_UP = 4;
    public static final int ALLOW_NON_POWER_OF_TWO = 8;
    private static ColorSpace cs = ColorSpace.getInstance(1000);
    private static int[] nBits = new int[]{8, 8, 8, 8};
    private static int[] bandOffset = new int[]{0, 1, 2, 3};
    private static ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
    private Texture2D tex = null;
    private BufferedImage bufferedImage = null;
    private ImageComponent2D imageComponent = null;
    private int textureFormat = 6;
    private int imageComponentFormat = 2;
    private int flags;
    private boolean byRef = false;
    private boolean yUp = false;
    private boolean forcePowerOfTwo = true;

    public TextureLoader(BufferedImage bufferedImage) {
        this(bufferedImage, null, 0);
    }

    public TextureLoader(BufferedImage bufferedImage, String string) {
        this(bufferedImage, string, 0);
    }

    public TextureLoader(BufferedImage bufferedImage, int n) {
        this(bufferedImage, null, n);
    }

    public TextureLoader(BufferedImage bufferedImage, String string, int n) {
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = bufferedImage;
        if (string == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
        if ((n & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(Image image, Component component) {
        this(image, null, 0, component);
    }

    public TextureLoader(Image image, String string, Component component) {
        this(image, string, 0, component);
    }

    public TextureLoader(Image image, int n, Component component) {
        this(image, null, n, component);
    }

    public TextureLoader(Image image, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        this.parseFormat(string);
        this.flags = n;
        this.bufferedImage = this.createBufferedImage(image, component);
        if (string == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
        if ((n & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(String string, Component component) {
        this(string, null, 0, component);
    }

    public TextureLoader(String string, String string2, Component component) {
        this(string, string2, 0, component);
    }

    public TextureLoader(String string, int n, Component component) {
        this(string, null, n, component);
    }

    public TextureLoader(final String string, String string2, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        this.bufferedImage = (BufferedImage)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ImageIO.read(new File(string));
                }
                catch (IOException iOException) {
                    throw new ImageException(iOException);
                }
            }
        });
        this.parseFormat(string2);
        this.flags = n;
        if (string2 == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if (this.bufferedImage == null) {
            throw new ImageException("Error loading image: " + string);
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
        if ((n & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(URL uRL, Component component) {
        this(uRL, null, 0, component);
    }

    public TextureLoader(URL uRL, String string, Component component) {
        this(uRL, string, 0, component);
    }

    public TextureLoader(URL uRL, int n, Component component) {
        this(uRL, null, n, component);
    }

    public TextureLoader(final URL uRL, String string, int n, Component component) {
        if (component == null) {
            component = new Container();
        }
        this.bufferedImage = (BufferedImage)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ImageIO.read(uRL);
                }
                catch (IOException iOException) {
                    throw new ImageException(iOException);
                }
            }
        });
        this.parseFormat(string);
        this.flags = n;
        if (string == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if (this.bufferedImage == null) {
            throw new ImageException("Error loading image: " + uRL.toString());
        }
        if ((n & 2) != 0) {
            this.byRef = true;
        }
        if ((n & 4) != 0) {
            this.yUp = true;
        }
        if ((n & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public ImageComponent2D getImage() {
        if (this.imageComponent == null) {
            this.imageComponent = new ImageComponent2D(this.imageComponentFormat, this.bufferedImage, this.byRef, this.yUp);
        }
        return this.imageComponent;
    }

    public ImageComponent2D getScaledImage(float f, float f2) {
        if (f == 1.0f && f2 == 1.0f) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, f, f2), this.byRef, this.yUp);
    }

    public ImageComponent2D getScaledImage(int n, int n2) {
        if (this.bufferedImage.getWidth() == n && this.bufferedImage.getHeight() == n2) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, n, n2), this.byRef, this.yUp);
    }

    public Texture getTexture() {
        ImageComponent2D[] imageComponent2DArray = null;
        BufferedImage[] bufferedImageArray = null;
        if (this.tex == null) {
            int n;
            int n2;
            if (this.bufferedImage == null) {
                return null;
            }
            if (this.forcePowerOfTwo) {
                n2 = this.getClosestPowerOf2(this.bufferedImage.getWidth());
                n = this.getClosestPowerOf2(this.bufferedImage.getHeight());
            } else {
                n2 = this.bufferedImage.getWidth();
                n = this.bufferedImage.getHeight();
            }
            if ((this.flags & 1) != 0) {
                BufferedImage bufferedImage = this.bufferedImage;
                int n3 = n2;
                int n4 = n;
                int n5 = Math.max(this.computeLog(n2), this.computeLog(n)) + 1;
                imageComponent2DArray = new ImageComponent2D[n5];
                bufferedImageArray = new BufferedImage[n5];
                this.tex = new Texture2D(2, this.textureFormat, n2, n);
                for (int i = 0; i < n5; ++i) {
                    bufferedImageArray[i] = this.getScaledImage(bufferedImage, n3, n4);
                    imageComponent2DArray[i] = new ImageComponent2D(this.imageComponentFormat, bufferedImageArray[i], this.byRef, this.yUp);
                    this.tex.setImage(i, (ImageComponent)imageComponent2DArray[i]);
                    if (this.forcePowerOfTwo) {
                        if (n3 > 1) {
                            n3 >>= 1;
                        }
                        if (n4 > 1) {
                            n4 >>= 1;
                        }
                    } else {
                        if (n3 > 1) {
                            n3 = (int)Math.floor((double)n3 / 2.0);
                        }
                        if (n4 > 1) {
                            n4 = (int)Math.floor((double)n4 / 2.0);
                        }
                    }
                    bufferedImage = bufferedImageArray[i];
                }
            } else {
                imageComponent2DArray = new ImageComponent2D[1];
                bufferedImageArray = new BufferedImage[]{this.getScaledImage(this.bufferedImage, n2, n)};
                imageComponent2DArray[0] = new ImageComponent2D(this.imageComponentFormat, bufferedImageArray[0], this.byRef, this.yUp);
                this.tex = new Texture2D(1, this.textureFormat, n2, n);
                this.tex.setImage(0, (ImageComponent)imageComponent2DArray[0]);
            }
            this.tex.setMinFilter(3);
            this.tex.setMagFilter(3);
        }
        return this.tex;
    }

    private BufferedImage createBufferedImage(Image image, Component component) {
        component.prepareImage(image, null);
        while (true) {
            int n;
            if (((n = component.checkImage(image, null)) & 0x40) != 0) {
                return null;
            }
            if ((n & 0x20) != 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, bandOffset, null);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, component);
        return bufferedImage;
    }

    private void chooseFormat(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 2: 
            case 6: {
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                this.imageComponentFormat = 1;
                this.textureFormat = 5;
                break;
            }
            case 0: {
                if (!this.is4ByteRGBAOr3ByteRGB(bufferedImage)) break;
                SampleModel sampleModel = bufferedImage.getSampleModel();
                if (sampleModel.getNumBands() == 3) {
                    this.imageComponentFormat = 1;
                    this.textureFormat = 5;
                    break;
                }
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
                break;
            }
            default: {
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
            }
        }
    }

    private boolean is4ByteRGBAOr3ByteRGB(RenderedImage renderedImage) {
        boolean bl = false;
        int n = this.getImageType(renderedImage);
        if (n != 0) {
            return false;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        int n2 = colorSpace.getType();
        if (n2 == 5) {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl3 = true;
                for (int i = 0; i < n3; ++i) {
                    if (nArray2[i] == 8) continue;
                    bl3 = false;
                    break;
                }
                if (bl3 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                    if (n3 == 3) {
                        bl = true;
                    } else if (nArray[3] == 3 && !bl2) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    private int getImageType(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getType();
        }
        ColorModel colorModel = renderedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = colorSpace.getType();
        boolean bl = colorModel.isAlphaPremultiplied();
        if (n2 != 5) {
            if (n2 == 6 && colorModel instanceof ComponentColorModel) {
                if (sampleModel.getDataType() == 0) {
                    n = 10;
                } else if (sampleModel.getDataType() == 1) {
                    n = 11;
                }
            }
        } else {
            int n3 = sampleModel.getNumBands();
            if (sampleModel.getDataType() == 0 && colorModel instanceof ComponentColorModel && sampleModel instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
                int[] nArray2 = componentColorModel.getComponentSize();
                boolean bl2 = true;
                for (int i = 0; i < n3; ++i) {
                    if (nArray2[i] == 8) continue;
                    bl2 = false;
                    break;
                }
                if (bl2 && nArray[0] == n3 - 1 && nArray[1] == n3 - 2 && nArray[2] == n3 - 3) {
                    if (n3 == 3) {
                        n = 5;
                    } else if (nArray[3] == 0) {
                        n = bl ? 7 : 6;
                    }
                }
            }
        }
        return n;
    }

    private void parseFormat(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("RGBA")) {
            this.imageComponentFormat = 2;
            this.textureFormat = 6;
        } else if (string.equals("RGBA4")) {
            this.imageComponentFormat = 6;
            this.textureFormat = 6;
        } else if (string.equals("RGB5_A1")) {
            this.imageComponentFormat = 4;
            this.textureFormat = 6;
        } else if (string.equals("RGB")) {
            this.imageComponentFormat = 1;
            this.textureFormat = 5;
        } else if (string.equals("RGB4")) {
            this.imageComponentFormat = 5;
            this.textureFormat = 5;
        } else if (string.equals("RGB5")) {
            this.imageComponentFormat = 3;
            this.textureFormat = 5;
        } else if (string.equals("R3_G3_B2")) {
            this.imageComponentFormat = 9;
            this.textureFormat = 5;
        } else if (string.equals("LUM8_ALPHA8")) {
            this.imageComponentFormat = 8;
            this.textureFormat = 4;
        } else if (string.equals("LUM4_ALPHA4")) {
            this.imageComponentFormat = 7;
            this.textureFormat = 4;
        } else if (string.equals("LUMINANCE")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 2;
        } else if (string.equals("ALPHA")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 3;
        }
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        return this.getScaledImage(bufferedImage, f, f2);
    }

    private BufferedImage getScaledImage(BufferedImage bufferedImage, float f, float f2) {
        Object object;
        BufferedImage bufferedImage2;
        WritableRaster writableRaster;
        Object object2;
        if (f == 1.0f && f2 == 1.0f) {
            return bufferedImage;
        }
        int n = (int)((double)((float)bufferedImage.getWidth() * f) + 0.5);
        int n2 = (int)((double)((float)bufferedImage.getHeight() * f2) + 0.5);
        int n3 = bufferedImage.getType();
        if (n3 != 0) {
            object2 = bufferedImage.getRaster();
            writableRaster = ((Raster)object2).createCompatibleWritableRaster(0, 0, n, n2);
            bufferedImage2 = new BufferedImage(n, n2, n3);
        } else {
            int n4;
            int n5 = bufferedImage.getSampleModel().getNumBands();
            object = new int[n5];
            int[] nArray = new int[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                object[n4] = n4;
                nArray[n4] = 8;
            }
            writableRaster = Raster.createInterleavedRaster(0, n, n2, n * n5, n5, object, null);
            switch (n5) {
                case 1: {
                    n4 = 10;
                    break;
                }
                case 3: {
                    n4 = 5;
                    break;
                }
                case 4: {
                    n4 = 6;
                    break;
                }
                default: {
                    throw new ImageException("Illegal number of bands : " + n5);
                }
            }
            bufferedImage2 = new BufferedImage(n, n2, n4);
        }
        bufferedImage2.setData(writableRaster);
        object2 = bufferedImage2.createGraphics();
        object = AffineTransform.getScaleInstance(f, f2);
        ((Graphics2D)object2).transform((AffineTransform)object);
        ((Graphics)object2).drawImage(bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    private int computeLog(int n) {
        int n2 = 0;
        if (n == 0) {
            return -1;
        }
        while (n != 1) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        while (n >= (n2 *= 2)) {
        }
        int n3 = n2 / 2;
        if (n2 - n > n - n3) {
            return n3;
        }
        return n2;
    }
}

