/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp.xml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.geotools.data.shapefile.shp.xml.IdInfo;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ShpXmlFileReader {
    Document dom;

    public ShpXmlFileReader(URL metadatFileURL) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(false);
        URLConnection connection = metadatFileURL.openConnection();
        this.dom = builder.build(connection.getInputStream());
    }

    public Metadata parse() {
        return this.parseMetadata(this.dom.getRootElement());
    }

    protected Metadata parseMetadata(Element root) {
        Metadata meta = new Metadata();
        meta.setIdinfo(this.parseIdInfo(root.getChild("idinfo")));
        return meta;
    }

    protected IdInfo parseIdInfo(Element element) {
        IdInfo idInfo = new IdInfo();
        Element bounding = element.getChild("spdom").getChild("bounding");
        idInfo.setBounding(this.parseBounding(bounding));
        Element lbounding = element.getChild("spdom").getChild("lbounding");
        idInfo.setLbounding(this.parseBounding(lbounding));
        return idInfo;
    }

    protected Envelope parseBounding(Element bounding) {
        if (bounding == null) {
            return new Envelope();
        }
        double minX = Double.parseDouble(bounding.getChildText("westbc"));
        double maxX = Double.parseDouble(bounding.getChildText("eastbc"));
        double minY = Double.parseDouble(bounding.getChildText("southbc"));
        double maxY = Double.parseDouble(bounding.getChildText("northbc"));
        return new Envelope(minX, maxX, minY, maxY);
    }
}

