/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactoryFinder;

public class MapLegend
extends JPanel {
    private static final long serialVersionUID = -7169187524356250926L;
    private Map m;
    public static Style style;

    private static String rgbToHex(int r, int g, int b) {
        String[] RGB = new String[256];
        int k = 0;
        String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                RGB[k] = hex[i] + hex[j];
                ++k;
            }
        }
        return "#" + RGB[r] + RGB[g] + RGB[b];
    }

    private static Style generateSLD(Map cmap) throws Exception {
        String sld = "<UserStyle><FeatureTypeStyle>";
        for (int i = 0; i < cmap.size() - 1; ++i) {
            String hexColor = MapLegend.rgbToHex(((Color)cmap.keySet().toArray()[cmap.size() - i - 1]).getRed(), ((Color)cmap.keySet().toArray()[cmap.size() - i - 1]).getGreen(), ((Color)cmap.keySet().toArray()[cmap.size() - i - 1]).getBlue());
            sld = sld + "<rule><Filter><And><PropertyIsLessThanOrEqualTo><PropertyName>newAt</PropertyName><Literal>" + cmap.get(cmap.keySet().toArray()[i + 1]) + "</Literal>" + "</PropertyIsLessThanOrEqualTo>" + "<PropertyIsGreaterThan>" + "<PropertyName>newAt</PropertyName>" + "<Literal>" + cmap.get(cmap.keySet().toArray()[i]) + "</Literal>" + "</PropertyIsGreaterThan>" + "</And></Filter>" + "<PolygonSymbolizer>" + "<Fill>" + "<CssParameter name='fill'>" + hexColor + "</CssParameter>" + "</Fill>" + "<Stroke>" + "<CssParameter name='stroke'>#000000</CssParameter>" + "<CssParameter name='stroke-width'>1</CssParameter>" + "</Stroke>" + "</PolygonSymbolizer>" + "</rule>";
        }
        sld = sld + "</FeatureTypeStyle></UserStyle>";
        ByteArrayInputStream stringInput = new ByteArrayInputStream(sld.getBytes());
        SLDParser parse = new SLDParser(StyleFactoryFinder.createStyleFactory(), (InputStream)stringInput);
        return parse.readXML()[0];
    }

    public static Map coloring(Set<Double> d, int numRanges, String rangeColor) throws Exception {
        int v;
        int col;
        Double val = Math.rint(new Double(510.0 / (double)(d.size() - 1)) * 1000.0) / 1000.0;
        TreeMap<Integer, Double> colmap = new TreeMap<Integer, Double>();
        Object[] li = d.toArray();
        colmap.put(1, (Double)li[0]);
        colmap.put(510, (Double)li[li.length - 1]);
        if (val > 1.0) {
            col = 1;
            for (v = 2; v <= 509; ++v) {
                if ((double)v < (double)col * val) {
                    colmap.put(v, (Double)li[col - 1]);
                    continue;
                }
                colmap.put(v, (Double)li[col]);
                ++col;
            }
        } else {
            col = 2;
            for (v = 2; v <= li.length - 1; ++v) {
                if (Math.floor(0.0 + new Double(v) * val) != (double)col) continue;
                colmap.put(col, (Double)li[v]);
                ++col;
            }
        }
        if (numRanges > d.size()) {
            numRanges = d.size();
        }
        int range = new Double(Math.round(colmap.size() / numRanges)).intValue();
        LinkedHashMap<Color, Double> colors = new LinkedHashMap<Color, Double>();
        colors.put(new Color(0, 0, 0), Double.NEGATIVE_INFINITY);
        if (rangeColor.equalsIgnoreCase("red")) {
            int rangecounts = 1;
            for (int i = range; i <= 510; i += range) {
                if (rangecounts == numRanges) {
                    colors.put(new Color(255, i - 255, i - 255), (Double)colmap.get(510));
                } else if (i <= 255) {
                    colors.put(new Color(i, 0, 0), (Double)colmap.get(i));
                } else {
                    colors.put(new Color(255, i - 255, i - 255), (Double)colmap.get(i));
                }
                ++rangecounts;
            }
        } else if (rangeColor.equalsIgnoreCase("green")) {
            int rangecounts = 1;
            for (int i = range; i <= 510; i += range) {
                if (rangecounts == numRanges) {
                    colors.put(new Color(i - 255, 255, i - 255), (Double)colmap.get(510));
                } else if (i <= 255) {
                    colors.put(new Color(0, i, 0), (Double)colmap.get(i));
                } else {
                    colors.put(new Color(i - 255, 255, i - 255), (Double)colmap.get(i));
                }
                ++rangecounts;
            }
        } else if (rangeColor.equalsIgnoreCase("blue")) {
            int rangecounts = 1;
            for (int i = range; i <= 510; i += range) {
                if (rangecounts == numRanges) {
                    colors.put(new Color(i - 255, i - 255, 255), (Double)colmap.get(510));
                } else if (i <= 255) {
                    colors.put(new Color(0, 0, i), (Double)colmap.get(i));
                } else {
                    colors.put(new Color(i - 255, i - 255, 255), (Double)colmap.get(i));
                }
                ++rangecounts;
            }
        } else {
            System.out.println("Not supported color for rangeColor");
        }
        style = MapLegend.generateSLD(colors);
        return colors;
    }

    private void drawColorLegend(Graphics g) {
        g.setFont(new Font("SansSerif", 0, 12));
        for (int i = 1; i <= this.m.size() - 1; ++i) {
            g.setColor((Color)this.m.keySet().toArray()[i]);
            g.fillRect(10, 30 + 20 * i, 35, 15);
            g.setColor(Color.BLACK);
            g.drawRect(9, 30 + 20 * i - 1, 35, 15);
            g.drawString("<= " + this.m.get(this.m.keySet().toArray()[i]).toString(), 55, 42 + 20 * i);
        }
    }

    public MapLegend(Set<Double> li, int numOfRanges, String rangeColor, String param) throws Exception {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(130, 300));
        this.m = MapLegend.coloring(li, numOfRanges, rangeColor);
        ColorLegend legend = new ColorLegend(param);
        this.add((Component)legend, "Center");
    }

    public class ColorLegend
    extends JPanel {
        private static final long serialVersionUID = -7372979558213566863L;
        public String paramname;

        public ColorLegend(String param) {
            this.paramname = param;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setFont(new Font("SansSerif", 1, 14));
            g.drawString("Legend", 10, 20);
            g.setFont(new Font("SansSerif", 2, 12));
            g.drawString(this.paramname, 10, 40);
            MapLegend.this.drawColorLegend(g);
        }
    }
}

