/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="JAMS simple progress bar", author="Sven Kralisch", date="1. December 2005", description="This visual component creates a small progress bar showing how many iterations of the enclosing context already have passed.")
public class JAMSProgress
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Title string for progress bar")
    public JAMSString title;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Progress bar height")
    public JAMSInteger height;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Progress bar width")
    public JAMSInteger width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Progress bar always on top?")
    public JAMSBoolean ontop;
    private JProgressBar jamsProgressBar;
    private JFrame frame;
    private JButton cancelButton;
    private Runnable updatePBar;
    private int counter;

    public void init() {
        this.counter = 0;
        this.frame = new JFrame();
        this.jamsProgressBar = new JProgressBar();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setAlwaysOnTop(this.ontop.getValue());
        this.frame.setTitle(this.title.getValue());
        this.frame.setName("JAMSProgress");
        this.frame.setResizable(false);
        this.frame.setUndecorated(true);
        this.jamsProgressBar.setPreferredSize(new Dimension(this.width.getValue(), this.height.getValue()));
        this.jamsProgressBar.setString(this.title.getValue());
        this.jamsProgressBar.setStringPainted(true);
        this.jamsProgressBar.setIndeterminate(false);
        this.frame.getContentPane().add((Component)this.jamsProgressBar, "Center");
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAMSProgress.this.cancelButtonActionPerformed(evt);
            }
        });
        this.frame.getContentPane().add((Component)this.cancelButton, "East");
        this.frame.setIconImage(new ImageIcon(ClassLoader.getSystemResource("resources/images/JAMSicon16.png")).getImage());
        this.frame.pack();
        this.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.frame.getWidth()) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)this.frame.getHeight()) / 2);
        this.jamsProgressBar.setMinimum(0);
        this.jamsProgressBar.setMaximum((int)this.getContext().getNumberOfIterations());
        this.jamsProgressBar.setValue(this.counter);
        this.updatePBar = new Runnable(){

            @Override
            public void run() {
                JAMSProgress.this.jamsProgressBar.setValue(++JAMSProgress.this.counter);
            }
        };
        this.frame.setVisible(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.getModel().getRuntime().sendHalt();
    }

    public void run() {
        SwingUtilities.invokeLater(this.updatePBar);
    }

    public void cleanup() {
        this.frame.dispose();
    }
}

