/*
 * Decompiled with CFR 0.152.
 */
package jams.components.demomodel;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="ABCModel precip reader", author="Sven Kralisch", description="ABC model climate data reader")
public class ABCDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Input data file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Precip value read from file")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Runoff value read from file")
    public JAMSDouble runoff;
    private BufferedReader reader;

    public void init() {
        try {
            this.reader = new BufferedReader(new FileReader(this.fileName.getValue()));
            this.reader.readLine();
            this.reader.readLine();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        try {
            String line = this.reader.readLine();
            StringTokenizer st = new StringTokenizer(line);
            String token = st.nextToken();
            token = st.nextToken();
            this.precip.setValue(Double.parseDouble(token));
            token = st.nextToken();
            this.runoff.setValue(Double.parseDouble(token));
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

