/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import org.unijena.predictionnet.kernels.MeanModell;

public abstract class Kernel {
    int inputDim;
    int parameterCount;
    int KernelParameterCount;
    double[] theta = null;
    double[] meanTheta = null;
    public MeanModell MM = null;

    public void SetMeanModell(MeanModell MM) {
        this.MM = MM;
        this.parameterCount = this.KernelParameterCount + MM.GetParameterCount();
    }

    public boolean SetParameter(double[] theta) {
        int i;
        if (theta.length < this.parameterCount) {
            return false;
        }
        this.theta = new double[this.KernelParameterCount];
        for (i = 0; i < this.KernelParameterCount; ++i) {
            this.theta[i] = theta[i];
        }
        if (this.MM != null && this.MM.GetParameterCount() != 0) {
            this.meanTheta = new double[this.MM.GetParameterCount()];
            for (i = this.KernelParameterCount; i < theta.length; ++i) {
                this.meanTheta[i - this.KernelParameterCount] = Math.log(theta[i]);
            }
            this.MM.SetParameters(this.meanTheta);
        }
        return true;
    }

    public abstract double kernel(double[] var1, double[] var2, int var3, int var4);

    public abstract double dkernel(double[] var1, double[] var2, int var3);

    public int getParameterCount() {
        return this.parameterCount;
    }
}

