/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import org.unijena.predictionnet.Matrix;

public class Regression {
    public static int errorCount;

    public static double[] getPolyParams(Matrix D, int degree) throws Exception {
        return Regression.getRegressionParams(D, degree);
    }

    public static double[] getExpoParams(Matrix D) throws Exception {
        for (int i = 0; i < D.rows; ++i) {
            D.element[i][1] = Math.log(D.element[i][1]) / Math.log(Math.E);
        }
        double[] result = Regression.getRegressionParams(D, 1);
        result[0] = Math.pow(Math.E, result[0]);
        return result;
    }

    public static double[] getRegressionParams(Matrix D, int degree) throws Exception {
        int c;
        degree = Math.min(D.rows - 1, degree);
        double[] result = new double[degree + 1];
        if (degree > 5 || degree < 0) {
            double[] dummy = new double[]{0.0, 1.0};
            return dummy;
        }
        for (c = 1; c < D.rows - 1 && D.element[0][0] == D.element[c][0]; ++c) {
        }
        if (c == D.rows - 1) {
            ++errorCount;
            throw new Exception("invalid set of sampling points");
        }
        int j = degree + 1;
        Matrix A = new Matrix(D.rows, j, 1.0);
        for (int k = 1; k < A.columns; ++k) {
            for (int i = 0; i < A.rows; ++i) {
                A.element[i][k] = Math.pow(D.element[i][0], k);
            }
        }
        Matrix Q = A.Q();
        Matrix R = Matrix.multiply(Q.transpose(), A);
        Matrix b = Matrix.multiply(Q.transpose(), D.sub(0, D.rows - 1, 1, 1));
        b = new Matrix(b.sub(0, R.columns - 1, 0, 0));
        R = new Matrix(R.sub(0, R.columns - 1, 0, R.columns - 1));
        Matrix x = Matrix.divide(b, R);
        for (j = 0; j <= degree; ++j) {
            result[j] = 0.0;
        }
        for (j = 0; j < x.rows; ++j) {
            result[j] = x.element[j][0];
        }
        return result;
    }
}

