/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.testFunctions;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Hosaki Test Function", author="Peter Krause", description="A test function for optimizers which has a global and a local optimum")
public class HosakiTestFunction
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="parameter X1")
    public JAMSDouble paraX1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="parameter X2")
    public JAMSDouble paraX2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="function y")
    public JAMSDouble yVal;

    public void run() {
        double x1 = this.paraX1.getValue();
        double x2 = this.paraX2.getValue();
        double y = (1.0 - 8.0 * x1 + 7.0 * Math.pow(x1, 2.0) - 2.3333333333333335 * Math.pow(x1, 3.0) + 0.25 * Math.pow(x1, 4.0)) * Math.pow(x2, 2.0) * Math.exp(-1.0 * x2);
        this.yVal.setValue(y);
    }
}

