/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcRainSnowParts", author="Peter Krause", description="Divides precip into rain and snow based on mean temperature")
public class CalcRainSnowParts
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="HRU attribute name area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRS")
    public JAMSDouble snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRANS")
    public JAMSDouble snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable min temperature or mean")
    public JAMSDouble tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean temperature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable precipitation")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable rain")
    public JAMSDouble rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable snow")
    public JAMSDouble snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="save variable rain")
    public JAMSDouble svRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="save variable snow")
    public JAMSDouble svSnow;

    public void init() {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double temperature = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
        double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - temperature) / (2.0 * this.snow_trans.getValue());
        if (pSnow > 1.0) {
            pSnow = 1.0;
        } else if (pSnow < 0.0) {
            pSnow = 0.0;
        }
        double precip = this.precip.getValue() * this.area.getValue();
        if (precip < 0.0) {
            precip = 0.0;
        }
        double rain = (1.0 - pSnow) * precip;
        double snow = pSnow * precip;
        this.snow.setValue(snow);
        this.rain.setValue(rain);
        this.svSnow.setValue(snow);
        this.svRain.setValue(rain);
    }

    public void cleanup() {
    }
}

