/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import java.io.IOException;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSVarDescription;

public class Regionalisation_2
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of data values for current time step")
    public JAMSDoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Regression coefficients")
    public JAMSDoubleArray regCoeff = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station elevations")
    public JAMSDoubleArray statElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="data set descriptor")
    public JAMSString dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's x coordinates")
    public JAMSDoubleArray statX = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's y coordinates")
    public JAMSDoubleArray statY = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Array of station's weights")
    public JAMSDoubleArray statWeights = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name x coordinate (hru)")
    public JAMSDouble unitX;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Attribute name y coordinate (hru)")
    public JAMSDouble unitY;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="regionalised data value")
    public JAMSDouble dataValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Attribute name elevation")
    public JAMSDouble entityElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of IDW stations")
    public JAMSInteger nidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Power of IDW function")
    public JAMSDouble pidw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Apply elevation correction to measured data")
    public JAMSBoolean elevationCorrection;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Minimum r\u00b2 value for elevation correction application")
    public JAMSDouble rsqThreshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        double[] regCoeff = this.regCoeff.getValue();
        double gradient = regCoeff[1];
        double rsq = regCoeff[2];
        double[] sourceElevations = this.statElevation.getValue();
        double[] sourceData = this.dataArray.getValue();
        double[] sourceWeights = this.statWeights.getValue();
        double targetElevation = this.entityElevation.getValue();
        double value = 0.0;
        double deltaElev = 0.0;
        for (int i = 0; i < sourceElevations.length; ++i) {
            if (rsq >= this.rsqThreshold.getValue() && this.elevationCorrection.getValue()) {
                deltaElev = targetElevation - sourceElevations[i];
                double tVal = (deltaElev * gradient + sourceData[i]) * sourceWeights[i];
                value += tVal;
                continue;
            }
            value += sourceData[i] * sourceWeights[i];
        }
        this.dataValue.setValue(value);
    }

    public void cleanup() throws IOException {
    }
}

