/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcDailyNetRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Workspace directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean temperature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable relative humidity")
    public JAMSDouble rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable solar radiation")
    public JAMSDouble solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable albedo")
    public JAMSDouble albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute elevation")
    public JAMSDouble elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily net radiation [MJ/m\u00b2]")
    public JAMSDouble netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily shortwave radiation [MJ/m\u00b2]")
    public JAMSDouble swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily longwave radiation [MJ/m\u00b2]")
    public JAMSDouble lwRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="daily net radiation for refET [MJ/m\u00b2]")
    public JAMSDouble refETNetRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;
    private File cacheFile_n;
    private File cacheFile_refET;
    private boolean useCache = false;
    private ObjectOutputStream writer_norm;
    private ObjectOutputStream writer_refET;
    private ObjectInputStream reader_norm;
    private ObjectInputStream reader_refET;

    public void init() throws JAMSEntity.NoSuchAttributeException, IOException {
        this.cacheFile_n = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + "_norm.cache");
        this.cacheFile_refET = new File(this.dirName.getValue() + "/$" + this.getInstanceName() + "_refET.cache");
        if (this.cacheFile_n.exists() || this.dataCaching.getValue()) {
            // empty if block
        }
        if (!this.cacheFile_refET.exists() && this.dataCaching.getValue()) {
            this.getModel().getRuntime().sendHalt(this.getInstanceName() + ": dataCaching is true but no cache file available!");
        }
        if (this.dataCaching.getValue()) {
            this.useCache = true;
            this.reader_norm = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile_n)));
            this.reader_refET = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile_refET)));
        } else {
            this.useCache = false;
            this.writer_norm = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile_n)));
            this.writer_refET = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile_refET)));
        }
    }

    public void run() throws JAMSEntity.NoSuchAttributeException, IOException {
        if (!this.useCache) {
            double elev = this.elevation.getValue();
            double temp = this.tmean.getValue();
            double rh = this.rhum.getValue();
            double sR = this.solRad.getValue();
            double alb = this.albedo.getValue();
            double extraTerrestialRad = this.extRad.getValue();
            double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temp);
            double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
            double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraTerrestialRad);
            double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sR);
            double netRefETSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(0.23, sR);
            double netLWRadiation = DailySolarRadiationCalculationMethods.calc_DailyNetLongwaveRadiation(temp, act_vapour_pressure, sR, clearSkyRad, false);
            double nR_norm = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
            double nR_refET = SolarRadiationCalculationMethods.calc_NetRadiation(netRefETSWRadiation, netLWRadiation);
            this.netRad.setValue(nR_norm);
            this.refETNetRad.setValue(nR_refET);
            this.swRad.setValue(netSWRadiation);
            this.lwRad.setValue(netLWRadiation);
            this.writer_norm.writeDouble(nR_norm);
            this.writer_refET.writeDouble(nR_refET);
        } else {
            this.netRad.setValue(this.reader_norm.readDouble());
            this.refETNetRad.setValue(this.reader_refET.readDouble());
        }
    }

    public void cleanup() throws IOException {
        if (!this.useCache) {
            this.writer_norm.flush();
            this.writer_norm.close();
            this.writer_refET.flush();
            this.writer_refET.close();
        } else {
            this.reader_norm.close();
            this.reader_refET.close();
        }
    }
}

