/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.interception;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessInterception", author="Peter Krause", description="Calculates daily interception based on DICKINSON 1984")
public class J2KProcessInterception
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="hru")
    public JAMSEntity hru;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="hruID")
    public JAMSDouble hruID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="attribute area")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable mean tempeature")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable rain")
    public JAMSDouble rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable snow")
    public JAMSDouble snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable potET")
    public JAMSDouble potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable actET")
    public JAMSDouble actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="state variable LAI")
    public JAMSDouble actLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRS")
    public JAMSDouble snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Snow parameter TRANS")
    public JAMSDouble snow_trans;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Interception parameter a_rain")
    public JAMSDouble a_rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Interception parameter a_snow")
    public JAMSDouble a_snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net-rain")
    public JAMSDouble netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable net-snow")
    public JAMSDouble netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable throughfall")
    public JAMSDouble throughfall;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable dy-interception")
    public JAMSDouble interception;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="state variable interception storage")
    public JAMSDouble intercStorage;

    public void init() throws JAMSEntity.NoSuchAttributeException {
        this.intercStorage.setValue(0.0);
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        double deltaIntc;
        double relSnow;
        double relRain;
        double alpha = 0.0;
        double out_throughfall = 0.0;
        double out_interception = 0.0;
        double in_rain = this.rain.getValue();
        double in_snow = this.snow.getValue();
        double in_temp = this.tmean.getValue();
        double in_potETP = this.potET.getValue();
        double in_actETP = this.actET.getValue();
        double in_LAI = this.actLAI.getValue();
        double in_Area = this.area.getValue();
        double out_InterceptionStorage = this.intercStorage.getValue();
        double out_actETP = in_actETP;
        double sum_precip = in_rain + in_snow;
        double deltaETP = in_potETP - in_actETP;
        if (sum_precip > 0.0) {
            relRain = in_rain / sum_precip;
            relSnow = in_snow / sum_precip;
        } else {
            relRain = 1.0;
            relSnow = 0.0;
        }
        alpha = in_temp < this.snow_trs.getValue() - this.snow_trans.getValue() ? this.a_snow.getValue() : this.a_rain.getValue();
        double maxIntcCap = in_LAI * alpha * in_Area;
        if (out_InterceptionStorage > maxIntcCap) {
            out_throughfall = out_InterceptionStorage - maxIntcCap;
            out_InterceptionStorage = maxIntcCap;
        }
        if ((deltaIntc = maxIntcCap - out_InterceptionStorage) > 0.0) {
            if (sum_precip > deltaIntc) {
                out_InterceptionStorage = maxIntcCap;
                out_throughfall += (sum_precip -= deltaIntc);
                out_interception = deltaIntc;
                deltaIntc = 0.0;
            } else {
                out_InterceptionStorage += sum_precip;
                out_interception = sum_precip;
                sum_precip = 0.0;
            }
        } else {
            out_throughfall += sum_precip;
        }
        if (deltaETP > 0.0) {
            if (out_InterceptionStorage > deltaETP) {
                out_InterceptionStorage -= deltaETP;
                out_actETP = in_actETP + deltaETP;
                deltaETP = 0.0;
            } else {
                out_actETP = in_actETP + (in_potETP - (deltaETP -= out_InterceptionStorage));
                out_InterceptionStorage = 0.0;
            }
        } else {
            out_actETP = deltaETP;
        }
        this.netRain.setValue(out_throughfall * relRain);
        this.netSnow.setValue(out_throughfall * relSnow);
        this.actET.setValue(out_actETP);
        this.intercStorage.setValue(out_InterceptionStorage);
        this.interception.setValue(out_interception);
        this.throughfall.setValue(out_throughfall);
    }

    public void cleanup() {
        this.intercStorage.setValue(0.0);
    }
}

