/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import org.unijena.j2k.statistics.Regression;
import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="CalcAbsoluteHumidity", author="Peter Krause", description="Calculates absolute humidity of relative humidity and temperatureat climate station location. If either rhum or temp is missing ahum will no be calculated.")
public class CalcAbsoluteHumidity_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the relative humidity values")
    public JAMSDoubleArray rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="temperature for the computation")
    public JAMSDoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="absolute humidity values")
    public JAMSDoubleArray ahum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station elevations")
    public JAMSDoubleArray tempElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's x coordinate")
    public JAMSDoubleArray tempXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of temperature station's y coordinate")
    public JAMSDoubleArray tempYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station elevations")
    public JAMSDoubleArray rhumElevation = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station's x coordinate")
    public JAMSDoubleArray rhumXCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="Array of rhum station's y coordinate")
    public JAMSDoubleArray rhumYCoord = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="rsqr for ahum stations")
    public JAMSDoubleArray regCoeffAhum = new JAMSDoubleArray();
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Use caching of regionalised data?")
    public JAMSBoolean dataCaching;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (!this.dataCaching.getValue()) {
            int i;
            double[] rhum = this.rhum.getValue();
            double[] temperature = this.temperature.getValue();
            double[] ahum = new double[rhum.length];
            double[] rhumElev = new double[rhum.length];
            double[] rhumX = new double[rhum.length];
            double[] rhumY = new double[rhum.length];
            double[] tempElev = new double[temperature.length];
            double[] tempX = new double[temperature.length];
            double[] tempY = new double[temperature.length];
            for (i = 0; i < rhum.length; ++i) {
                rhumElev[i] = this.rhumElevation.getValue()[i];
                rhumX[i] = this.rhumXCoord.getValue()[i];
                rhumY[i] = this.rhumYCoord.getValue()[i];
            }
            for (i = 0; i < temperature.length; ++i) {
                tempElev[i] = this.tempElevation.getValue()[i];
                tempX[i] = this.tempXCoord.getValue()[i];
                tempY[i] = this.tempYCoord.getValue()[i];
            }
            for (int r = 0; r < ahum.length; ++r) {
                if (rhum[r] > 0.0) {
                    int t;
                    double rhumTemp = 0.0;
                    double absDist = -1.0;
                    for (t = 0; absDist != 0.0 && t < temperature.length; ++t) {
                        absDist = tempX[t] - rhumX[r] - (tempY[t] - rhumY[r]) - (tempElev[t] - rhumElev[r]);
                    }
                    rhumTemp = temperature[t - 1];
                    if (rhumTemp > -9999.0) {
                        double est = 6.11 * Math.exp(17.62 * rhumTemp / (243.12 + rhumTemp));
                        double maxHum = est * 216.7 / (rhumTemp + 273.15);
                        ahum[r] = maxHum * (rhum[r] / 100.0);
                        continue;
                    }
                    ahum[r] = -9999.0;
                    continue;
                }
                ahum[r] = -9999.0;
            }
            this.ahum.setValue(ahum);
            this.regCoeffAhum.setValue(Regression.calcLinReg(this.rhumElevation.getValue(), this.ahum.getValue()));
        }
    }

    public void cleanup() throws JAMSEntity.NoSuchAttributeException {
    }
}

