/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSDoubleArray;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KArrayGrabber", author="Peter Krause", description="")
public class J2KArrayGrabber
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="temporal resolution [m | d | h]")
    public JAMSString tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="time")
    public JAMSCalendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="extraTerrRadiationArray")
    public JAMSDoubleArray extRadArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="LeafAreaIndexArray")
    public JAMSDoubleArray LAIArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="EffectiveHeightArray")
    public JAMSDoubleArray effHArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="rsc0 Array")
    public JAMSDoubleArray rsc0Array;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="slopeAscpectCorrectionFactorArray")
    public JAMSDoubleArray slAsCfArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actExtraTerrRadiation")
    public JAMSDouble actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actLAI")
    public JAMSDouble actLAI;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actEffH")
    public JAMSDouble actEffH;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actRsc0")
    public JAMSDouble actRsc0;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="actSlopeAscpectCorrectionFactor")
    public JAMSDouble actSlAsCf;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        int monthCount = this.time.get(2);
        int dayCount = this.time.get(6) - 1;
        int hourCount = this.time.get(11) + 24 * dayCount;
        double in_LAI = -9999.0;
        double in_effH = -9999.0;
        double in_extRad = -9999.0;
        double in_scf = -9999.0;
        double in_rsc0 = -9999.0;
        if (this.rsc0Array != null) {
            in_rsc0 = this.rsc0Array.getValue()[monthCount];
        }
        if (this.tempRes.getValue().equals("m")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[monthCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[monthCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[monthCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[monthCount];
            }
        } else if (this.tempRes.getValue().equals("d")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[dayCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[dayCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[dayCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[dayCount];
            }
        } else if (this.tempRes.getValue().equals("h")) {
            if (this.LAIArray != null) {
                in_LAI = this.LAIArray.getValue()[dayCount];
            }
            if (this.effHArray != null) {
                in_effH = this.effHArray.getValue()[dayCount];
            }
            if (this.extRadArray != null) {
                in_extRad = this.extRadArray.getValue()[hourCount];
            }
            if (this.slAsCfArray != null) {
                in_scf = this.slAsCfArray.getValue()[dayCount];
            }
        }
        this.actLAI.setValue(in_LAI);
        this.actEffH.setValue(in_effH);
        this.actRsc0.setValue(in_rsc0);
        this.actSlAsCf.setValue(in_scf);
        this.actExtRad.setValue(in_extRad);
    }

    public void cleanup() {
    }
}

