/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import org.unijena.jams.data.JAMSBoolean;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntity;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SnowModule", author="Peter Krause", description="Simple day-degree-approach to account for snow storage and snowmelt.Depends on a temperature threshold and a day-degree-factor")
public class SnowModule
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Entity area", unit="m\u00b2")
    public JAMSDouble area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Parameter ddf")
    public JAMSDouble ddf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Parameter threshold")
    public JAMSDouble t_thres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="the snow storage ")
    public JAMSDouble snowStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="precip")
    public JAMSDouble precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the tmin input")
    public JAMSDouble tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the tmean input")
    public JAMSDouble tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="the tmax input")
    public JAMSDouble tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="the snowmelt output")
    public JAMSDouble snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, update=JAMSVarDescription.UpdateType.RUN, description="remaining precip")
    public JAMSDouble restPrecip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="module active")
    public JAMSBoolean active;

    public void init() throws JAMSEntity.NoSuchAttributeException {
    }

    public void run() throws JAMSEntity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            double snowStorage = this.snowStorage.getValue();
            double precip = this.precip.getValue() * this.area.getValue();
            this.precip.setValue(precip);
            double tmin = this.tmin.getValue();
            double tmean = this.tmean.getValue();
            double tmax = this.tmax.getValue();
            double snowMelt = 0.0;
            double accuTemp = (tmin + tmean) / 2.0;
            double meltTemp = (tmax + tmean) / 2.0;
            if (accuTemp <= this.t_thres.getValue()) {
                snowStorage += precip;
                precip = 0.0;
            }
            if (meltTemp > this.t_thres.getValue() && snowStorage > 0.0) {
                double mt = meltTemp - this.t_thres.getValue();
                double potMelt = mt * this.ddf.getValue() * this.area.getValue();
                if (snowStorage < potMelt) {
                    snowMelt = snowStorage;
                    snowStorage = 0.0;
                } else {
                    snowMelt = potMelt;
                    snowStorage -= snowMelt;
                }
            }
            this.snowStorage.setValue(snowStorage);
            this.snowMelt.setValue(snowMelt);
            this.restPrecip.setValue(precip);
        }
    }

    public void cleanup() {
        if (this.active == null || this.active.getValue()) {
            this.snowStorage.setValue(0.0);
        }
    }
}

