/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryConfigurationError;

public final class FactoryFinder {
    static final Logger LOG = Logger.getLogger("org.geotools.factory");

    private FactoryFinder() {
    }

    private static Object newInstance(String clazz, ClassLoader loader) {
        Logger logger = Logger.getLogger("org.geotools.factory");
        logger.finest("Creating instance from '" + clazz + '\'');
        try {
            Class<?> spiClass = loader == null ? Class.forName(clazz) : loader.loadClass(clazz);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError("Provider " + clazz + " not found - " + "please check your classpath", x);
        }
        catch (ExceptionInInitializerError eiie) {
            throw new FactoryConfigurationError("Provider " + clazz + " not initialized - " + "error in constructor", eiie);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError("Provider " + clazz + " could not be instantiated - " + "is it abstract, an interface, an array, or does it not have an " + "empty constructor?", ie);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError("Provider " + clazz + " could not be accessed - " + "is it private or is the empty constructor private?", iae);
        }
    }

    public static ClassLoader[] findClassLoaders() {
        ClassLoader[] classLoaders;
        Logger logger = Logger.getLogger("org.geotools.factory");
        logger.finest("Finding ClassLoader");
        ClassLoader contextLoader = null;
        try {
            contextLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        ClassLoader systemLoader = FactoryFinder.class.getClassLoader();
        if (contextLoader == null || contextLoader == systemLoader) {
            classLoaders = new ClassLoader[]{systemLoader};
            logger.finest("Using system ClassLoader only" + systemLoader);
        } else {
            classLoaders = new ClassLoader[]{contextLoader, systemLoader};
            logger.finest("Using context ClassLoader " + contextLoader + " and system ClassLoader " + systemLoader);
        }
        return classLoaders;
    }

    private static Factory getFactory(URL resource, ClassLoader loader) throws IOException {
        Logger.getLogger("org.geotools.factory").finest("Searching resource " + resource);
        if (resource == null) {
            return null;
        }
        InputStream in = resource.openStream();
        return FactoryFinder.getFactory(in, loader);
    }

    private static Factory getFactory(InputStream in, ClassLoader loader) throws IOException {
        LOG.finest("Reading Factory , has stream : " + (in != null));
        if (in != null) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String factoryClassName = rd.readLine().trim();
            rd.close();
            if (factoryClassName != null && factoryClassName.length() != 0) {
                return (Factory)FactoryFinder.newInstance(factoryClassName, loader);
            }
            LOG.finest("Factory name unacceptable : '" + factoryClassName + '\'');
        }
        return null;
    }

    private static List getFactories(URL resource, ClassLoader loader) throws IOException {
        LOG.finest("Searching resource " + resource);
        if (resource == null) {
            return null;
        }
        InputStream in = resource.openStream();
        return FactoryFinder.getFactories(in, loader);
    }

    private static List getFactories(InputStream in, ClassLoader loader) throws IOException {
        LOG.finest("Reading Factory , has stream : " + (in != null));
        ArrayList<Object> list = new ArrayList<Object>();
        if (in != null) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String factoryClassName = rd.readLine();
            while (factoryClassName != null && factoryClassName.trim().length() > 0) {
                factoryClassName = factoryClassName.trim();
                list.add(FactoryFinder.newInstance(factoryClassName, loader));
                LOG.finest("Factory name unacceptable : '" + factoryClassName + '\'');
                factoryClassName = rd.readLine();
            }
        }
        return list;
    }

    public static Factory findFactory(String factoryKey, String defaultImpl, ClassLoader classLoader) throws FactoryConfigurationError, ClassCastException {
        int i;
        LOG.finest("findFactory(" + factoryKey + ',' + defaultImpl + ',' + classLoader + ')');
        ClassLoader[] loaders = classLoader == null ? FactoryFinder.findClassLoaders() : new ClassLoader[]{classLoader};
        for (int i2 = 0; i2 < loaders.length; ++i2) {
            LOG.finest("ClassLoader : " + loaders[i2]);
        }
        try {
            LOG.finest("Searching system properties");
            String systemProp = System.getProperty(factoryKey);
            if (systemProp != null) {
                LOG.finest(factoryKey + '=' + systemProp);
                for (i = 0; i < loaders.length; ++i) {
                    try {
                        return (Factory)FactoryFinder.newInstance(systemProp, loaders[i]);
                    }
                    catch (Exception e) {
                        LOG.finest("Could not create an instance using loader: " + loaders[i]);
                        continue;
                    }
                }
            }
            LOG.finest("Key '" + factoryKey + "' not found");
        }
        catch (SecurityException se) {
            LOG.finest("SecurityException " + se.getMessage());
        }
        String serviceId = "META-INF/services/" + factoryKey;
        LOG.finest("Searching for service: " + serviceId);
        try {
            for (i = 0; i < loaders.length; ++i) {
                InputStream is = loaders[i].getResourceAsStream(serviceId);
                Factory f = FactoryFinder.getFactory(is, loaders[i]);
                if (f == null) continue;
                return f;
            }
            LOG.finest("Service '" + serviceId + "' not found");
        }
        catch (Exception ex) {
            LOG.finest("Exception " + ex.getMessage());
        }
        LOG.finest("Resorting to default");
        if (defaultImpl == null) {
            LOG.finest("No default");
            throw new FactoryConfigurationError("Provider for " + factoryKey + " cannot be found", null);
        }
        for (int i3 = 0; i3 < loaders.length - 1; ++i3) {
            try {
                return (Factory)FactoryFinder.newInstance(defaultImpl, loaders[i3]);
            }
            catch (FactoryConfigurationError e) {
                continue;
            }
        }
        return (Factory)FactoryFinder.newInstance(defaultImpl, loaders[loaders.length - 1]);
    }

    public static Factory findFactory(String factoryKey, String defaultImpl) throws FactoryConfigurationError, ClassCastException {
        return FactoryFinder.findFactory(factoryKey, defaultImpl, null);
    }

    public static Iterator factories(Class key) {
        return FactoryFinder.factories(key, null);
    }

    public static Iterator factories(Class key, final ClassLoader loader) {
        String clazz = key.getName();
        String serviceId = "META-INF/services/" + clazz;
        try {
            ArrayList<URL> allresources;
            ClassLoader[] loaders = null;
            if (loader == null) {
                loaders = FactoryFinder.findClassLoaders();
            }
            if (loaders == null) {
                allresources = Collections.list(loader.getResources(serviceId));
            } else {
                allresources = Collections.list(loaders[0].getResources(serviceId));
                for (int i = 1; i < loaders.length; ++i) {
                    allresources.addAll(Collections.list(loaders[i].getResources(serviceId)));
                }
            }
            final Iterator resources = allresources.iterator();
            return new Iterator(){
                Iterator activeList = null;

                public boolean hasNext() {
                    if (this.activeList == null) {
                        return resources.hasNext();
                    }
                    return this.activeList.hasNext() || resources.hasNext();
                }

                public Object next() {
                    if (this.activeList == null) {
                        try {
                            URL url = (URL)resources.next();
                            List factories = FactoryFinder.getFactories(url, loader);
                            this.activeList = factories.iterator();
                        }
                        catch (IOException ioe) {
                            return null;
                        }
                    }
                    Factory fac = (Factory)this.activeList.next();
                    if (!this.activeList.hasNext()) {
                        this.activeList = null;
                    }
                    return fac;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected IOException " + ioe.getMessage(), ioe);
        }
    }
}

