/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import org.geotools.util.LiteCoordinateSequence;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class Decimator {
    private double spanx = -1.0;
    private double spany = -1.0;

    public Decimator(MathTransform screenToWorld, Rectangle paintArea) {
        if (screenToWorld != null) {
            double[] original = new double[]{(double)paintArea.x + (double)paintArea.width / 2.0, (double)paintArea.y + (double)paintArea.height / 2.0, (double)paintArea.x + (double)paintArea.width / 2.0 + 1.0, (double)paintArea.y + (double)paintArea.height / 2.0 + 1.0};
            double[] coords = new double[4];
            try {
                screenToWorld.transform(original, 0, coords, 0, 2);
            }
            catch (TransformException e) {
                return;
            }
            this.spanx = Math.abs(coords[0] - coords[2]) * 0.8;
            this.spany = Math.abs(coords[1] - coords[3]) * 0.8;
        } else {
            this.spanx = 1.0;
            this.spany = 1.0;
        }
    }

    public Decimator(MathTransform screenToWorld) {
        this(screenToWorld, new Rectangle());
    }

    public final void decimateTransformGeneralize(Geometry geometry, MathTransform transform) throws TransformException {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            int length = collection.getNumGeometries();
            for (int i = 0; i < length; ++i) {
                this.decimateTransformGeneralize(collection.getGeometryN(i), transform);
            }
        } else if (geometry instanceof Point) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((Point)geometry).getCoordinateSequence();
            this.decimateTransformGeneralize(seq, transform);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.decimateTransformGeneralize((Geometry)polygon.getExteriorRing(), transform);
            int length = polygon.getNumInteriorRing();
            for (int i = 0; i < length; ++i) {
                this.decimateTransformGeneralize((Geometry)polygon.getInteriorRingN(i), transform);
            }
        } else if (geometry instanceof LineString) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((LineString)geometry).getCoordinateSequence();
            this.decimateTransformGeneralize(seq, transform);
        }
    }

    public final void decimate(Geometry geom) {
        block6: {
            block7: {
                block5: {
                    if (this.spanx == -1.0) {
                        return;
                    }
                    if (geom instanceof MultiPoint) {
                        return;
                    }
                    if (!(geom instanceof GeometryCollection)) break block5;
                    GeometryCollection collection = (GeometryCollection)geom;
                    int numGeometries = collection.getNumGeometries();
                    for (int i = 0; i < numGeometries; ++i) {
                        this.decimate(collection.getGeometryN(i));
                    }
                    break block6;
                }
                if (!(geom instanceof LineString)) break block7;
                LineString line = (LineString)geom;
                LiteCoordinateSequence seq = (LiteCoordinateSequence)line.getCoordinateSequence();
                if (this.decimateOnEnvelope((Geometry)line, seq)) {
                    return;
                }
                this.decimate(seq);
                break block6;
            }
            if (!(geom instanceof Polygon)) break block6;
            Polygon line = (Polygon)geom;
            this.decimate((Geometry)line.getExteriorRing());
            int numRings = line.getNumInteriorRing();
            for (int i = 0; i < numRings; ++i) {
                this.decimate((Geometry)line.getInteriorRingN(i));
            }
        }
    }

    private boolean decimateOnEnvelope(Geometry geom, LiteCoordinateSequence seq) {
        Envelope env = geom.getEnvelopeInternal();
        if (env.getWidth() <= this.spanx && env.getHeight() <= this.spany) {
            double[] coords = seq.getArray();
            int dim = seq.getDimension();
            double[] newcoords = new double[dim * 2];
            for (int i = 0; i < dim; ++i) {
                newcoords[i] = coords[i];
                newcoords[dim + i] = coords[coords.length - dim + i];
            }
            seq.setArray(coords);
            return true;
        }
        return false;
    }

    private final void decimateTransformGeneralize(LiteCoordinateSequence seq, MathTransform transform) throws TransformException {
        double[] newCoordsXformed;
        int ncoords = seq.size();
        double[] originalOrds = seq.getXYArray();
        if (ncoords < 2) {
            if (ncoords == 1) {
                double[] newCoordsXformed2 = new double[2];
                transform.transform(originalOrds, 0, newCoordsXformed2, 0, 1);
                seq.setArray(newCoordsXformed2);
                return;
            }
            return;
        }
        double[] allCoords = new double[ncoords * 2];
        allCoords[0] = originalOrds[0];
        allCoords[1] = originalOrds[1];
        int actualCoords = 1;
        double lastX = allCoords[0];
        double lastY = allCoords[1];
        for (int t = 1; t < ncoords - 1; ++t) {
            double x = originalOrds[t * 2];
            double y = originalOrds[t * 2 + 1];
            if (!(Math.abs(x - lastX) > this.spanx) && !(Math.abs(y - lastY) > this.spany)) continue;
            allCoords[actualCoords * 2] = x;
            allCoords[actualCoords * 2 + 1] = y;
            lastX = x;
            lastY = y;
            ++actualCoords;
        }
        allCoords[actualCoords * 2] = originalOrds[(ncoords - 1) * 2];
        allCoords[actualCoords * 2 + 1] = originalOrds[(ncoords - 1) * 2 + 1];
        ++actualCoords;
        if (transform == null || transform.isIdentity()) {
            newCoordsXformed = allCoords;
        } else {
            newCoordsXformed = new double[actualCoords * 2];
            transform.transform(allCoords, 0, newCoordsXformed, 0, actualCoords);
        }
        double[] finalCoords = new double[ncoords * 2];
        finalCoords[0] = newCoordsXformed[0];
        finalCoords[1] = newCoordsXformed[1];
        int actualCoordsGen = 1;
        lastX = newCoordsXformed[0];
        lastY = newCoordsXformed[1];
        for (int t = 1; t < actualCoords - 1; ++t) {
            double x = newCoordsXformed[t * 2];
            double y = newCoordsXformed[t * 2 + 1];
            if (!(Math.abs(x - lastX) > 0.75) && !(Math.abs(y - lastY) > 0.75)) continue;
            finalCoords[actualCoordsGen * 2] = x;
            finalCoords[actualCoordsGen * 2 + 1] = y;
            lastX = x;
            lastY = y;
            ++actualCoordsGen;
        }
        finalCoords[actualCoordsGen * 2] = newCoordsXformed[(actualCoords - 1) * 2];
        finalCoords[actualCoordsGen * 2 + 1] = newCoordsXformed[(actualCoords - 1) * 2 + 1];
        double[] seqDouble = new double[2 * ++actualCoordsGen];
        System.arraycopy(finalCoords, 0, seqDouble, 0, actualCoordsGen * 2);
        seq.setArray(seqDouble);
    }

    private void decimate(LiteCoordinateSequence seq) {
        double[] coords = seq.getArray();
        int numDoubles = coords.length;
        int dim = seq.getDimension();
        int readDoubles = 0;
        for (int currentDoubles = 0; currentDoubles < numDoubles; currentDoubles += dim) {
            if (currentDoubles >= dim && currentDoubles < numDoubles - 1) {
                double prevx = coords[readDoubles - dim];
                double currx = coords[currentDoubles];
                double diffx = Math.abs(prevx - currx);
                double prevy = coords[readDoubles - dim + 1];
                double curry = coords[currentDoubles + 1];
                double diffy = Math.abs(prevy - curry);
                if (!(diffx > this.spanx) && !(diffy > this.spany)) continue;
                readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
                continue;
            }
            readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
        }
        double[] newCoords = new double[readDoubles];
        System.arraycopy(coords, 0, newCoords, 0, readDoubles);
        seq.setArray(newCoords);
    }

    private int copyCoordinate(double[] coords, int dimension, int readDoubles, int currentDoubles) {
        for (int i = 0; i < dimension; ++i) {
            coords[readDoubles + i] = coords[currentDoubles + i];
        }
        return readDoubles += dimension;
    }
}

