/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;

public class FilterFunction_atan2
extends FunctionExpressionImpl
implements FunctionExpression {
    private Expression[] args;

    public String getName() {
        return "atan2";
    }

    public int getArgCount() {
        return 2;
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public String toString() {
        String result = "atan2(";
        for (int t = 0; t < this.args.length; ++t) {
            result = result + this.args[t] + ",";
        }
        result = result + ")";
        return result;
    }

    public Object evaluate(Feature feature) {
        double arg1;
        double arg0;
        try {
            arg0 = ((Number)this.args[0].getValue(feature)).doubleValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function atan2 argument #0 - expected type double");
        }
        try {
            arg1 = ((Number)this.args[1].getValue(feature)).doubleValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function atan2 argument #1 - expected type double");
        }
        return new Double(Math.atan2(arg0, arg1));
    }
}

