/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.fidmapper.AutoIncrementFIDMapper;
import org.geotools.data.jdbc.fidmapper.BasicFIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.MaxIncFIDMapper;
import org.geotools.data.jdbc.fidmapper.MultiColumnFIDMapper;
import org.geotools.data.jdbc.fidmapper.NullFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.feature.FeatureType;

public class DefaultFIDMapperFactory
implements FIDMapperFactory {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private boolean returningTypedFIDMapper = true;
    protected boolean returnFIDColumnsAsAttributes = false;

    public DefaultFIDMapperFactory() {
    }

    public DefaultFIDMapperFactory(boolean returnFIDColumnsAsAttributes) {
        this.returnFIDColumnsAsAttributes = returnFIDColumnsAsAttributes;
    }

    public FIDMapper getMapper(String catalog, String schema, String tableName, Connection connection) throws IOException {
        ColumnInfo[] colInfos = this.getPkColumnInfo(catalog, schema, tableName, connection);
        FIDMapper mapper = null;
        if (colInfos.length == 0) {
            mapper = this.buildNoPKMapper(schema, tableName, connection);
        } else if (colInfos.length > 1) {
            mapper = this.buildMultiColumnFIDMapper(schema, tableName, connection, colInfos);
        } else {
            ColumnInfo ci = colInfos[0];
            mapper = this.buildSingleColumnFidMapper(schema, tableName, connection, ci);
        }
        if (mapper == null && (mapper = this.buildLastResortFidMapper(schema, tableName, connection, colInfos)) == null) {
            String msg = "Cannot map primary key to a FID mapper, primary key columns are:\n" + this.getColumnInfoList(colInfos);
            LOGGER.log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        if (this.returningTypedFIDMapper && mapper != null) {
            return new TypedFIDMapper(mapper, tableName);
        }
        return mapper;
    }

    protected List getColumnInfoList(ColumnInfo[] colInfos) {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        for (int i = 0; i < colInfos.length; ++i) {
            list.add(colInfos[i]);
        }
        return list;
    }

    protected FIDMapper buildLastResortFidMapper(String schema, String tableName, Connection connection, ColumnInfo[] colInfos) {
        return null;
    }

    protected FIDMapper buildSingleColumnFidMapper(String schema, String tableName, Connection connection, ColumnInfo ci) {
        if (ci.autoIncrement) {
            return new AutoIncrementFIDMapper(schema, tableName, ci.colName, ci.dataType);
        }
        if (this.isIntegralType(ci.dataType)) {
            return new MaxIncFIDMapper(schema, tableName, ci.colName, ci.dataType, this.returnFIDColumnsAsAttributes);
        }
        return new BasicFIDMapper(ci.colName, ci.size, this.returnFIDColumnsAsAttributes);
    }

    protected FIDMapper buildNoPKMapper(String schema, String tableName, Connection connection) {
        NullFIDMapper mapper = new NullFIDMapper();
        return mapper;
    }

    protected FIDMapper buildMultiColumnFIDMapper(String schema, String tableName, Connection connection, ColumnInfo[] colInfos) {
        String[] colNames = new String[colInfos.length];
        int[] colTypes = new int[colInfos.length];
        int[] colSizes = new int[colInfos.length];
        int[] colDecimalDigits = new int[colInfos.length];
        boolean[] autoIncrement = new boolean[colInfos.length];
        for (int i = 0; i < colInfos.length; ++i) {
            ColumnInfo ci = colInfos[i];
            colNames[i] = ci.colName;
            colTypes[i] = ci.dataType;
            colSizes[i] = ci.size;
            colDecimalDigits[i] = ci.decimalDigits;
            autoIncrement[i] = ci.autoIncrement;
        }
        return new MultiColumnFIDMapper(schema, tableName, colNames, colTypes, colSizes, colDecimalDigits, autoIncrement);
    }

    protected ColumnInfo[] getPkColumnInfo(String catalog, String schema, String typeName, Connection conn) throws SchemaNotFoundException, DataSourceException {
        ColumnInfo[] columnInfoArray;
        ResultSet tableInfo = null;
        ResultSet pkInfo = null;
        boolean pkMetadataFound = false;
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            HashMap<String, ColumnInfo> pkMap = new HashMap<String, ColumnInfo>();
            pkInfo = dbMetaData.getPrimaryKeys(catalog, schema, typeName);
            pkMetadataFound = true;
            while (pkInfo.next()) {
                ColumnInfo ci = new ColumnInfo();
                ci.colName = pkInfo.getString("COLUMN_NAME");
                ci.keySeq = pkInfo.getInt("KEY_SEQ");
                pkMap.put(ci.colName, ci);
            }
            tableInfo = dbMetaData.getColumns(catalog, schema, typeName, "%");
            boolean tableInfoFound = false;
            while (tableInfo.next()) {
                tableInfoFound = true;
                String columnName = tableInfo.getString("COLUMN_NAME");
                ColumnInfo ci = (ColumnInfo)pkMap.get(columnName);
                if (ci == null) continue;
                ci.dataType = tableInfo.getInt("DATA_TYPE");
                ci.size = tableInfo.getInt("COLUMN_SIZE");
                ci.decimalDigits = tableInfo.getInt("DECIMAL_DIGITS");
                ci.autoIncrement = this.isAutoIncrement(catalog, schema, typeName, conn, tableInfo, columnName, ci.dataType);
            }
            if (!tableInfoFound) {
                throw new SchemaNotFoundException(typeName);
            }
            Collection columnInfos = pkMap.values();
            columnInfoArray = columnInfos.toArray(new ColumnInfo[columnInfos.size()]);
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                if (pkMetadataFound) {
                    throw new DataSourceException("SQL Error building FeatureType for " + typeName + " " + sqlException.getMessage(), (Throwable)sqlException);
                }
                throw new SchemaNotFoundException(typeName, sqlException);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tableInfo);
                throw throwable;
            }
        }
        JDBCUtils.close(tableInfo);
        return columnInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoIncrement(String catalog, String schema, String tableName, Connection conn, ResultSet tableInfo, String columnName, int dataType) throws SQLException {
        if (!this.isIntegralType(dataType)) {
            return false;
        }
        boolean autoIncrement = false;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            statement.setFetchSize(1);
            String query = "SELECT " + columnName + " FROM ";
            if (schema != null) {
                query = query + schema + ".";
            }
            query = query + tableName + " WHERE 0=1";
            rs = statement.executeQuery(query);
            ResultSetMetaData rsInfo = rs.getMetaData();
            autoIncrement = rsInfo.isAutoIncrement(1);
        }
        catch (Throwable throwable) {
            JDBCUtils.close(statement);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close(statement);
        JDBCUtils.close(rs);
        return autoIncrement;
    }

    protected boolean isIntegralType(int dataType) {
        return dataType == -5 || dataType == 4 || dataType == 2 || dataType == 5 || dataType == -6 || dataType == 3;
    }

    protected boolean isTextType(int dataType) {
        return dataType == 12 || dataType == 1 || dataType == 2005;
    }

    public FIDMapper getMapper(FeatureType featureType) {
        return new BasicFIDMapper("ID", 255, false);
    }

    protected class ColumnInfo
    implements Comparable {
        String colName;
        int dataType;
        int size;
        int decimalDigits;
        boolean autoIncrement;
        int keySeq;

        protected ColumnInfo() {
        }

        public int compareTo(Object o) {
            return this.keySeq - ((ColumnInfo)o).keySeq;
        }

        public String toString() {
            return "ColumnInfo, name(" + this.colName + "), type(" + this.dataType + ") size(" + this.size + ") decimalDigits(" + this.decimalDigits + ") autoIncrement(" + this.autoIncrement + ")";
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public String getColName() {
            return this.colName;
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getDecimalDigits() {
            return this.decimalDigits;
        }

        public int getSize() {
            return this.size;
        }
    }
}

