/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.geotools.catalog.AbstractFileService;
import org.geotools.catalog.AbstractGeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.Service;
import org.geotools.util.ProgressListener;

public abstract class AbstractFileGeoResource
extends AbstractGeoResource {
    File file;
    AbstractFileService service;

    public AbstractFileGeoResource(AbstractFileService service) {
        this.service = service;
        this.file = service.getFile();
    }

    public AbstractFileGeoResource(AbstractFileService service, File file) {
        this.service = service;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public Resolve parent(ProgressListener monitor) throws IOException {
        return this.service;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(Service.class) || adaptee.isAssignableFrom(GeoResourceInfo.class) || adaptee.isAssignableFrom(File.class);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Service.class)) {
            return this.parent(monitor);
        }
        if (adaptee.isAssignableFrom(GeoResourceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return this.service.getFile();
        }
        return null;
    }

    public Resolve.Status getStatus() {
        return this.service.getStatus();
    }

    public URI getIdentifier() {
        return this.file.toURI();
    }
}

