/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.rtree;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.index.Data;
import org.geotools.index.rtree.EntryBoundsChangeListener;

public class Entry
implements Cloneable {
    private Envelope bounds;
    private Object data;
    private EntryBoundsChangeListener listener;

    public Entry(Envelope e, Object data) {
        this.bounds = e;
        this.data = data;
    }

    public Envelope getBounds() {
        return this.bounds;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        Entry e = (Entry)obj;
        return this.bounds.equals((Object)e.getBounds()) && this.data.equals(e.getData());
    }

    void setBounds(Envelope envelope) {
        this.bounds = envelope;
        if (this.listener != null) {
            this.listener.boundsChanged(this);
        }
    }

    protected Object clone() {
        Entry ret = new Entry(new Envelope(this.bounds), this.data);
        ret.setListener(this.listener);
        return ret;
    }

    public String toString() {
        return "Entry --> " + this.bounds + " - key: " + this.data;
    }

    public void setListener(EntryBoundsChangeListener listener) {
        this.listener = listener;
    }
}

