/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.resources.NIOUtilities;

public class IndexedFidReader
implements FIDReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.shapefile");
    private ReadableByteChannel readChannel;
    private ByteBuffer buffer;
    private long count;
    private String typeName;
    private boolean done;
    private int removes;
    private int currentShxIndex = -1;
    private RecordNumberTracker reader;
    private long currentId;
    StreamLogging streamLogger = new StreamLogging("IndexedFidReader");

    public IndexedFidReader(String typeName, ReadableByteChannel readChannel) throws IOException {
        this.typeName = typeName + ".";
        this.readChannel = readChannel;
        this.streamLogger.open();
        this.getHeader();
        this.buffer = ByteBuffer.allocateDirect(12288);
        this.buffer.position(this.buffer.limit());
    }

    public IndexedFidReader(String typeName, RecordNumberTracker reader, ReadableByteChannel readChannel) throws IOException {
        this.reader = reader;
        this.typeName = typeName + ".";
        this.readChannel = readChannel;
        this.getHeader();
        this.buffer = ByteBuffer.allocateDirect(12288);
        this.buffer.position(this.buffer.limit());
    }

    private void getHeader() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        ShapefileReader.fill((ByteBuffer)buffer, (ReadableByteChannel)this.readChannel);
        if (buffer.position() == 0) {
            this.done = true;
            this.count = 0L;
            return;
        }
        buffer.position(0);
        byte version = buffer.get();
        if (version != 1) {
            throw new IOException("File is not of a compatible version for this reader or file is corrupt.");
        }
        this.count = buffer.getLong();
        this.removes = buffer.getInt();
    }

    public long getCount() {
        return this.count;
    }

    public int getRemoves() {
        return this.removes;
    }

    public long findFid(String fid) throws IOException {
        try {
            long desired = Long.parseLong(fid.substring(fid.lastIndexOf(".") + 1));
            if (desired < 0L) {
                return -1L;
            }
            if (desired < this.count) {
                return this.search(desired, -1L, this.count, desired - 1L);
            }
            return this.search(desired, -1L, this.count, this.count - 1L);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Fid is not recognized as a fid for this shapefile: " + this.typeName);
            return -1L;
        }
    }

    long search(long desired, long minRec, long maxRec, long predictedRec) throws IOException {
        if (minRec == maxRec) {
            return -1L;
        }
        this.goTo(predictedRec);
        this.buffer.limit(12);
        this.next();
        this.buffer.limit(this.buffer.capacity());
        if (this.currentId == desired) {
            return this.currentShxIndex;
        }
        if (maxRec - minRec < 10L) {
            return this.search(desired, minRec + 1L, maxRec, minRec + 1L);
        }
        long newOffset = desired - this.currentId;
        long newPrediction = predictedRec + newOffset;
        if (newPrediction <= minRec) {
            newPrediction = minRec + (predictedRec - minRec) / 2L;
        }
        if (newPrediction >= maxRec) {
            newPrediction = predictedRec + (maxRec - predictedRec) / 2L;
        }
        if (newPrediction == predictedRec) {
            return -1L;
        }
        if (newPrediction < predictedRec) {
            return this.search(desired, minRec, predictedRec, newPrediction);
        }
        return this.search(desired, predictedRec, maxRec, newPrediction);
    }

    public void goTo(long recno) throws IOException {
        if (!(this.readChannel instanceof FileChannel)) {
            throw new IOException("Read Channel is not a File Channel so this is not possible.");
        }
        FileChannel fc = (FileChannel)this.readChannel;
        fc.position(13L + recno * 12L);
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(this.buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.buffer != null && this.buffer instanceof MappedByteBuffer) {
                NIOUtilities.clean((ByteBuffer)this.buffer);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.readChannel.close();
            this.streamLogger.close();
        }
    }

    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        if (this.buffer.position() == this.buffer.limit()) {
            this.buffer.position(0);
            int read = ShapefileReader.fill((ByteBuffer)this.buffer, (ReadableByteChannel)this.readChannel);
            if (read != 0) {
                this.buffer.position(0);
            }
        }
        return this.buffer.remaining() != 0;
    }

    public String next() throws IOException {
        if (this.reader != null) {
            this.goTo(this.reader.getRecordNumber() - 1);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentId = this.buffer.getLong();
        this.currentShxIndex = this.buffer.getInt();
        return this.typeName + this.currentId;
    }

    public int currentIndex() {
        if (this.currentShxIndex == -1) {
            throw new NoSuchElementException("Next must be called before there exists a current element.");
        }
        return this.currentShxIndex;
    }
}

