/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.spatialschema.geometry.geometry;

import java.util.List;
import java.util.Set;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.spatialschema.geometry.MismatchedReferenceSystemException;
import org.opengis.spatialschema.geometry.aggregate.MultiPrimitive;
import org.opengis.spatialschema.geometry.geometry.Arc;
import org.opengis.spatialschema.geometry.geometry.ArcByBulge;
import org.opengis.spatialschema.geometry.geometry.ArcString;
import org.opengis.spatialschema.geometry.geometry.ArcStringByBulge;
import org.opengis.spatialschema.geometry.geometry.BSplineCurve;
import org.opengis.spatialschema.geometry.geometry.BSplineSurface;
import org.opengis.spatialschema.geometry.geometry.Geodesic;
import org.opengis.spatialschema.geometry.geometry.GeodesicString;
import org.opengis.spatialschema.geometry.geometry.KnotType;
import org.opengis.spatialschema.geometry.geometry.LineSegment;
import org.opengis.spatialschema.geometry.geometry.LineString;
import org.opengis.spatialschema.geometry.geometry.PointArray;
import org.opengis.spatialschema.geometry.geometry.Polygon;
import org.opengis.spatialschema.geometry.geometry.PolyhedralSurface;
import org.opengis.spatialschema.geometry.geometry.Position;
import org.opengis.spatialschema.geometry.geometry.Tin;
import org.opengis.spatialschema.geometry.primitive.Surface;
import org.opengis.spatialschema.geometry.primitive.SurfaceBoundary;

public interface GeometryFactory {
    public CoordinateReferenceSystem getCoordinateReferenceSystem();

    public DirectPosition createDirectPosition();

    public DirectPosition createDirectPosition(double[] var1);

    public Envelope createEnvelope(DirectPosition var1, DirectPosition var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public LineSegment createLineSegment(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public LineString createLineString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Geodesic createGeodesic(Position var1, Position var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public GeodesicString createGeodesicString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Arc createArc(Position var1, Position var2, Position var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Arc createArc(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcString createArcString(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcByBulge createArcByBulge(Position var1, Position var2, double var3, double[] var5) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public ArcStringByBulge createArcStringByBulge(List var1, double[] var2, List var3) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public BSplineCurve createBSplineCurve(int var1, PointArray var2, List var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public BSplineSurface createBSplineSurface(List var1, int[] var2, List[] var3, KnotType var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Polygon createPolygon(SurfaceBoundary var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Polygon createPolygon(SurfaceBoundary var1, Surface var2) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public Tin createTin(Set var1, Set var2, Set var3, double var4) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public PolyhedralSurface createPolyhedralSurface(List var1) throws MismatchedReferenceSystemException, MismatchedDimensionException;

    public MultiPrimitive createMultiPrimitive();
}

