/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import javax.units.Unit;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.Utilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static int dimensionColinearWith(CoordinateSystem cs, CoordinateSystemAxis axis) {
        int candidate = -1;
        int dimension = cs.getDimension();
        AxisDirection direction = axis.getDirection().absolute();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis xi = cs.getAxis(i);
            if (!direction.equals(xi.getDirection().absolute())) continue;
            candidate = i;
            if (axis.equals(xi)) break;
        }
        return candidate;
    }

    public static Unit getUnit(CoordinateSystem cs) {
        Unit unit = null;
        int i = cs.getDimension();
        while (--i >= 0) {
            Unit candidate = cs.getAxis(i).getUnit();
            if (candidate == null) continue;
            if (unit == null) {
                unit = candidate;
                continue;
            }
            if (unit.equals((Object)candidate)) continue;
            return null;
        }
        return unit;
    }

    public static int getDimensionOf(CoordinateReferenceSystem crs, Class type) throws IllegalArgumentException {
        if (!CoordinateReferenceSystem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName());
        }
        if (type.isAssignableFrom(crs.getClass())) {
            return 0;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            int offset = 0;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                CoordinateReferenceSystem ci = (CoordinateReferenceSystem)it.next();
                int index = CRSUtilities.getDimensionOf(ci, type);
                if (index >= 0) {
                    return index + offset;
                }
                offset += ci.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem crs, int lower, int upper) {
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower < 0 || lower > upper || upper > dimension) {
            throw new IndexOutOfBoundsException(Errors.format(56, new Integer(lower < 0 ? lower : upper)));
        }
        while (lower != 0 || upper != dimension) {
            if (!(crs instanceof CompoundCRS)) {
                return null;
            }
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            if (c == null || c.isEmpty()) {
                return null;
            }
            Iterator it = c.iterator();
            while (it.hasNext() && lower >= (dimension = (crs = (CoordinateReferenceSystem)it.next()).getCoordinateSystem().getDimension())) {
                lower -= dimension;
                upper -= dimension;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem crs) throws TransformException {
        if (crs != null) {
            while (crs.getCoordinateSystem().getDimension() != 2) {
                if (!(crs instanceof CompoundCRS)) {
                    throw new TransformException(Errors.format(24, crs.getName().toString()));
                }
                List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
                if (c == null || c.isEmpty()) {
                    return null;
                }
                crs = (CoordinateReferenceSystem)c.get(0);
            }
        }
        return crs;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof SingleCRS && crs.getCoordinateSystem().getDimension() == 2) {
            CoordinateReferenceSystem base = crs;
            while (base instanceof GeneralDerivedCRS) {
                base = ((GeneralDerivedCRS)base).getBaseCRS();
            }
            if (base instanceof GeographicCRS) {
                return (SingleCRS)crs;
            }
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                SingleCRS candidate = CRSUtilities.getHorizontalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ProjectedCRS candidate = CRSUtilities.getProjectedCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                VerticalCRS candidate = CRSUtilities.getVerticalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                TemporalCRS candidate = CRSUtilities.getTemporalCRS((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS ? ((SingleCRS)crs).getDatum() : null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            List c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Ellipsoid candidate = CRSUtilities.getEllipsoid((CoordinateReferenceSystem)it.next());
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeographicCRS)) {
            List c;
            if (crs instanceof CompoundCRS && (c = ((CompoundCRS)crs).getCoordinateReferenceSystems()) != null && !c.isEmpty()) {
                crs = (CoordinateReferenceSystem)c.get(0);
                continue;
            }
            return null;
        }
        return ((GeodeticDatum)((GeographicCRS)crs).getDatum()).getEllipsoid();
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        Extent validArea;
        GeneralEnvelope envelope = null;
        if (crs != null && (validArea = crs.getValidArea()) != null) {
            Iterator it = validArea.getGeographicElements().iterator();
            while (it.hasNext()) {
                GeographicBoundingBox bounds;
                GeographicExtent geo = (GeographicExtent)it.next();
                if (geo instanceof GeographicBoundingBox) {
                    bounds = (GeographicBoundingBox)geo;
                    if (!bounds.getInclusion()) continue;
                } else {
                    if (!(geo instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeneralEnvelope candidate = new GeneralEnvelope(new double[]{bounds.getWestBoundLongitude(), bounds.getSouthBoundLatitude()}, new double[]{bounds.getEastBoundLongitude(), bounds.getNorthBoundLatitude()});
                candidate.setCoordinateReferenceSystem(DefaultGeographicCRS.WGS84);
                if (envelope == null) {
                    envelope = candidate;
                    continue;
                }
                envelope.add(candidate);
            }
        }
        return envelope;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        if (envelope == null) {
            return null;
        }
        if (transform.isIdentity()) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(null);
            return e;
        }
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format(68, new Integer(sourceDim), new Integer(envelope.getDimension())));
        }
        int coordinateNumber = 0;
        GeneralEnvelope transformed = null;
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(sourceDim);
        GeneralDirectPosition targetPt = new GeneralDirectPosition(targetDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block6: while (true) {
            if (targetPt != transform.transform(sourcePt, targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralEnvelope(targetPt, targetPt);
            }
            int n = ++coordinateNumber;
            int i2 = sourceDim;
            block7: while (true) {
                if (--i2 < 0) {
                    return transformed;
                }
                switch (n % 3) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 3;
                        continue block7;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getCenter(i2));
                        continue block6;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block6;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError();
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D source, Rectangle2D dest) throws TransformException {
        if (source == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 8; ++i) {
            point.x = (i & 1) == 0 ? source.getMinX() : source.getMaxX();
            point.y = (i & 2) == 0 ? source.getMinY() : source.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = source.getCenterX();
                    break;
                }
                case 4: 
                case 7: {
                    point.y = source.getCenterY();
                }
            }
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
    }

    public static DirectPosition deltaTransform(MathTransform transform, DirectPosition origin, DirectPosition source) throws TransformException {
        int i;
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        DirectPosition P1 = new GeneralDirectPosition(sourceDim);
        DirectPosition P2 = new GeneralDirectPosition(sourceDim);
        for (i = 0; i < sourceDim; ++i) {
            double c = origin.getOrdinate(i);
            double d = source.getOrdinate(i) * 0.5;
            P1.setOrdinate(i, c - d);
            P2.setOrdinate(i, c + d);
        }
        P1 = transform.transform(P1, sourceDim == targetDim ? P1 : null);
        P2 = transform.transform(P2, sourceDim == targetDim ? P2 : null);
        for (i = 0; i < targetDim; ++i) {
            P2.setOrdinate(i, P2.getOrdinate(i) - P1.getOrdinate(i));
        }
        return P2;
    }

    public static Point2D deltaTransform(MathTransform2D transform, Point2D origin, Point2D source, Point2D dest) throws TransformException {
        if (transform instanceof AffineTransform) {
            return ((AffineTransform)((Object)transform)).deltaTransform(source, dest);
        }
        double ox = origin.getX();
        double oy = origin.getY();
        double dx = source.getX() * 0.5;
        double dy = source.getY() * 0.5;
        Point2D P1 = new Point2D.Double(ox - dx, oy - dy);
        Point2D P2 = new Point2D.Double(ox + dx, oy + dy);
        P1 = transform.transform(P1, P1);
        P2 = transform.transform(P2, P2);
        if (dest == null) {
            dest = P2;
        }
        dest.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return dest;
    }

    public static String toWGS84String(CoordinateReferenceSystem crs, Rectangle2D bounds) {
        Exception exception;
        StringBuffer buffer = new StringBuffer();
        try {
            crs = CRSUtilities.getCRS2D(crs);
            if (!CRSUtilities.equalsIgnoreMetadata(DefaultGeographicCRS.WGS84, crs)) {
                CoordinateOperation op = FactoryFinder.getCoordinateOperationFactory(null).createOperation(crs, DefaultGeographicCRS.WGS84);
                bounds = CRSUtilities.transform((MathTransform2D)op.getMathTransform(), bounds, null);
            }
            AngleFormat fmt = new AngleFormat("DD\u00b0MM.m'");
            buffer = fmt.format(new Latitude(bounds.getMinY()), buffer, null);
            buffer.append('-');
            buffer = fmt.format(new Latitude(bounds.getMaxY()), buffer, null);
            buffer.append(' ');
            buffer = fmt.format(new Longitude(bounds.getMinX()), buffer, null);
            buffer.append('-');
            buffer = fmt.format(new Longitude(bounds.getMaxX()), buffer, null);
            return buffer.toString();
        }
        catch (TransformException e) {
            exception = e;
        }
        catch (FactoryException e) {
            exception = e;
        }
        buffer.append(Utilities.getShortClassName(exception));
        String message = exception.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        return buffer.toString();
    }
}

