/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.extent;

import javax.units.Unit;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.datum.VerticalDatum;

public class VerticalExtentImpl
extends MetadataEntity
implements VerticalExtent {
    private static final long serialVersionUID = -6288728580430359681L;
    private double minimumValue;
    private double maximumValue;
    private Unit unit;
    private VerticalDatum verticalDatum;

    public VerticalExtentImpl() {
    }

    public VerticalExtentImpl(double minimumValue, double maximumValue, Unit unit, VerticalDatum verticalDatum) {
        this.setMinimumValue(minimumValue);
        this.setMaximumValue(maximumValue);
        this.setUnit(unit);
        this.setVerticalDatum(verticalDatum);
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public synchronized void setMinimumValue(double newValue) {
        this.checkWritePermission();
        this.minimumValue = newValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public synchronized void setMaximumValue(double newValue) {
        this.checkWritePermission();
        this.maximumValue = newValue;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public synchronized void setUnit(Unit newValue) {
        this.checkWritePermission();
        this.unit = newValue;
    }

    public VerticalDatum getVerticalDatum() {
        return this.verticalDatum;
    }

    public synchronized void setVerticalDatum(VerticalDatum newValue) {
        this.checkWritePermission();
        this.verticalDatum = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.unit = (Unit)VerticalExtentImpl.unmodifiable(this.unit);
        this.verticalDatum = (VerticalDatum)VerticalExtentImpl.unmodifiable(this.verticalDatum);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            VerticalExtentImpl that = (VerticalExtentImpl)object;
            return Utilities.equals(this.unit, that.unit) && Utilities.equals(this.verticalDatum, that.verticalDatum) && Double.doubleToLongBits(this.minimumValue) == Double.doubleToLongBits(that.minimumValue) && Double.doubleToLongBits(this.maximumValue) == Double.doubleToLongBits(that.maximumValue);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -627436673;
        if (this.unit != null) {
            code ^= this.unit.hashCode();
        }
        if (this.verticalDatum != null) {
            code ^= this.verticalDatum.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.verticalDatum);
    }
}

