/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequence;

public class LiteCoordinateSequence
extends PackedCoordinateSequence {
    private double[] coords;

    public LiteCoordinateSequence(double[] coords) {
        this.dimension = 2;
        if (coords.length % this.dimension != 0) {
            throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
        }
        this.coords = coords;
    }

    public LiteCoordinateSequence(float[] coordinates) {
        this.coords = new double[coordinates.length];
        this.dimension = 2;
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i] = coordinates[i];
        }
    }

    public LiteCoordinateSequence(Coordinate[] coordinates) {
        if (coordinates == null) {
            coordinates = new Coordinate[]{};
        }
        this.dimension = 2;
        this.coords = new double[coordinates.length * this.dimension];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coords[i * this.dimension] = coordinates[i].x;
            if (this.dimension < 2) continue;
            this.coords[i * this.dimension + 1] = coordinates[i].y;
        }
    }

    public LiteCoordinateSequence(int size, int dimension) {
        if (dimension != 2) {
            throw new IllegalArgumentException("This type of sequence is always 2 dimensional");
        }
        this.dimension = 2;
        this.coords = new double[size * this.dimension];
    }

    public Coordinate getCoordinateInternal(int i) {
        double x = this.coords[i * this.dimension];
        double y = this.coords[i * this.dimension + 1];
        double z = this.dimension == 2 ? Double.NaN : this.coords[i * this.dimension + 2];
        return new Coordinate(x, y, z);
    }

    public int size() {
        return this.coords.length / this.dimension;
    }

    public Object clone() {
        double[] clone = new double[this.coords.length];
        System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
        return new LiteCoordinateSequence(clone);
    }

    public double getOrdinate(int index, int ordinate) {
        return this.coords[index * this.dimension + ordinate];
    }

    public void setOrdinate(int index, int ordinate, double value) {
        this.coordRef = null;
        this.coords[index * this.dimension + ordinate] = value;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.coords.length; i += this.dimension) {
            env.expandToInclude(this.coords[i], this.coords[i + 1]);
        }
        return env;
    }

    public double[] getArray() {
        return this.coords;
    }

    public void setArray(double[] coords2) {
        this.coords = coords2;
    }

    public double[] getXYArray() {
        if (this.dimension == 2) {
            return this.coords;
        }
        int n = this.size();
        double[] result = new double[n * 2];
        for (int t = 0; t < n; ++t) {
            result[t * 2] = this.getOrdinate(t, 0);
            result[t * 2 + 1] = this.getOrdinate(t, 1);
        }
        return result;
    }
}

