/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NotImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.DisjointImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.opengis.filter.And;
import org.opengis.filter.FeatureId;
import org.opengis.filter.Filter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.spatialschema.geometry.Geometry;

public abstract class Expr
implements FilterFactory {
    private FunctionFinder functionFinder = new FunctionFinder(null);
    static /* synthetic */ Class class$org$geotools$filter$FunctionExpression;

    public And and(Filter f, Filter g) {
        ArrayList<Filter> list = new ArrayList<Filter>(2);
        list.add(f);
        list.add(g);
        return new AndImpl(this, list);
    }

    public And and(List filters) {
        return new AndImpl(this, filters);
    }

    public Or or(Filter f, Filter g) {
        ArrayList<Filter> list = new ArrayList<Filter>(2);
        list.add(f);
        list.add(g);
        return new OrImpl(this, list);
    }

    public Or or(List filters) {
        return new OrImpl(this, filters);
    }

    public Not not(Filter filter) {
        return new NotImpl((FilterFactory)this, filter);
    }

    public FeatureId featureId(Set ids) {
        FidFilterImpl filter = new FidFilterImpl();
        filter.addAllFids(ids);
        return filter;
    }

    public PropertyName property(String name) {
        return new AttributeExpressionImpl(name);
    }

    public PropertyIsBetween between(org.opengis.filter.expression.Expression expr, org.opengis.filter.expression.Expression lower, org.opengis.filter.expression.Expression upper) {
        return new IsBetweenImpl(this, lower, expr, upper);
    }

    public PropertyIsEqualTo equals(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsEqualsToImpl(this, expr1, expr2);
    }

    public PropertyIsNotEqualTo notEqual(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsNotEqualToImpl(this, expr1, expr2);
    }

    public PropertyIsGreaterThan greater(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsGreaterThanImpl(this, expr1, expr2);
    }

    public PropertyIsGreaterThanOrEqualTo greaterOrEqual(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsGreaterThanOrEqualToImpl(this, expr1, expr2);
    }

    public PropertyIsLessThan less(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsLessThenImpl(this, expr1, expr2);
    }

    public PropertyIsLessThanOrEqualTo lessOrEqual(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new IsLessThenOrEqualToImpl(this, expr1, expr2);
    }

    public PropertyIsLike like(org.opengis.filter.expression.Expression expr, String pattern) {
        return this.like(expr, pattern, null, null, null);
    }

    public PropertyIsLike like(org.opengis.filter.expression.Expression expr, String pattern, String wildcard, String singleChar, String escape) {
        LikeFilterImpl filter = new LikeFilterImpl();
        filter.setExpression(expr);
        filter.setPattern(pattern, wildcard, singleChar, escape);
        return filter;
    }

    public PropertyIsNull isNull(org.opengis.filter.expression.Expression expr) {
        return new IsNullImpl(this, expr);
    }

    public BBOX bbox(String propertyName, double minx, double miny, double maxx, double maxy, String srs) {
        PropertyName name = this.property(propertyName);
        return this.bbox((org.opengis.filter.expression.Expression)name, minx, miny, maxx, maxy, srs);
    }

    public BBOX bbox(org.opengis.filter.expression.Expression e, double minx, double miny, double maxx, double maxy, String srs) {
        PropertyName name = null;
        if (!(e instanceof PropertyName)) {
            throw new IllegalArgumentException();
        }
        name = (PropertyName)e;
        BBoxExpression bbox = null;
        try {
            bbox = this.createBBoxExpression(new Envelope(minx, maxx, miny, maxy));
        }
        catch (IllegalFilterException ife) {
            new IllegalArgumentException().initCause(ife);
        }
        BBOXImpl box = new BBOXImpl(this, e, (org.opengis.filter.expression.Expression)bbox);
        box.setPropertyName(name.getPropertyName());
        box.setSRS(srs);
        box.setMinX(minx);
        box.setMinY(miny);
        box.setMaxX(maxx);
        box.setMaxY(maxy);
        return box;
    }

    public Beyond beyond(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.beyond((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom, distance, units);
    }

    public Beyond beyond(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2, double distance, String units) {
        BeyondImpl beyond = new BeyondImpl(this, geometry1, geometry2);
        beyond.setDistance(distance);
        beyond.setUnits(units);
        return beyond;
    }

    public Contains contains(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.contains((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Contains contains(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new ContainsImpl(this, geometry1, geometry2);
    }

    public Crosses crosses(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.crosses((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Crosses crosses(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new CrossesImpl(this, geometry1, geometry2);
    }

    public Disjoint disjoint(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.disjoint((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Disjoint disjoint(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new DisjointImpl(this, geometry1, geometry2);
    }

    public DWithin dwithin(String propertyName, Geometry geometry, double distance, String units) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.dwithin((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom, distance, units);
    }

    public DWithin dwithin(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2, double distance, String units) {
        DWithinImpl dwithin = new DWithinImpl(this, geometry1, geometry2);
        dwithin.setDistance(distance);
        dwithin.setUnits(units);
        return dwithin;
    }

    public Equals equals(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.equal((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Equals equal(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new EqualsImpl(this, geometry1, geometry2);
    }

    public Intersects intersects(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.intersects((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Intersects intersects(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new IntersectsImpl(this, geometry1, geometry2);
    }

    public Overlaps overlaps(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.overlaps((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Overlaps overlaps(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new OverlapsImpl(this, geometry1, geometry2);
    }

    public Touches touches(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.touches((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Touches touches(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new TouchesImpl(this, geometry1, geometry2);
    }

    public Within within(String propertyName, Geometry geometry) {
        PropertyName name = this.property(propertyName);
        Literal geom = this.literal(geometry);
        return this.within((org.opengis.filter.expression.Expression)name, (org.opengis.filter.expression.Expression)geom);
    }

    public Within within(org.opengis.filter.expression.Expression geometry1, org.opengis.filter.expression.Expression geometry2) {
        return new WithinImpl(this, geometry1, geometry2);
    }

    public Add add(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new AddImpl(expr1, expr2);
    }

    public Divide divide(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new DivideImpl(expr1, expr2);
    }

    public Multiply multiply(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new MultiplyImpl(expr1, expr2);
    }

    public Subtract subtract(org.opengis.filter.expression.Expression expr1, org.opengis.filter.expression.Expression expr2) {
        return new SubtractImpl(expr1, expr2);
    }

    public Function function(String name, org.opengis.filter.expression.Expression[] args) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(args));
        return function;
    }

    public Function function(String name, org.opengis.filter.expression.Expression arg1) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1));
        return function;
    }

    public Function function(String name, org.opengis.filter.expression.Expression arg1, org.opengis.filter.expression.Expression arg2) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2));
        return function;
    }

    public Function function(String name, org.opengis.filter.expression.Expression arg1, org.opengis.filter.expression.Expression arg2, org.opengis.filter.expression.Expression arg3) {
        Function function = this.functionFinder.findFunction(name, Arrays.asList(arg1, arg2, arg3));
        return function;
    }

    public Literal literal(Object obj) {
        try {
            return new LiteralExpressionImpl(obj);
        }
        catch (IllegalFilterException e) {
            throw (RuntimeException)new IllegalArgumentException().initCause(e);
        }
    }

    public Literal literal(byte b) {
        return new LiteralExpressionImpl(b);
    }

    public Literal literal(short s) {
        return new LiteralExpressionImpl(s);
    }

    public Literal literal(int i) {
        return new LiteralExpressionImpl(i);
    }

    public Literal literal(long l) {
        return new LiteralExpressionImpl(l);
    }

    public Literal literal(float f) {
        return new LiteralExpressionImpl(f);
    }

    public Literal literal(double d) {
        return new LiteralExpressionImpl(d);
    }

    public Literal literal(char c) {
        return new LiteralExpressionImpl(c);
    }

    public Literal literal(boolean b) {
        throw new UnsupportedOperationException("Filter api does not support boolean literals");
    }

    private static class FunctionFinder {
        private Map functionExpressionCache;
        private Map functionImplCache;

        public FunctionFinder(Hints hints) {
        }

        public Function findFunction(String name) {
            return this.findFunction(name, null);
        }

        public Function findFunction(String name, List parameters) {
            name = this.functionName(name);
            try {
                Class clazz;
                FunctionExpression function;
                if (this.functionExpressionCache == null) {
                    this.functionExpressionCache = new HashMap();
                    this.functionImplCache = new HashMap();
                    Iterator it = FactoryFinder.factories((Class)(class$org$geotools$filter$FunctionExpression == null ? (class$org$geotools$filter$FunctionExpression = Expr.class$("org.geotools.filter.FunctionExpression")) : class$org$geotools$filter$FunctionExpression));
                    while (it.hasNext()) {
                        function = (FunctionExpression)it.next();
                        this.functionExpressionCache.put(function.getName().toLowerCase(), function.getClass());
                    }
                    Iterator i = FactoryFinder.factories((Class)(class$org$geotools$filter$FunctionExpression == null ? (class$org$geotools$filter$FunctionExpression = Expr.class$("org.geotools.filter.FunctionExpression")) : class$org$geotools$filter$FunctionExpression));
                    while (i.hasNext()) {
                        function = (FunctionExpression)i.next();
                        this.functionImplCache.put(function.getName().toLowerCase(), function.getClass());
                    }
                }
                if ((clazz = (Class)this.functionExpressionCache.get(name.toLowerCase())) != null) {
                    function = (FunctionExpression)clazz.newInstance();
                    if (parameters != null) {
                        function.setArgs(parameters.toArray(new Expression[0]));
                    }
                    return function;
                }
                clazz = (Class)this.functionImplCache.get(name.toLowerCase());
                if (clazz != null) {
                    function = (FunctionExpression)clazz.newInstance();
                    if (parameters != null) {
                        function.setArgs(parameters.toArray(new Expression[0]));
                    }
                    return function;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create class " + name + "Function", e);
            }
            throw new RuntimeException("Unable to find function " + name);
        }

        private String functionName(String name) {
            int index = -1;
            index = name.indexOf("Function");
            if (index != -1) {
                name = name.substring(0, index);
            }
            name = name.toLowerCase().trim();
            char c = name.charAt(0);
            name = name.replaceFirst("" + c, "" + Character.toUpperCase(c));
            return name;
        }
    }
}

