/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.feature.Feature;

public class MaxIncFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;

    public MaxIncFIDMapper(String tableName, String FIDColumn, int FIDColumnType) {
        this(null, tableName, FIDColumn, FIDColumnType, false);
    }

    public MaxIncFIDMapper(String tableSchemaName, String tableName, String FIDColumn, int FIDColumnType, boolean returnFIDColumnsAsAttributes) {
        super(tableSchemaName, tableName);
        this.returnFIDColumnsAsAttributes = returnFIDColumnsAsAttributes;
        this.setInfo(FIDColumn, FIDColumnType, 0, 0, false);
    }

    public String getID(Object[] attributes) {
        return String.valueOf(attributes[0]);
    }

    public Object[] getPKAttributes(String FID) {
        try {
            return new Object[]{new Long(Long.parseLong(FID))};
        }
        catch (NumberFormatException e) {
            return new Object[]{new Long(-1L)};
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedFIDMapper)) {
            return false;
        }
        MaxIncFIDMapper other = (MaxIncFIDMapper)object;
        return other.getColumnName() == this.getColumnName() && other.getColumnType() == this.getColumnType() && other.returnFIDColumnsAsAttributes == this.returnFIDColumnsAsAttributes;
    }

    public String createID(Connection conn, Feature feature, Statement statement) throws IOException {
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("Select MAX(" + this.getColumnName() + ") from " + this.tableName);
            if (rs.next()) {
                long maxFid = rs.getLong(1);
                return String.valueOf(maxFid + 1L);
            }
            throw new DataSourceException("Could not get MAX for " + this.tableName + "." + this.getColumnName() + ": No result returned from query");
        }
        catch (SQLException e) {
            throw new DataSourceException("An sql problem occurred. Are the table and the fid column there?", (Throwable)e);
        }
    }
}

