/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams.gui.input;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.unijena.jams.data.JAMSCalendar;
import org.unijena.jams.gui.LHelper;
import org.unijena.jams.gui.input.InputComponent;
import org.unijena.jams.gui.input.ValueChangeListener;

public class CalendarInput
extends JPanel
implements InputComponent {
    private JTextField syear;
    private JTextField smonth;
    private JTextField sday;
    private JTextField shour;
    private JTextField sminute;
    private Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> fieldMap = new HashMap<Integer, Integer>();
    private JPanel panel;
    private ValueChangeListener l;

    public CalendarInput() {
        GridBagLayout gbl = new GridBagLayout();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(gbl);
        LHelper.addGBComponent(this, gbl, new JLabel("Date (YYYY/MM/DD)"), 1, 0, 1, 1, 0.0, 0.0);
        LHelper.addGBComponent(this, gbl, new JLabel("Time (HH:MM)"), 11, 0, 1, 1, 0.0, 0.0);
        this.syear = new JTextField();
        this.syear.setInputVerifier(new NumericIntervalVerifier(1900.0, 2100.0));
        this.syear.setPreferredSize(new Dimension(40, 20));
        this.smonth = new JTextField();
        this.smonth.setInputVerifier(new NumericIntervalVerifier(1.0, 12.0));
        this.smonth.setPreferredSize(new Dimension(25, 20));
        this.sday = new JTextField();
        this.sday.setInputVerifier(new NumericIntervalVerifier(1.0, 31.0));
        this.sday.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.syear);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.smonth);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.sday);
        LHelper.addGBComponent(this, gbl, this.panel, 1, 1, 10, 1, 0.0, 0.0);
        this.shour = new JTextField();
        this.shour.setInputVerifier(new NumericIntervalVerifier(0.0, 23.0));
        this.shour.setPreferredSize(new Dimension(25, 20));
        this.sminute = new JTextField();
        this.sminute.setInputVerifier(new NumericIntervalVerifier(0.0, 59.0));
        this.sminute.setPreferredSize(new Dimension(25, 20));
        this.panel = new JPanel();
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.panel.add(this.shour);
        this.panel.add(new JLabel(":"));
        this.panel.add(this.sminute);
        LHelper.addGBComponent(this, gbl, this.panel, 11, 1, 1, 1, 0.0, 0.0);
        this.indexMap.put(1, 0);
        this.indexMap.put(2, 1);
        this.indexMap.put(6, 2);
        this.indexMap.put(11, 3);
        this.indexMap.put(12, 4);
        this.indexMap.put(13, 5);
        this.fieldMap.put(0, 1);
        this.fieldMap.put(1, 2);
        this.fieldMap.put(2, 6);
        this.fieldMap.put(3, 11);
        this.fieldMap.put(4, 12);
        this.fieldMap.put(5, 13);
        this.sday.setBorder(BorderFactory.createEtchedBorder());
        this.smonth.setBorder(BorderFactory.createEtchedBorder());
        this.syear.setBorder(BorderFactory.createEtchedBorder());
        this.shour.setBorder(BorderFactory.createEtchedBorder());
        this.sminute.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public String getValue() {
        JAMSCalendar cal = new JAMSCalendar(Integer.parseInt(this.syear.getText()), Integer.parseInt(this.smonth.getText()) - 1, Integer.parseInt(this.sday.getText()), Integer.parseInt(this.shour.getText()), Integer.parseInt(this.sminute.getText()), 0);
        return cal.toString();
    }

    @Override
    public void setValue(String value) {
        JAMSCalendar cal = new JAMSCalendar();
        if (value != "") {
            cal.setValue(value);
        }
        this.syear.setText(Integer.toString(cal.get(1)));
        this.smonth.setText(Integer.toString(cal.get(2) + 1));
        this.sday.setText(Integer.toString(cal.get(5)));
        this.shour.setText(Integer.toString(cal.get(11)));
        this.sminute.setText(Integer.toString(cal.get(12)));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.syear.setEnabled(enabled);
        this.smonth.setEnabled(enabled);
        this.sday.setEnabled(enabled);
        this.shour.setEnabled(enabled);
        this.sminute.setEnabled(enabled);
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public boolean verify() {
        try {
            this.getValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.syear.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.smonth.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.sday.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.shour.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.sminute.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
    }

    class NumericIntervalVerifier
    extends InputVerifier {
        double lower;
        double upper;

        public NumericIntervalVerifier(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result = false;
            try {
                double value = Double.parseDouble(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    result = true;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return result;
        }
    }
}

