/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.jams;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.swing.UIManager;
import org.unijena.jams.JAMSCmdLine;
import org.unijena.jams.JAMSProperties;
import org.unijena.jams.JAMSTools;
import org.unijena.jams.gui.JAMSLauncher;
import org.unijena.jams.gui.JAMSSplash;
import org.unijena.jams.io.XMLIO;
import org.unijena.jams.io.XMLProcessor;
import org.unijena.jams.runtime.StandardRuntime;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JAMS {
    public static final int SILENT = 0;
    public static final int STANDARD = 1;
    public static final int VERBOSE = 2;
    public static final int VVERBOSE = 3;
    public static final int RUNSTATE_STOP = 0;
    public static final int RUNSTATE_RUN = 1;
    public static final Font STANDARD_FONT = new Font("Courier", 0, 11);
    public static final int SPLASH_DISPLAY_TIME = 0;
    private static JAMSCmdLine cmdLine;

    public static void handle(Exception ex) {
        JAMS.handle(ex, true);
    }

    public static void handle(Exception ex, boolean proceed) {
        ex.printStackTrace();
        if (!proceed) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        cmdLine = new JAMSCmdLine(args);
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception evt) {
            // empty catch block
        }
        JAMSProperties properties = JAMSProperties.createJAMSProperties();
        if (cmdLine.getConfigFileName() != null) {
            properties.load(cmdLine.getConfigFileName());
        } else {
            String defaultFile = System.getProperty("user.dir") + System.getProperty("file.separator") + "default.jap";
            File file = new File(defaultFile);
            if (file.exists()) {
                properties.load(defaultFile);
            }
        }
        int guiConfig = Integer.parseInt(properties.getProperty("guiconfig", "0"));
        if (cmdLine.getModelFileName() == null) {
            if (guiConfig == 1) {
                JAMS.startJAMS(properties);
            } else {
                System.out.println("You must provide a model file name (see JAMS --help) when disabling GUI config!");
            }
        } else if (cmdLine.getParameterValues() == null) {
            JAMS.startJAMS(properties, cmdLine.getModelFileName(), null);
        } else {
            JAMS.startJAMS(properties, cmdLine.getModelFileName(), cmdLine.getParameterValues());
        }
    }

    public static void startJAMS(JAMSProperties properties) {
        JAMSSplash splash = new JAMSSplash();
        splash.show(new JAMSLauncher(properties), 0);
    }

    public static void startJAMS(JAMSProperties properties, String modelFilename, String cmdLineParameterValues) {
        int guiConfig = Integer.parseInt(properties.getProperty("guiconfig", "0"));
        if (guiConfig == 1) {
            JAMSSplash splash = new JAMSSplash();
            splash.show(new JAMSLauncher(modelFilename, properties, cmdLineParameterValues), 0);
        } else {
            String info = "";
            File file = new File(modelFilename);
            if (!file.exists()) {
                System.out.println("Model file " + modelFilename + " could not be found - exiting!");
                return;
            }
            String newModelFilename = XMLProcessor.modelDocConverter(modelFilename);
            if (!newModelFilename.equalsIgnoreCase(modelFilename)) {
                info = "The model definition in \"" + modelFilename + "\" has been adapted in order to meet modifications of the JAMS model DTD.\nThe new definition has been stored in \"" + newModelFilename + "\" while your original file was left untouched.";
                modelFilename = newModelFilename;
            }
            String xmlString = JAMSTools.fileToString(modelFilename);
            String[] args = JAMSTools.toArray(cmdLineParameterValues, ";");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    xmlString = xmlString.replaceAll("%" + i, args[i]);
                }
            }
            try {
                Document modelDoc = XMLIO.getDocumentFromString(xmlString);
                StandardRuntime runtime = new StandardRuntime();
                runtime.loadModel(modelDoc, properties);
                if (!info.equals("")) {
                    runtime.println(info);
                }
                runtime.runModel();
            }
            catch (IOException ioe) {
                System.out.println("The model definition file " + modelFilename + " could not be loaded!");
            }
            catch (SAXException se) {
                System.out.println("The model definition file " + modelFilename + " contained errors!");
            }
        }
    }
}

