/*
 * Decompiled with CFR 0.152.
 */
package jams.components.optimizer;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import jams.components.optimizer.SCE_Comparator;
import java.util.Arrays;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSEntityCollection;
import org.unijena.jams.data.JAMSInteger;
import org.unijena.jams.data.JAMSIntegerArray;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSContext;
import org.unijena.jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class SCEM_UA
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter identifiers to be sampled")
    public JAMSString parameterIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="List of parameter value bounaries corresponding to parameter identifiers")
    public JAMSString boundaries;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Number of samples to be taken")
    public JAMSInteger sampleCount;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="efficiency methods")
    public JAMSString effMethodNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="efficiency values")
    public JAMSDouble[] effValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximize efficiency?")
    public JAMSIntegerArray MaximizeEff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximize efficiency?")
    public JAMSInteger Population;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, update=JAMSVarDescription.UpdateType.RUN, description="maximize efficiency?")
    public JAMSInteger Complexes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="The current hru entity")
    public JAMSEntityCollection entities;
    JAMSDouble[] parameters;
    String[] parameterNames;
    String[] effNames;
    double[] lowBound;
    double[] upBound;
    int currentCount;
    Random generator;
    GenericDataWriter writer;
    int N;
    int M;
    int q;
    int s;
    int m;
    int L;
    double gamma;
    double ndraw;

    public void init() {
        String key;
        StringTokenizer tok = new StringTokenizer(this.parameterIDs.getValue(), ";");
        this.parameters = new JAMSDouble[tok.countTokens()];
        this.parameterNames = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.parameterNames[i] = key = tok.nextToken();
            this.parameters[i] = (JAMSDouble)this.getModel().getRuntime().getDataHandles().get(key);
            ++i;
        }
        this.entities = (JAMSEntityCollection)this.getModel().getRuntime().getDataHandles().get("hrus");
        tok = new StringTokenizer(this.boundaries.getValue(), ";");
        int n = tok.countTokens();
        this.lowBound = new double[n];
        this.upBound = new double[n];
        if (n != i) {
            this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
        }
        i = 0;
        while (tok.hasMoreTokens()) {
            key = tok.nextToken();
            key = key.substring(1, key.length() - 1);
            StringTokenizer boundTok = new StringTokenizer(key, ">");
            this.lowBound[i] = Double.parseDouble(boundTok.nextToken());
            this.upBound[i] = Double.parseDouble(boundTok.nextToken());
            if (this.upBound[i] <= this.lowBound[i]) {
                this.getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
            }
            ++i;
        }
        i = 0;
        tok = new StringTokenizer(this.effMethodNames.getValue(), ";");
        this.effNames = new String[tok.countTokens()];
        i = 0;
        while (tok.hasMoreTokens()) {
            this.effNames[i] = key = tok.nextToken();
            ++i;
        }
        this.M = this.effNames.length;
    }

    private double[] RandomSampler() {
        int paras = this.parameterNames.length;
        double[] sample = new double[paras];
        for (int i = 0; i < paras; ++i) {
            double d = this.generator.nextDouble();
            sample[i] = this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    private void resetValues() {
        this.generator = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.parameters.length; ++i) {
            double d = this.generator.nextDouble();
            this.parameters[i].setValue(this.lowBound[i] + d * (this.upBound[i] - this.lowBound[i]));
        }
        this.currentCount = 0;
    }

    private void singleRun() {
        JAMSComponent comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.init();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private boolean IsSampleValid(JAMSDouble[] sample) {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0.0;
        for (int i = 0; i < paras; ++i) {
            if (!(sample[i].getValue() < this.lowBound[i]) && !(sample[i].getValue() > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public void sort(double[][] data, int col, boolean decreasing_order) {
        SCE_Comparator comparator = new SCE_Comparator(col, decreasing_order);
        Arrays.sort(data, comparator);
    }

    public double[] getMean(double[][] data) {
        double[] mean = new double[this.N];
        Arrays.fill(mean, 0.0);
        int j = 0;
        while (j < this.N) {
            for (int i = 0; i < data.length; ++i) {
                int n = j;
                mean[n] = mean[n] + data[i][j];
            }
            if (data.length == 0) {
                this.getModel().getRuntime().sendInfoMsg("Complex in SCEM_UA ist leer! - Kritischer Fehler!!");
            }
            int n = j++;
            mean[n] = mean[n] / (double)data.length;
        }
        return mean;
    }

    public double[][] getCoVarMatrix(double[][] data) {
        int i;
        double[][] coV = new double[this.N][this.N];
        double[] mean = this.getMean(data);
        double vecLength = data.length;
        if (data.length == 0) {
            this.getModel().getRuntime().sendInfoMsg("Complex in SCEM_UA hat nur die Gr\u00c3\u00b6\u00c3\u0178e von 1! - Kritischer Fehler!!");
        }
        for (i = 0; i < this.N; ++i) {
            Arrays.fill(coV[i], 0.0);
        }
        for (i = 0; i < this.N; ++i) {
            int j = 0;
            while (j < this.N) {
                int k = 0;
                while ((double)k < vecLength) {
                    double[] dArray = coV[i];
                    int n = j;
                    dArray[n] = dArray[n] + data[k][i] * data[k][j];
                    ++k;
                }
                double[] dArray = coV[i];
                int n = j;
                dArray[n] = dArray[n] - vecLength * mean[i] * mean[j];
                double[] dArray2 = coV[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / (vecLength - 1.0);
            }
        }
        return coV;
    }

    public double[][] latin(int s, int n) {
        double[][] x = new double[s][n];
        for (int i = 0; i < s; ++i) {
            x[i] = this.RandomSampler();
        }
        return x;
    }

    public double[] ComputeDensity(double[] x) {
        double[] pset = new double[this.N + this.M + 1];
        for (int j = 0; j < x.length; ++j) {
            this.parameters[j].setValue(x[j]);
            pset[j] = x[j];
        }
        this.singleRun();
        for (int i = 0; i < this.M; ++i) {
            pset[this.N + i] = this.MaximizeEff.getValue()[i] == 1 ? this.effValues[i].getValue() : (this.MaximizeEff.getValue()[i] == 2 ? Math.abs(this.effValues[i].getValue()) : (this.MaximizeEff.getValue()[i] == 3 ? -Math.abs(this.effValues[i].getValue()) : -this.effValues[i].getValue()));
        }
        return pset;
    }

    public double[][] ComputeDensity(double[][] x) {
        boolean e = false;
        double[][] pset = new double[x.length][this.N + this.M + 1];
        for (int i = 0; i < x.length; ++i) {
            double[] tmp = this.ComputeDensity(x[i]);
            for (int j = 0; j < this.N + this.M + 1; ++j) {
                pset[i][j] = tmp[j];
            }
        }
        return pset;
    }

    public double[][][] PartComplexes(double[][] D) {
        double[][][] C = new double[this.q][this.m][this.N + this.M + 1];
        for (int kk = 0; kk < this.q; ++kk) {
            for (int j = 0; j < this.m; ++j) {
                int idx = this.q * j + kk;
                for (int i = 0; i < this.N + this.M + 1; ++i) {
                    C[kk][j][i] = D[idx][i];
                }
            }
        }
        return C;
    }

    public void SEM(double[][] D, double[][][] C, Vector<Vector<double[]>> Sequences, double[][] x) {
        for (int kk = 0; kk < this.q; ++kk) {
            for (int bb = 0; bb < this.L; ++bb) {
                this.OffMetro(Sequences.get(kk), C[kk], kk, bb);
            }
        }
    }

    public double[] randn(int n) {
        double[] randn = new double[n];
        for (int i = 0; i < n; ++i) {
            randn[i] = this.generator.nextGaussian();
        }
        return randn;
    }

    public void OffMetro(Vector<double[]> Seq, double[][] C, int kk, int bb) {
        int j;
        double[] newgen;
        int s = Seq.size();
        double[] offspring = null;
        s = this.generator.nextInt(s);
        double[] b = Seq.get(s);
        double[][] coV = this.getCoVarMatrix(C);
        double[] mean = this.getMean(C);
        Matrix MatrixCoV = new Matrix(coV);
        CholeskyDecomposition sqrtCoV = new CholeskyDecomposition(MatrixCoV);
        JAMSDouble[] tmpArray = new JAMSDouble[this.N];
        int critical_counter = 0;
        do {
            int i;
            if (critical_counter++ > 100) {
                return;
            }
            Matrix ru = new Matrix(this.randn(this.N), this.N);
            offspring = sqrtCoV.getL().times(ru).getColumnPackedCopy();
            for (i = 0; i < this.N; ++i) {
                int n = i;
                offspring[n] = offspring[n] + b[i];
                if (!Double.isNaN(offspring[i])) continue;
                System.out.println("Fehler -> Parameter ist NaN!!");
            }
            for (i = 0; i < this.N; ++i) {
                tmpArray[i] = new JAMSDouble(offspring[i]);
            }
        } while (!this.IsSampleValid(tmpArray));
        (newgen = this.ComputeDensity((double[])offspring))[this.M + this.N] = this.IsPointNonDominated(C, newgen);
        if ((newgen = this.ComputeDensity((double[])offspring))[this.M + this.N] != -1.0) {
            int n = this.M + this.N;
            newgen[n] = newgen[n] / (double)C.length;
        } else {
            newgen[this.M + this.N] = this.ComputeFitnessOfDominatedPoint(C, newgen);
        }
        double fitness1 = b[this.N + this.M];
        double fitness2 = newgen[this.N + this.M];
        double ratio = fitness1 / fitness2;
        ratio = Math.pow(ratio, 0.5 * fitness2);
        double Z = this.generator.nextDouble();
        System.out.println("newgen:");
        for (j = 0; j < this.N; ++j) {
            System.out.print(this.parameterNames[j] + ":" + newgen[j] + " ,");
        }
        for (j = 0; j < this.M; ++j) {
            System.out.print(this.effNames[j] + ":" + newgen[this.N + j] + " ,");
        }
        System.out.println("Fitness:" + newgen[this.N + this.M]);
        if (Z < ratio) {
            Seq.add(newgen);
            for (int i = 0; i < this.N + this.M + 1; ++i) {
                C[this.m - 1][i] = newgen[i];
            }
        }
    }

    public void reshuffle(double[][][] C, double[][] D) {
        int counter = 0;
        for (int qq = 0; qq < this.q; ++qq) {
            for (int ii = 0; ii < this.m; ++ii) {
                for (int j = 0; j < this.N + this.M + 1; ++j) {
                    D[counter][j] = C[qq][ii][j];
                }
                ++counter;
            }
        }
        this.ComputeFitness(D);
        this.sort(D, this.N + this.M, false);
        System.out.println("Current D:");
        for (int i = 0; i < D.length; ++i) {
            int j;
            for (j = 0; j < this.N; ++j) {
                System.out.print(this.parameterNames[j] + ":" + D[i][j] + " ,");
            }
            for (j = 0; j < this.M; ++j) {
                if (this.MaximizeEff.getValue()[j] % 2 == 1) {
                    System.out.print(this.effNames[j] + ":" + D[i][this.N + j] + " ,");
                    continue;
                }
                double outdata = -D[i][this.N + j];
                System.out.print(this.effNames[j] + ":" + outdata + " ,");
            }
            System.out.println("Fitness:" + D[i][this.N + this.M]);
        }
    }

    public double ComputeFitnessOfDominatedPoint(double[][] D, double[] Point2) {
        Point2[this.M + this.N] = 1.00001;
        for (int j = 0; j < D.length; ++j) {
            if (D[j] == Point2 || D[j][this.M + this.N] > 1.0 || D[j][this.M + this.N] == -1.0) continue;
            boolean j_DominatesPoint = true;
            for (int k = this.N; k < this.N + this.M; ++k) {
                if (!(Point2[k] > D[j][k])) continue;
                j_DominatesPoint = false;
            }
            if (!j_DominatesPoint) continue;
            int n = this.M + this.N;
            Point2[n] = Point2[n] + D[j][this.M + this.N];
        }
        return Point2[this.M + this.N];
    }

    public int IsPointNonDominated(double[][] D, double[] Point2) {
        int domCount = 0;
        boolean PointIsDominated = false;
        for (int j = 0; j < D.length; ++j) {
            if (D[j] == Point2) continue;
            boolean j_DominatesPoint = true;
            boolean PointDominates_j = true;
            for (int k = this.N; k < this.N + this.M; ++k) {
                if (Point2[k] > D[j][k]) {
                    j_DominatesPoint = false;
                }
                if (!(Point2[k] < D[j][k])) continue;
                PointDominates_j = false;
            }
            if (j_DominatesPoint) {
                PointIsDominated = true;
                break;
            }
            if (!PointDominates_j) continue;
            ++domCount;
        }
        if (PointIsDominated) {
            return -1;
        }
        return domCount;
    }

    public void ComputeFitness(double[][] D) {
        int i;
        for (i = 0; i < D.length; ++i) {
            D[i][this.M + this.N] = -1.0;
        }
        for (i = 0; i < D.length; ++i) {
            int numOfDominatedPoints = this.IsPointNonDominated(D, D[i]);
            if (numOfDominatedPoints == -1) continue;
            D[i][this.M + this.N] = (double)numOfDominatedPoints / (double)D.length;
        }
        for (i = 0; i < D.length; ++i) {
            if (D[i][this.M + this.N] != -1.0) continue;
            D[i][this.M + this.N] = this.ComputeFitnessOfDominatedPoint(D, D[i]);
        }
        for (i = 0; i < D.length; ++i) {
            if (D[i][this.M + this.N] != -1.0) continue;
            D[i][this.M + this.N] = 1.0;
        }
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        this.resetValues();
        this.N = this.parameters.length;
        this.q = this.Complexes.getValue();
        this.s = this.Population.getValue();
        this.s = this.s / this.q * this.q;
        this.m = this.s / this.q;
        this.L = Math.max(1, this.m / 5);
        double[][] D = new double[this.s][this.N + this.M + 1];
        Vector<Vector<double[]>> Sequences = new Vector<Vector<double[]>>();
        double[][] x = new double[this.s][this.N];
        x = this.latin(this.s, this.N);
        D = this.ComputeDensity(x);
        this.ComputeFitness(D);
        this.sort(D, this.M + this.N, false);
        for (int i = 0; i < this.q; ++i) {
            Vector<double[]> Sequence_k = new Vector<double[]>();
            double[] extX = new double[this.N + this.M + 1];
            for (int j = 0; j < this.N + this.M + 1; ++j) {
                extX[j] = D[i][j];
            }
            Sequence_k.add(extX);
            Sequences.add(Sequence_k);
        }
        int converged = -1;
        int convergence = 2;
        for (int iter = 0; iter < this.sampleCount.getValue(); ++iter) {
            double[][][] C = this.PartComplexes(D);
            this.SEM(D, C, Sequences, x);
            this.reshuffle(C, D);
        }
    }
}

