/*
 * Decompiled with CFR 0.152.
 */
package jams.components.io;

import org.unijena.jams.data.JAMSDouble;
import org.unijena.jams.data.JAMSString;
import org.unijena.jams.data.JAMSStringArray;
import org.unijena.jams.io.GenericDataWriter;
import org.unijena.jams.model.JAMSComponent;
import org.unijena.jams.model.JAMSComponentDescription;
import org.unijena.jams.model.JAMSVarDescription;
import org.unijena.jams.runtime.RuntimeException;

@JAMSComponentDescription(title="Entity file writer (spatial)", author="S. Kralisch", description="This component can be used to output a number of selected entity attribute values at a certain point in time. The resulting CSV formatted ASCII file will contain one line per entity and one column per attribute. This component must be wrapped in a spatial, but not in a temporal context!")
public class EntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Data file directory name")
    public JAMSString dirName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file name")
    public JAMSString fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.INIT, description="Output file header descriptions")
    public JAMSStringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, update=JAMSVarDescription.UpdateType.RUN, description="Output file attributes")
    public JAMSDouble[] value;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.dirName.getValue() + "/" + this.fileName.getValue());
        this.writer.addComment("Entity attribute values");
        this.writer.addComment("");
        for (int i = 0; i < this.headers.getValue().length; ++i) {
            this.writer.addColumn(this.headers.getValue()[i]);
        }
        this.writer.writeHeader();
    }

    public void run() {
        for (int i = 0; i < this.value.length; ++i) {
            this.writer.addData((Object)this.value[i]);
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().println(jre.getMessage());
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

