/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet.kernels;

import Jama.Matrix;
import org.unijena.predictionnet.kernels.MeanModell;

public class FixedMeanModell
extends MeanModell {
    double average;

    public FixedMeanModell(int inputSize) {
        this.inputSize = inputSize;
        this.parameterCount = 0;
        this.beta = null;
    }

    @Override
    public Matrix Transform(double[][] data, double[] result) {
        int i;
        double sum = 0.0;
        this.average = 0.0;
        Matrix transformed = new Matrix(result.length, 1);
        for (i = 0; i < data.length; ++i) {
            this.average += result[i];
        }
        this.average /= (double)data.length;
        for (i = 0; i < data.length; ++i) {
            transformed.set(i, 0, result[i] - this.average);
        }
        return transformed;
    }

    @Override
    public double[] ReTransform(double[][] data, Matrix prediction) {
        double sum = 0.0;
        double[] transformed = new double[prediction.getRowDimension()];
        for (int i = 0; i < data.length; ++i) {
            transformed[i] = prediction.get(i, 0) + this.average;
        }
        return transformed;
    }
}

