/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.predictionnet;

import org.unijena.predictionnet.ActivationFunction;
import org.unijena.predictionnet.Matrix;
import org.unijena.predictionnet.Regression;

public class Exponential
implements ActivationFunction {
    double a;
    double b;

    public Exponential(Matrix M) {
        try {
            double[] params = this.getParams(M);
            this.a = params[0];
            this.b = params[1];
        }
        catch (Exception e) {
            this.a = 0.0;
            this.b = 0.0;
        }
    }

    public Exponential() {
        this(1.0, 1.0);
    }

    public Exponential(double a, double b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public double calculate(double x) {
        return this.a * Math.pow(Math.E, this.b * x);
    }

    @Override
    public ActivationFunction derive() {
        double aNew = this.a * this.b * (Math.log(this.a) / Math.log(Math.E) + 1.0);
        return new Exponential(aNew, this.b);
    }

    @Override
    public String getDescription() {
        return this.a + " - " + this.b;
    }

    @Override
    public double[] getParams() {
        double[] params = new double[]{this.a, this.b};
        return params;
    }

    @Override
    public int getType() {
        return 2;
    }

    private double[] getParams(Matrix D) throws Exception {
        return Regression.getExpoParams(D);
    }
}

