/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import org.geotools.data.DataStore;
import org.geotools.data.Diff;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileRendererUtil;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.geometry.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.index.quadtree.StoreException;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.Decimator;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheDefault;
import org.geotools.renderer.lite.ListenerList;
import org.geotools.renderer.lite.LiteCoordinateSequence;
import org.geotools.renderer.lite.LiteCoordinateSequenceFactory;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.shape.IndexInfo;
import org.geotools.renderer.shape.MultiLineShape;
import org.geotools.renderer.shape.MultiPointShape;
import org.geotools.renderer.shape.OpacityFinder;
import org.geotools.renderer.shape.PolygonShape;
import org.geotools.renderer.shape.SimpleGeometry;
import org.geotools.renderer.shape.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatorStyleVisitor;
import org.geotools.util.NumberRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ShapefileRenderer
implements GTRenderer {
    public static final Logger LOGGER = Logger.getLogger("org.geotools.renderer.shape");
    private static final double TOLERANCE = 1.0E-6;
    private static final GeometryFactory geomFactory = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private static final IndexInfo STREAMING_RENDERER_INFO = new IndexInfo(0, null, null);
    private static final MultiPolygon MULTI_POLYGON_GEOM;
    private static final Polygon POLYGON_GEOM;
    private static final LinearRing LINE_GEOM;
    private static final MultiLineString MULTI_LINE_GEOM;
    private static final Point POINT_GEOM;
    private static final MultiPoint MULTI_POINT_GEOM;
    private static final Coordinate[] COORDS;
    public static final DefaultRenderListener DEFAULT_LISTENER;
    static int NUM_SAMPLES;
    private RenderingHints hints;
    private SLDStyleFactory styleFactory = new SLDStyleFactory();
    private boolean renderingStopRequested;
    private boolean concatTransforms;
    private MapContext context;
    LabelCache labelCache = new LabelCacheDefault();
    private ListenerList renderListeners = new ListenerList();
    List geometryCache = new LinkedList();
    List featureCache = new LinkedList();
    boolean caching = false;
    private double scaleDenominator;
    DbaseFileHeader dbfheader;
    private Object defaultGeom;
    IndexInfo[] layerIndexInfo;
    int[] attributeIndexing;
    private StyledShapePainter painter = new StyledShapePainter(this.labelCache);
    private Map decimators = new HashMap();
    private Map rendererHints;
    private Graphics2D outputGraphics;

    public ShapefileRenderer(MapContext context) {
        this.setContext(context);
    }

    public ShapefileRenderer() {
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope extent) {
        this.paint(graphics, paintArea, RendererUtilities.worldToScreenTransform((ReferencedEnvelope)extent, (Rectangle)paintArea));
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, ReferencedEnvelope extent, AffineTransform worldToScreenTransform) {
        try {
            this.paint(graphics, paintArea, extent.transform(this.context.getCoordinateReferenceSystem(), true), worldToScreenTransform);
        }
        catch (Exception e) {
            LOGGER.severe("unable to extent to MapContext CRS! From=" + extent.getCoordinateReferenceSystem() + " To=" + this.context.getCoordinateReferenceSystem());
            this.paint(graphics, paintArea, extent, worldToScreenTransform);
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope mapArea) {
        if (mapArea == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.paint(graphics, paintArea, mapArea, RendererUtilities.worldToScreenTransform((Envelope)mapArea, (Rectangle)paintArea));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DbaseFileHeader getDBFHeader(ShapefileDataStore ds) {
        IndexedDbaseFileReader reader = null;
        reader = ShapefileRendererUtil.getDBFReader(ds);
        DbaseFileHeader dbaseFileHeader = reader.getHeader();
        Object var5_5 = null;
        if (reader == null) return dbaseFileHeader;
        try {
            reader.close();
            return dbaseFileHeader;
        }
        catch (IOException e2) {
            if (!LOGGER.isLoggable(Level.SEVERE)) return dbaseFileHeader;
            LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
        }
        return dbaseFileHeader;
        catch (IOException e) {
            try {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                Object var5_6 = null;
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) throw throwable;
                    LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                }
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException e2) {
                if (!LOGGER.isLoggable(Level.SEVERE)) return null;
                LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
            }
            return null;
        }
    }

    private void processStylersNoCaching(Graphics2D graphics, ShapefileDataStore datastore, Query query, Envelope bbox, Rectangle screenSize, MathTransform mt, Style style, IndexInfo info, Transaction transaction) throws IOException {
        FeatureType type;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("processing " + style.getFeatureTypeStyles().length + " stylers");
        }
        FeatureTypeStyle[] featureStylers = style.getFeatureTypeStyles();
        try {
            type = this.createFeatureType(query, style, datastore.getSchema());
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            return;
        }
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        ArrayList<Rule> elseRuleList = new ArrayList<Rule>();
        int length = featureStylers.length;
        NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
        for (int i = 0; i < length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("processing style " + i);
            }
            FeatureTypeStyle fts = featureStylers[i];
            String typeName = datastore.getSchema().getTypeName();
            if (typeName == null || !datastore.getSchema().isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
            Rule[] rules = fts.getRules();
            ruleList.clear();
            elseRuleList.clear();
            int numRules = rules.length;
            for (int j = 0; j < numRules; ++j) {
                Rule r;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("processing rule " + j);
                }
                if (!this.isWithInScale(r = rules[j])) continue;
                if (r.hasElseFilter()) {
                    elseRuleList.add(r);
                    continue;
                }
                ruleList.add(r);
            }
            Set modifiedFIDs = this.processTransaction(graphics, bbox, mt, (DataStore)datastore, transaction, typeName, query, ruleList, elseRuleList, scaleRange);
            this.processShapefile(graphics, datastore, bbox, screenSize, mt, info, type, query, ruleList, elseRuleList, modifiedFIDs, scaleRange);
        }
    }

    private Set processTransaction(Graphics2D graphics, Envelope bbox, MathTransform transform, DataStore ds, Transaction transaction, String typename, Query query, List ruleList, List elseRuleList, NumberRange scaleRange) {
        if (transaction == Transaction.AUTO_COMMIT) {
            return Collections.EMPTY_SET;
        }
        TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)ds);
        if (state == null) {
            return Collections.EMPTY_SET;
        }
        Set<String> fids = new HashSet();
        Map modified = null;
        Map added = null;
        Diff diff = null;
        try {
            diff = state.diff(typename);
            modified = diff.modified2;
            added = diff.added;
            fids = new HashSet();
        }
        catch (IOException e) {
            fids = Collections.EMPTY_SET;
            return fids;
        }
        if (!diff.isEmpty()) {
            boolean doElse = true;
            Iterator modifiedIter = modified.keySet().iterator();
            Iterator addedIter = added.values().iterator();
            while ((modifiedIter.hasNext() || addedIter.hasNext()) && !this.renderingStopRequested) {
                Symbolizer[] symbolizers;
                Rule r;
                Feature feature;
                doElse = true;
                if (modifiedIter.hasNext()) {
                    String fid = (String)modifiedIter.next();
                    feature = (Feature)modified.get(fid);
                    fids.add(fid);
                } else {
                    feature = (Feature)addedIter.next();
                }
                if (!query.getFilter().contains(feature) || feature == TransactionStateDiff.NULL) continue;
                Iterator it = ruleList.iterator();
                while (it.hasNext()) {
                    Filter filter;
                    r = (Rule)it.next();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("applying rule: " + r.toString());
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("this rule applies ...");
                    }
                    if ((filter = r.getFilter()) != null && !filter.contains(feature)) continue;
                    doElse = false;
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("processing Symobolizer ...");
                    }
                    symbolizers = r.getSymbolizers();
                    try {
                        this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, transform);
                    }
                    catch (Exception e) {
                        this.fireErrorEvent(e);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.finer("... done!");
                }
                if (doElse) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("rules with an else filter");
                    }
                    it = elseRuleList.iterator();
                    while (it.hasNext()) {
                        r = (Rule)it.next();
                        symbolizers = r.getSymbolizers();
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("processing Symobolizer ...");
                        }
                        try {
                            this.processSymbolizers(graphics, feature, symbolizers, (Range)scaleRange, transform);
                        }
                        catch (Exception e) {
                            this.fireErrorEvent(e);
                            continue;
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("... done!");
                    }
                }
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer("feature rendered event ...");
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processShapefile(Graphics2D graphics, ShapefileDataStore datastore, Envelope bbox, Rectangle screenSize, MathTransform mt, IndexInfo info, FeatureType type, Query query, List ruleList, List elseRuleList, Set modifiedFIDs, NumberRange scaleRange) throws IOException {
        IndexedDbaseFileReader dbfreader = null;
        try {
            dbfreader = ShapefileRendererUtil.getDBFReader(datastore);
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
        }
        OpacityFinder opacityFinder = new OpacityFinder(this.getAcceptableSymbolizers(type.getDefaultGeometry()));
        Iterator iter = ruleList.iterator();
        while (iter.hasNext()) {
            Rule rule = (Rule)iter.next();
            rule.accept((StyleVisitor)opacityFinder);
        }
        IndexInfo.Reader shpreader = null;
        try {
            shpreader = new IndexInfo.Reader(info, ShapefileRendererUtil.getShpReader(datastore, bbox, screenSize, mt, opacityFinder.hasOpacity), bbox);
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            return;
        }
        FIDReader fidReader = null;
        try {
            fidReader = ShapefileRendererUtil.getFidReader(datastore, shpreader);
        }
        catch (Exception e) {
            this.fireErrorEvent(e);
            return;
        }
        try {
            block23: while (true) {
                try {
                    while (!this.renderingStopRequested && shpreader.hasNext()) {
                        Symbolizer[] symbolizers;
                        Rule r;
                        ShapefileReader.Record record;
                        SimpleGeometry geom;
                        String nextFid;
                        boolean doElse = true;
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.fine("trying to read geometry ...");
                        }
                        if (modifiedFIDs.contains(nextFid = fidReader.next())) {
                            shpreader.next();
                            if (dbfreader.IsRandomAccessEnabled()) continue;
                            dbfreader.skip();
                            continue;
                        }
                        if (dbfreader.IsRandomAccessEnabled()) {
                            dbfreader.goTo(shpreader.getRecordNumber());
                        }
                        if ((geom = (SimpleGeometry)(record = shpreader.next()).shape()) == null) {
                            LOGGER.finest("skipping geometry");
                            if (dbfreader.IsRandomAccessEnabled()) continue;
                            dbfreader.skip();
                            continue;
                        }
                        Feature feature = this.createFeature(type, record, (DbaseFileReader)dbfreader, nextFid);
                        if (!query.getFilter().contains(feature)) continue;
                        if (this.renderingStopRequested) break block23;
                        if (this.caching) {
                            this.geometryCache.add(geom);
                            this.featureCache.add(feature);
                        }
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("... done: " + geom.toString());
                        }
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.fine("... done: " + type.getTypeName());
                        }
                        Iterator it = ruleList.iterator();
                        while (it.hasNext()) {
                            Filter filter;
                            r = (Rule)it.next();
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("applying rule: " + r.toString());
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("this rule applies ...");
                            }
                            if ((filter = r.getFilter()) != null && !filter.contains(feature)) continue;
                            doElse = false;
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("processing Symobolizer ...");
                            }
                            symbolizers = r.getSymbolizers();
                            this.processSymbolizers(graphics, feature, geom, symbolizers, scaleRange);
                            if (!LOGGER.isLoggable(Level.FINER)) continue;
                            LOGGER.finer("... done!");
                        }
                        if (doElse) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("rules with an else filter");
                            }
                            it = elseRuleList.iterator();
                            while (it.hasNext()) {
                                r = (Rule)it.next();
                                symbolizers = r.getSymbolizers();
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("processing Symobolizer ...");
                                }
                                this.processSymbolizers(graphics, feature, geom, symbolizers, scaleRange);
                                if (!LOGGER.isLoggable(Level.FINER)) continue;
                                LOGGER.finer("... done!");
                            }
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("feature rendered event ...");
                    }
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                    continue;
                }
                break;
            }
            Object var27_30 = null;
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            try {
                if (dbfreader != null) {
                    dbfreader.close();
                }
                Object var29_34 = null;
            }
            catch (Throwable throwable2) {
                Object var29_35 = null;
                try {
                    if (shpreader == null) throw throwable2;
                    shpreader.close();
                    throw throwable2;
                }
                finally {
                    if (fidReader == null) {
                        fidReader.close();
                    }
                }
            }
            try {
                if (shpreader == null) throw throwable;
                shpreader.close();
                throw throwable;
            }
            finally {
                if (fidReader == null) {
                    fidReader.close();
                }
            }
        }
        try {
            if (dbfreader != null) {
                dbfreader.close();
            }
            Object var29_32 = null;
        }
        catch (Throwable throwable) {
            Object var29_33 = null;
            try {
                if (shpreader == null) throw throwable;
                shpreader.close();
                throw throwable;
            }
            finally {
                if (fidReader == null) {
                    fidReader.close();
                }
            }
        }
        try {
            if (shpreader == null) return;
            shpreader.close();
            return;
        }
        finally {
            if (fidReader == null) {
                fidReader.close();
            }
        }
    }

    private Class[] getAcceptableSymbolizers(GeometryAttributeType defaultGeometry) {
        if (Polygon.class.isAssignableFrom(defaultGeometry.getType()) || MultiPolygon.class.isAssignableFrom(defaultGeometry.getType())) {
            return new Class[]{PointSymbolizer.class, LineSymbolizer.class, PolygonSymbolizer.class};
        }
        return new Class[]{PointSymbolizer.class, LineSymbolizer.class};
    }

    Feature createFeature(FeatureType type, ShapefileReader.Record record, DbaseFileReader dbfreader, String id) throws Exception {
        if (type.getAttributeCount() == 1) {
            return type.create(new Object[1], id);
        }
        DbaseFileHeader header = dbfreader.getHeader();
        Object[] all = dbfreader.readEntry();
        Object[] values = new Object[type.getAttributeCount()];
        int length = values.length;
        for (int i = 0; i < length - 1; ++i) {
            values[i] = all[this.attributeIndexing[i]];
            if (!header.getFieldName(this.attributeIndexing[i]).equals(type.getAttributeType(i))) continue;
            System.out.println("ok");
        }
        values[length - 1] = this.getGeom(type.getDefaultGeometry());
        return type.create(values, id);
    }

    private Object getGeom(GeometryAttributeType defaultGeometry) {
        if (this.defaultGeom == null) {
            if (MultiPolygon.class.isAssignableFrom(defaultGeometry.getType())) {
                this.defaultGeom = MULTI_POLYGON_GEOM;
            } else if (MultiLineString.class.isAssignableFrom(defaultGeometry.getType())) {
                this.defaultGeom = MULTI_LINE_GEOM;
            } else if (Point.class.isAssignableFrom(defaultGeometry.getType())) {
                this.defaultGeom = POINT_GEOM;
            } else if (MultiPoint.class.isAssignableFrom(defaultGeometry.getType())) {
                this.defaultGeom = MULTI_POINT_GEOM;
            }
        }
        return this.defaultGeom;
    }

    FeatureType createFeatureType(Query query, Style style, FeatureType schema) throws SchemaException {
        String[] attributes = this.findStyleAttributes(query == null ? Query.ALL : query, style, schema);
        int length = attributes.length;
        AttributeType[] types = new AttributeType[length];
        this.attributeIndexing = new int[length];
        int numFields = this.dbfheader.getNumFields();
        block0: for (int i = 0; i < length; ++i) {
            types[i] = schema.getAttributeType(attributes[i]);
            for (int j = 0; j < numFields; ++j) {
                if (!this.dbfheader.getFieldName(j).equals(attributes[i])) continue;
                this.attributeIndexing[i] = j;
                continue block0;
            }
        }
        FeatureType type = FeatureTypeBuilder.newFeatureType((AttributeType[])types, (String)schema.getTypeName(), (URI)schema.getNamespace(), (boolean)false, null, (GeometryAttributeType)schema.getDefaultGeometry());
        return type;
    }

    private String[] findStyleAttributes(Query query, Style style, FeatureType schema) {
        StyleAttributeExtractor sae = new StyleAttributeExtractor(){

            public void visit(Rule rule) {
                DuplicatorStyleVisitor dupeStyleVisitor = new DuplicatorStyleVisitor(StyleFactoryFinder.createStyleFactory(), FilterFactoryFinder.createFilterFactory());
                dupeStyleVisitor.visit(rule);
                Rule clone = (Rule)dupeStyleVisitor.getCopy();
                super.visit(clone);
            }
        };
        sae.visit(style);
        FilterAttributeExtractor qae = new FilterAttributeExtractor();
        query.getFilter().accept((FilterVisitor)qae);
        HashSet ftsAttributes = new HashSet(sae.getAttributeNameSet());
        ftsAttributes.addAll(qae.getAttributeNameSet());
        return ftsAttributes.toArray(new String[0]);
    }

    private void processSymbolizers(Graphics2D graphics, Feature feature, SimpleGeometry geom, Symbolizer[] symbolizers, NumberRange scaleRange) {
        for (int m = 0; m < symbolizers.length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            if (this.renderingStopRequested) break;
            if (symbolizers[m] instanceof TextSymbolizer) {
                try {
                    this.labelCache.put((TextSymbolizer)symbolizers[m], feature, this.getLiteShape2(geom), (Range)scaleRange);
                }
                catch (Exception e) {
                    this.fireErrorEvent(e);
                }
            } else {
                Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], (Range)scaleRange);
                this.painter.paint(graphics, this.getShape(geom), style, this.scaleDenominator);
            }
            this.fireFeatureRenderedEvent(feature);
        }
    }

    private void processSymbolizers(Graphics2D graphics, Feature feature, Symbolizer[] symbolizers, Range scaleRange, MathTransform transform) throws TransformException, FactoryException {
        int length = symbolizers.length;
        for (int m = 0; m < length; ++m) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying symbolizer " + symbolizers[m]);
            }
            Geometry g = feature.getDefaultGeometry();
            LiteShape2 shape = new LiteShape2(g, transform, this.getDecimator(transform), false);
            if (symbolizers[m] instanceof TextSymbolizer) {
                this.labelCache.put((TextSymbolizer)symbolizers[m], feature, shape, scaleRange);
                continue;
            }
            Style2D style = this.styleFactory.createStyle(feature, symbolizers[m], scaleRange);
            this.painter.paint(graphics, (Shape)shape, style, this.scaleDenominator);
        }
        this.fireFeatureRenderedEvent(feature);
    }

    private Decimator getDecimator(MathTransform mathTransform) throws org.opengis.referencing.operation.NoninvertibleTransformException {
        Decimator decimator = (Decimator)this.decimators.get(mathTransform);
        if (decimator == null) {
            decimator = mathTransform != null && !mathTransform.isIdentity() ? new Decimator(mathTransform.inverse()) : new Decimator(null);
            this.decimators.put(mathTransform, decimator);
        }
        return decimator;
    }

    LiteShape2 getLiteShape2(SimpleGeometry geom) throws TransformException, FactoryException {
        MultiPolygon jtsGeom;
        double[] points;
        if (geom.type == ShapeType.POLYGON || geom.type == ShapeType.POLYGONM || geom.type == ShapeType.POLYGONZ) {
            Polygon poly;
            points = this.getPointSample(geom, true);
            LiteCoordinateSequence seq = new LiteCoordinateSequence(points);
            try {
                poly = geomFactory.createPolygon(geomFactory.createLinearRing((CoordinateSequence)seq), new LinearRing[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            jtsGeom = geomFactory.createMultiPolygon(new Polygon[]{poly});
        } else if (geom.type == ShapeType.ARC || geom.type == ShapeType.ARCM || geom.type == ShapeType.ARCZ) {
            points = this.getPointSample(geom, false);
            LiteCoordinateSequence seq = new LiteCoordinateSequence(points);
            jtsGeom = geomFactory.createMultiLineString(new LineString[]{geomFactory.createLineString((CoordinateSequence)seq)});
        } else if (geom.type == ShapeType.MULTIPOINT || geom.type == ShapeType.MULTIPOINTM || geom.type == ShapeType.MULTIPOINTZ) {
            points = this.getPointSample(geom, false);
            LiteCoordinateSequence seq = new LiteCoordinateSequence(points);
            jtsGeom = geomFactory.createMultiPoint((CoordinateSequence)seq);
        } else {
            jtsGeom = geomFactory.createPoint(new Coordinate(geom.coords[0][0], geom.coords[0][1]));
        }
        LiteShape2 shape = new LiteShape2((Geometry)jtsGeom, null, null, false);
        return shape;
    }

    private double[] getPointSample(SimpleGeometry geom, boolean isPolygon) {
        int largestPart = 0;
        double[][] coords = geom.coords;
        int length = coords.length;
        for (int i = 0; i < length; ++i) {
            if (coords[i].length <= coords[largestPart].length) continue;
            largestPart = i;
        }
        return coords[largestPart];
    }

    private Shape getShape(SimpleGeometry geom) {
        if (geom.type == ShapeType.ARC || geom.type == ShapeType.ARCM || geom.type == ShapeType.ARCZ) {
            return new MultiLineShape(geom);
        }
        if (geom.type == ShapeType.POLYGON || geom.type == ShapeType.POLYGONM || geom.type == ShapeType.POLYGONZ) {
            return new PolygonShape(geom);
        }
        if (geom.type == ShapeType.POINT || geom.type == ShapeType.POINTM || geom.type == ShapeType.POINTZ || geom.type == ShapeType.MULTIPOINT || geom.type == ShapeType.MULTIPOINTM || geom.type == ShapeType.MULTIPOINTZ) {
            return new MultiPointShape(geom);
        }
        return null;
    }

    private boolean isWithInScale(Rule r) {
        return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
    }

    public void addRenderListener(RenderListener listener) {
        this.renderListeners.add((Object)listener);
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListeners.remove((Object)listener);
    }

    private void fireFeatureRenderedEvent(Feature feature) {
        Object[] objects = this.renderListeners.getListeners();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.featureRenderer(feature);
        }
    }

    private void fireErrorEvent(Exception e) {
        Object[] objects = this.renderListeners.getListeners();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RenderListener listener = (RenderListener)objects[i];
            listener.errorOccurred(e);
        }
    }

    protected void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public void stopRendering() {
        this.renderingStopRequested = true;
        this.labelCache.stop();
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public MapContext getContext() {
        return this.context;
    }

    public boolean isConcatTransforms() {
        return this.concatTransforms;
    }

    public void setConcatTransforms(boolean concatTransforms) {
        this.concatTransforms = concatTransforms;
    }

    public IndexInfo useIndex(ShapefileDataStore ds) throws IOException, StoreException {
        IndexInfo info;
        String filename = null;
        URL url = ShapefileRendererUtil.getshpURL(ds);
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.toString(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        filename = filename.substring(0, filename.length() - 4);
        String grxext = ".grx";
        String qixext = ".qix";
        if (ds.isLocal()) {
            File grxTree = new File(new URL(filename + grxext).getPath());
            File qixTree = new File(new URL(filename + qixext).getPath());
            URL shx = new URL(filename + ".shx");
            if (!new File(shx.getPath()).exists()) {
                info = new IndexInfo(0, null, null);
            } else if (!grxTree.exists() && qixTree.exists()) {
                info = new IndexInfo(2, new URL(filename + qixext), shx);
                LOGGER.fine("Using quad tree");
            } else if (grxTree.exists()) {
                info = new IndexInfo(1, new URL(filename + grxext), shx);
                LOGGER.fine("Using r-tree");
            } else {
                info = new IndexInfo(0, null, null);
                LOGGER.fine("No indexing");
            }
        } else {
            info = new IndexInfo(0, null, null);
        }
        return info;
    }

    public void setJava2DHints(RenderingHints hints) {
        this.hints = hints;
    }

    public RenderingHints getJava2DHints() {
        return this.hints;
    }

    public void setRendererHints(Map hints) {
        this.rendererHints = hints;
    }

    public Map getRendererHints() {
        return this.rendererHints;
    }

    public void setContext(MapContext context) {
        if (context == null) {
            context = new DefaultMapContext();
        }
        this.context = context;
        MapLayer[] layers = context.getLayers();
        this.layerIndexInfo = new IndexInfo[layers.length];
        int length = layers.length;
        for (int i = 0; i < length; ++i) {
            DataStore ds = layers[i].getFeatureSource().getDataStore();
            if (ds instanceof ShapefileDataStore) {
                ShapefileDataStore sds = (ShapefileDataStore)ds;
                try {
                    this.layerIndexInfo[i] = this.useIndex(sds);
                }
                catch (Exception e) {
                    this.layerIndexInfo[i] = new IndexInfo(0, null, null);
                    LOGGER.fine("Exception while trying to use index" + e.getLocalizedMessage());
                }
                continue;
            }
            this.layerIndexInfo[i] = STREAMING_RENDERER_INFO;
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, AffineTransform worldToScreen) {
        if (worldToScreen == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        try {
            Envelope mapArea = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)worldToScreen);
            this.paint(graphics, paintArea, mapArea, worldToScreen);
        }
        catch (NoninvertibleTransformException e) {
            this.fireErrorEvent(new Exception("Can't create pixel to world transform", e));
        }
    }

    public void paint(Graphics2D graphics, Rectangle paintArea, Envelope envelope, AffineTransform transform) {
        if (this.hints != null) {
            graphics.setRenderingHints(this.hints);
        }
        if (graphics == null || paintArea == null) {
            LOGGER.info("renderer passed null arguments");
            return;
        }
        this.renderingStopRequested = false;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Affine Transform is " + transform);
        }
        if (this.concatTransforms) {
            AffineTransform atg = graphics.getTransform();
            atg.concatenate(transform);
            transform = atg;
        }
        CoordinateReferenceSystem destinationCrs = this.context.getCoordinateReferenceSystem();
        ReferencedEnvelope mapExtent = new ReferencedEnvelope(envelope, destinationCrs);
        try {
            this.setScaleDenominator(RendererUtilities.calculateScale((ReferencedEnvelope)mapExtent, (int)paintArea.width, (int)paintArea.height, (Map)this.rendererHints));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            this.setScaleDenominator(1.0 / transform.getScaleX());
        }
        MapLayer[] layers = this.context.getLayers();
        this.labelCache.start();
        int length = layers.length;
        Transaction transaction = Transaction.AUTO_COMMIT;
        for (int i = 0; i < length; ++i) {
            MapLayer currLayer = layers[i];
            if (!currLayer.isVisible()) continue;
            if (this.layerIndexInfo[i] == null) {
                this.renderWithStreamingRenderer(currLayer, graphics, paintArea, envelope, transform);
                continue;
            }
            if (this.renderingStopRequested) {
                return;
            }
            if (this.renderingStopRequested) {
                return;
            }
            if (this.layerIndexInfo[i] == STREAMING_RENDERER_INFO) {
                this.renderWithStreamingRenderer(currLayer, graphics, paintArea, envelope, transform);
                continue;
            }
            this.labelCache.startLayer();
            Envelope bbox = envelope;
            try {
                Object mt;
                ShapefileDataStore ds = (ShapefileDataStore)currLayer.getFeatureSource().getDataStore();
                CoordinateReferenceSystem dataCRS = ds.getSchema().getDefaultGeometry().getCoordinateSystem();
                try {
                    mt = CRS.transform((CoordinateReferenceSystem)dataCRS, (CoordinateReferenceSystem)destinationCrs, (boolean)true);
                    bbox = JTS.transform((Envelope)bbox, (MathTransform)mt.inverse(), (int)10);
                }
                catch (Exception e) {
                    mt = null;
                }
                LinearTransform at = ProjectiveTransform.create((AffineTransform)transform);
                mt = mt == null ? at : ConcatenatedTransform.create((MathTransform)mt, (MathTransform)at);
                this.dbfheader = this.getDBFHeader(ds);
                if (currLayer.getFeatureSource() instanceof FeatureStore) {
                    transaction = ((FeatureStore)currLayer.getFeatureSource()).getTransaction();
                }
                this.processStylersNoCaching(graphics, ds, currLayer.getQuery(), bbox, paintArea, (MathTransform)mt, currLayer.getStyle(), this.layerIndexInfo[i], transaction);
            }
            catch (Exception exception) {
                this.fireErrorEvent(new Exception("Exception rendering layer " + currLayer, exception));
            }
            this.labelCache.endLayer(graphics, paintArea);
        }
        this.labelCache.end(graphics, paintArea);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Style cache hit ratio: " + this.styleFactory.getHitRatio() + " , hits " + this.styleFactory.getHits() + ", requests " + this.styleFactory.getRequests());
        }
    }

    private void renderWithStreamingRenderer(MapLayer layer, Graphics2D graphics, Rectangle paintArea, Envelope envelope, AffineTransform transform) {
        DefaultMapContext context = new DefaultMapContext(new MapLayer[]{layer});
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)context);
        renderer.setJava2DHints(this.getJava2DHints());
        renderer.setRendererHints(this.getRendererHints());
        renderer.paint(graphics, paintArea, envelope, transform);
    }

    private CoordinateReferenceSystem getForceCRSHint() {
        if (this.rendererHints == null) {
            return null;
        }
        Object crs = this.rendererHints.get("forceCRS");
        if (crs instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)crs;
        }
        return null;
    }

    static {
        COORDS = new Coordinate[5];
        ShapefileRenderer.COORDS[0] = new Coordinate(0.0, 0.0);
        ShapefileRenderer.COORDS[1] = new Coordinate(5.0, 0.0);
        ShapefileRenderer.COORDS[2] = new Coordinate(5.0, 5.0);
        ShapefileRenderer.COORDS[3] = new Coordinate(0.0, 5.0);
        ShapefileRenderer.COORDS[4] = new Coordinate(0.0, 0.0);
        LINE_GEOM = geomFactory.createLinearRing(COORDS);
        MULTI_LINE_GEOM = geomFactory.createMultiLineString(new LineString[]{LINE_GEOM});
        POLYGON_GEOM = geomFactory.createPolygon(LINE_GEOM, new LinearRing[0]);
        MULTI_POLYGON_GEOM = geomFactory.createMultiPolygon(new Polygon[]{POLYGON_GEOM});
        POINT_GEOM = geomFactory.createPoint(COORDS[2]);
        MULTI_POINT_GEOM = geomFactory.createMultiPoint(COORDS);
        DEFAULT_LISTENER = new DefaultRenderListener();
        NUM_SAMPLES = 200;
    }

    private static class DefaultRenderListener
    implements RenderListener {
        private DefaultRenderListener() {
        }

        public void featureRenderer(Feature feature) {
        }

        public void errorOccurred(Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

